/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.query;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.search.lucene.query.ResultDocument;
import java.io.IOException;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.lucene.search.Hits;

public class ResultDocuments
implements LogEnabled {
    private Logger logger;
    private Hits luceneHits;
    private ResultDocument[] sortedResults;
    private int nbHits;

    public void setUp(Hits h) {
        this.luceneHits = h;
        this.nbHits = h.length();
    }

    public void setUp(ResultDocument[] sr) {
        this.sortedResults = sr;
        this.nbHits = sr.length;
    }

    public void setSortedResults(ResultDocument[] sr) {
        this.sortedResults = sr;
        this.nbHits = sr.length;
        this.luceneHits = null;
    }

    public int getLength() {
        return this.nbHits;
    }

    public float getMaxScore() throws SDXException, IOException {
        return this.getDocument(0).getScore();
    }

    public ResultDocument getDocument(int i) throws SDXException {
        if (this.luceneHits != null && i < this.luceneHits.length()) {
            ResultDocument rDoc = null;
            try {
                if (this.luceneHits.doc(i) != null) {
                    rDoc = new ResultDocument();
                    rDoc.enableLogging(this.logger);
                    rDoc.setUp(this.luceneHits.doc(i), this.luceneHits.score(i));
                }
            }
            catch (IOException e) {
                String[] args = new String[]{e.getMessage()};
                throw new SDXException(this.logger, 4105, args, e);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                String[] args = new String[]{e.getMessage()};
                throw new SDXException(this.logger, 4105, args, e);
            }
            return rDoc;
        }
        return this.sortedResults[i];
    }

    public ResultDocument[] getDocuments() throws SDXException {
        if (this.luceneHits != null) {
            ResultDocument[] ret = new ResultDocument[this.getLength()];
            for (int i = 0; i < this.getLength(); ++i) {
                ResultDocument rDoc = new ResultDocument();
                rDoc.enableLogging(this.logger);
                try {
                    rDoc.setUp(this.luceneHits.doc(i), this.luceneHits.score(i));
                }
                catch (IOException e) {
                    String[] args = new String[]{e.getMessage()};
                    throw new SDXException(null, 4105, args, e);
                }
                ret[i] = rDoc;
            }
            return ret;
        }
        return this.sortedResults;
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }
}

