/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.query;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.search.lucene.Field;
import fr.gouv.culture.sdx.search.lucene.query.AbstractQuery;
import fr.gouv.culture.sdx.search.lucene.query.SearchLocations;
import org.apache.cocoon.ProcessingException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.TermQuery;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ExactFieldQuery
extends AbstractQuery {
    private String queryText;
    private Field field;

    public void setUp(SearchLocations sLocs, String fieldName, String q) throws SDXException {
        super.setSearchLocations(sLocs);
        if (q == null) {
            throw new SDXException(null, 4100, null, null);
        }
        this.field = this.searchLocations.getField(fieldName);
        if (this.field == null) {
            this.field = sLocs.getDefaultField();
        }
        if (this.field == null) {
            String[] args = new String[]{fieldName};
            throw new SDXException(this.logger, 4001, args, null);
        }
        this.queryText = q;
        this.luceneQuery = new TermQuery(new Term(this.field.getCode(), q));
    }

    public void toSAX(ContentHandler hdl) throws SAXException, ProcessingException {
        String sdxNsUri = "http://www.culture.gouv.fr/ns/sdx/sdx";
        String sdxNsPrefix = "sdx";
        String localName = "query";
        String qName = sdxNsPrefix + ":" + localName;
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "type", "type", "CDATA", "exactField");
        atts = super.addAttributesLucene(atts);
        atts = super.addAttributesText(atts);
        atts.addAttribute("", "field", "field", "CDATA", this.field.getCode());
        hdl.startElement(sdxNsUri, localName, qName, atts);
        if (this.filter != null) {
            this.filter.toSAX(hdl);
        }
        if (this.baseQuery != null) {
            String bqLocalName = "baseQuery";
            String bqQName = sdxNsPrefix + ":" + bqLocalName;
            AttributesImpl emptyAtts = new AttributesImpl();
            hdl.startElement(sdxNsUri, bqLocalName, bqQName, emptyAtts);
            this.baseQuery.toSAX(hdl);
            hdl.endElement(sdxNsUri, bqLocalName, bqQName);
        }
        hdl.endElement(sdxNsUri, localName, qName);
    }
}

