/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.analysis;

import fr.gouv.culture.sdx.search.lucene.analysis.DefaultAnalyzer;
import fr.gouv.culture.sdx.search.lucene.analysis.filter.BrazilianStemFilter;
import java.io.File;
import java.io.Reader;
import java.util.Hashtable;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.de.WordlistLoader;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;

public class Analyzer_br
extends DefaultAnalyzer {
    public static final String[] BRAZILIAN_STOP_WORDS = new String[]{"a", "ainda", "alem", "ambas", "ambos", "antes", "ao", "aonde", "aos", "apos", "aquele", "aqueles", "as", "assim", "com", "como", "contra", "contudo", "cuja", "cujas", "cujo", "cujos", "da", "das", "de", "dela", "dele", "deles", "demais", "depois", "desde", "desta", "deste", "dispoe", "dispoem", "diversa", "diversas", "diversos", "do", "dos", "durante", "e", "ela", "elas", "ele", "eles", "em", "entao", "entre", "essa", "essas", "esse", "esses", "esta", "estas", "este", "estes", "ha", "isso", "isto", "logo", "mais", "mas", "mediante", "menos", "mesma", "mesmas", "mesmo", "mesmos", "na", "nas", "nao", "nas", "nem", "nesse", "neste", "nos", "o", "os", "ou", "outra", "outras", "outro", "outros", "pelas", "pelas", "pelo", "pelos", "perante", "pois", "por", "porque", "portanto", "proprio", "propios", "quais", "qual", "qualquer", "quando", "quanto", "que", "quem", "quer", "se", "seja", "sem", "sendo", "seu", "seus", "sob", "sobre", "sua", "suas", "tal", "tambem", "teu", "teus", "toda", "todas", "todo", "todos", "tua", "tuas", "tudo", "um", "uma", "umas", "uns"};

    public Analyzer_br(String[] stopwords) {
        this.stopTable = StopFilter.makeStopTable((String[])stopwords);
    }

    public Analyzer_br(Hashtable stopwords) {
        this.stopTable = stopwords;
    }

    public Analyzer_br(File stopwords) {
        this.stopTable = WordlistLoader.getWordtable((File)stopwords);
    }

    public void setStemExclusionTable(String[] exclusionlist) {
        this.excludeTable = StopFilter.makeStopTable((String[])exclusionlist);
    }

    public void setStemExclusionTable(Hashtable exclusionlist) {
        this.excludeTable = exclusionlist;
    }

    public void setStemExclusionTable(File exclusionlist) {
        this.excludeTable = WordlistLoader.getWordtable((File)exclusionlist);
    }

    public final TokenStream tokenStream(String fieldName, Reader reader) {
        Object result = new StandardTokenizer(reader);
        result = new StandardFilter((TokenStream)result);
        result = new StopFilter((TokenStream)result, this.stopTable);
        result = new BrazilianStemFilter((TokenStream)result, this.excludeTable);
        result = new LowerCaseFilter((TokenStream)result);
        return result;
    }
}

