/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Stack;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.ElemTemplateElement;

public class StackGuard {
    public static int m_recursionLimit = -1;
    ElemTemplateElement m_xslRule;
    int m_sourceXML;
    Stack stack = new Stack();

    public int getRecursionLimit() {
        return m_recursionLimit;
    }

    public void setRecursionLimit(int limit) {
        m_recursionLimit = limit;
    }

    public StackGuard() {
    }

    public StackGuard(ElemTemplateElement xslTemplate, int sourceXML) {
        this.m_xslRule = xslTemplate;
        this.m_sourceXML = sourceXML;
    }

    public boolean equals(Object obj) {
        return ((StackGuard)obj).m_xslRule.equals(this.m_xslRule) && ((StackGuard)obj).m_sourceXML == this.m_sourceXML;
    }

    public void print(PrintWriter pw) {
    }

    public void checkForInfinateLoop(StackGuard guard) throws TransformerException {
        int nRules = this.stack.size();
        int loopCount = 0;
        int i = nRules - 1;
        while (i >= 0) {
            if (this.stack.elementAt(i).equals(guard)) {
                ++loopCount;
            }
            if (loopCount >= m_recursionLimit) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                pw.println("Infinite loop diagnosed!  Stack trace:");
                int k = 0;
                while (k < nRules) {
                    pw.println("Source Elem #" + k + " ");
                    StackGuard guardOnStack = (StackGuard)this.stack.elementAt(i);
                    guardOnStack.print(pw);
                    ++k;
                }
                pw.println("Source Elem #" + k + " ");
                guard.print(pw);
                pw.println("End of infinite loop diagnosis.");
                throw new TransformerException(sw.getBuffer().toString());
            }
            --i;
        }
    }

    public void push(ElemTemplateElement xslTemplate, int sourceXML) throws TransformerException {
        StackGuard guard = new StackGuard(xslTemplate, sourceXML);
        this.checkForInfinateLoop(guard);
        this.stack.push(guard);
    }

    public void pop() {
        this.stack.pop();
    }
}

