/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class RangeQuery
extends Query {
    private Term lowerTerm;
    private Term upperTerm;
    private boolean inclusive;
    private BooleanQuery hiLiteQuery = new BooleanQuery();

    public RangeQuery(Term lowerTerm, Term upperTerm, boolean inclusive) {
        if (lowerTerm == null && upperTerm == null) {
            throw new IllegalArgumentException("At least one term must be non-null");
        }
        if (lowerTerm != null && upperTerm != null && lowerTerm.field() != upperTerm.field()) {
            throw new IllegalArgumentException("Both terms must be for the same field");
        }
        this.lowerTerm = lowerTerm != null ? lowerTerm : new Term(upperTerm.field(), "");
        this.upperTerm = upperTerm;
        this.inclusive = inclusive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query rewrite(IndexReader reader) throws IOException {
        BooleanQuery query = new BooleanQuery();
        TermEnum enumerator = reader.terms(this.lowerTerm);
        try {
            Term term;
            boolean checkLower = false;
            if (!this.inclusive) {
                checkLower = true;
            }
            String testField = this.getField();
            while ((term = enumerator.term()) != null && term.field() == testField) {
                if (!checkLower || term.text().compareTo(this.lowerTerm.text()) > 0) {
                    int compare;
                    checkLower = false;
                    if (this.upperTerm != null && ((compare = this.upperTerm.text().compareTo(term.text())) < 0 || !this.inclusive && compare == 0)) break;
                    TermQuery tq = new TermQuery(term);
                    tq.setBoost(this.getBoost());
                    query.add(tq, false, false);
                }
                if (enumerator.next()) continue;
                break;
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            enumerator.close();
            throw throwable;
        }
        enumerator.close();
        this.hiLiteQuery.add(query, false, false);
        return query;
    }

    public Query combine(Query[] queries) {
        return Query.mergeBooleanQueries(queries);
    }

    private String getField() {
        return this.lowerTerm != null ? this.lowerTerm.field() : this.upperTerm.field();
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        if (!this.getField().equals(field)) {
            buffer.append(this.getField());
            buffer.append(":");
        }
        buffer.append(this.inclusive ? "[" : "{");
        buffer.append(this.lowerTerm != null ? this.lowerTerm.text() : "null");
        buffer.append(" TO ");
        buffer.append(this.upperTerm != null ? this.upperTerm.text() : "null");
        buffer.append(this.inclusive ? "]" : "}");
        if (this.getBoost() != 1.0f) {
            buffer.append("^");
            buffer.append(Float.toString(this.getBoost()));
        }
        return buffer.toString();
    }

    public BooleanQuery getHiLiteQuery() {
        return this.hiLiteQuery;
    }
}

