/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.TimeZone;
import org.mortbay.util.ByteArrayISO8859Writer;
import org.mortbay.util.Code;
import org.mortbay.util.DateCache;
import org.mortbay.util.Frame;
import org.mortbay.util.LogSink;
import org.mortbay.util.RolloverFileOutputStream;
import org.mortbay.util.StringUtil;

public class OutputStreamLogSink
implements LogSink {
    public static final char OPT_TIMESTAMP = 't';
    public static final char OPT_LABEL = 'L';
    public static final char OPT_TAG = 'T';
    public static final char OPT_STACKSIZE = 's';
    public static final char OPT_STACKTRACE = 'S';
    public static final char OPT_ONELINE = 'O';
    private static final String __lineSeparator = System.getProperty("line.separator");
    private static final String __indentBase = "";
    private static final String __indentSeparator = __lineSeparator + "";
    private static final int __lineSeparatorLen = __lineSeparator.length();
    private int _retainDays = Integer.getInteger("LOG_FILE_RETAIN_DAYS", 31);
    protected DateCache _dateFormat = new DateCache(System.getProperty("LOG_DATE_FORMAT", "HH:mm:ss.SSS"));
    protected String _logTimezone = System.getProperty("LOG_TIME_ZONE");
    protected boolean _logTimeStamps;
    protected boolean _logLabels;
    protected boolean _logTags;
    protected boolean _logStackSize;
    protected boolean _logStackTrace;
    protected boolean _logOneLine;
    private String _filename;
    private boolean _append;
    protected boolean _flushOn;
    protected int _bufferSize;
    protected boolean _reopen;
    protected transient boolean _started;
    protected transient OutputStream _out;
    protected transient ByteArrayISO8859Writer _buffer;

    public OutputStreamLogSink() throws IOException {
        if (this._logTimezone != null) {
            this._dateFormat.getFormat().setTimeZone(TimeZone.getTimeZone(this._logTimezone));
        }
        this._logTimeStamps = true;
        this._logLabels = true;
        this._logTags = true;
        this._logStackSize = true;
        this._logStackTrace = false;
        this._logOneLine = false;
        this._append = true;
        this._flushOn = true;
        this._bufferSize = 2048;
        this._reopen = false;
        this._filename = System.getProperty("LOG_FILE");
        if (this._filename == null) {
            this._out = System.err;
        }
    }

    public OutputStreamLogSink(String filename) {
        if (this._logTimezone != null) {
            this._dateFormat.getFormat().setTimeZone(TimeZone.getTimeZone(this._logTimezone));
        }
        this._logTimeStamps = true;
        this._logLabels = true;
        this._logTags = true;
        this._logStackSize = true;
        this._logStackTrace = false;
        this._logOneLine = false;
        this._append = true;
        this._flushOn = true;
        this._bufferSize = 2048;
        this._reopen = false;
        this._filename = filename;
    }

    public void setOptions(String logOptions) {
        this.setOptions(logOptions.indexOf(116) >= 0, logOptions.indexOf(76) >= 0, logOptions.indexOf(84) >= 0, logOptions.indexOf(115) >= 0, logOptions.indexOf(83) >= 0, logOptions.indexOf(79) >= 0);
    }

    public String getOptions() {
        return (this._logTimeStamps ? "t" : __indentBase) + (this._logLabels ? "L" : __indentBase) + (this._logTags ? "T" : __indentBase) + (this._logStackSize ? "s" : __indentBase) + (this._logStackTrace ? "S" : __indentBase) + (this._logOneLine ? "O" : __indentBase);
    }

    public void setOptions(boolean logTimeStamps, boolean logLabels, boolean logTags, boolean logStackSize, boolean logStackTrace, boolean logOneLine) {
        this._logTimeStamps = logTimeStamps;
        this._logLabels = logLabels;
        this._logTags = logTags;
        this._logStackSize = logStackSize;
        this._logStackTrace = logStackTrace;
        this._logOneLine = logOneLine;
    }

    public String getLogDateFormat() {
        return this._dateFormat.getFormatString();
    }

    public void setLogDateFormat(String logDateFormat) {
        this._dateFormat = new DateCache(logDateFormat);
        if (this._logTimezone != null) {
            this._dateFormat.getFormat().setTimeZone(TimeZone.getTimeZone(this._logTimezone));
        }
    }

    public String getLogTimezone() {
        return this._logTimezone;
    }

    public void setLogTimezone(String logTimezone) {
        this._logTimezone = logTimezone;
        if (this._dateFormat != null && this._logTimezone != null) {
            this._dateFormat.getFormat().setTimeZone(TimeZone.getTimeZone(this._logTimezone));
        }
    }

    public String getLogTimeZone() {
        return this._logTimezone;
    }

    public void setLogTimeZone(String logTimezone) {
        this._logTimezone = logTimezone;
        if (this._dateFormat != null && this._logTimezone != null) {
            this._dateFormat.getFormat().setTimeZone(TimeZone.getTimeZone(this._logTimezone));
        }
    }

    public boolean isLogTimeStamps() {
        return this._logTimeStamps;
    }

    public void setLogTimeStamps(boolean logTimeStamps) {
        this._logTimeStamps = logTimeStamps;
    }

    public boolean isLogLabels() {
        return this._logLabels;
    }

    public void setLogLabels(boolean logLabels) {
        this._logLabels = logLabels;
    }

    public boolean isLogTags() {
        return this._logTags;
    }

    public void setLogTags(boolean logTags) {
        this._logTags = logTags;
    }

    public boolean isLogStackSize() {
        return this._logStackSize;
    }

    public void setLogStackSize(boolean logStackSize) {
        this._logStackSize = logStackSize;
    }

    public boolean isLogStackTrace() {
        return this._logStackTrace;
    }

    public void setLogStackTrace(boolean logStackTrace) {
        this._logStackTrace = logStackTrace;
    }

    public boolean isLogOneLine() {
        return this._logOneLine;
    }

    public void setLogOneLine(boolean logOneLine) {
        this._logOneLine = logOneLine;
    }

    public boolean isAppend() {
        return this._append;
    }

    public void setAppend(boolean a) {
        this._append = a;
    }

    public synchronized void setOutputStream(OutputStream out) {
        this._reopen = this.isStarted() && out != out;
        this._filename = null;
        if (this._buffer != null) {
            this._buffer.resetWriter();
        }
        this._out = out;
    }

    public OutputStream getOutputStream() {
        return this._out;
    }

    public synchronized void setFilename(String filename) {
        if (filename != null && (filename = filename.trim()).length() == 0) {
            filename = null;
        }
        this._reopen = this.isStarted() && (this._filename == null && filename != null || this._filename != null && !this._filename.equals(filename));
        this._filename = filename;
        if (!this.isStarted() && this._filename != null) {
            this._out = null;
        }
    }

    public String getFilename() {
        return this._filename;
    }

    public String getDatedFilename() {
        if (this._filename == null) {
            return null;
        }
        if (this._out == null || !(this._out instanceof RolloverFileOutputStream)) {
            return null;
        }
        return ((RolloverFileOutputStream)this._out).getDatedFilename();
    }

    public int getRetainDays() {
        return this._retainDays;
    }

    public void setRetainDays(int retainDays) {
        this._reopen = this.isStarted() && this._retainDays != retainDays;
        this._retainDays = retainDays;
    }

    public void setFlushOn(boolean on) {
        block2: {
            this._flushOn = on;
            if (!on || this._out == null) break block2;
            try {
                this._out.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean getFlushOn() {
        return this._flushOn;
    }

    public synchronized void log(String tag, Object msg, Frame frame, long time) {
        String smsg;
        StringBuffer buf = new StringBuffer(160);
        if (this._logTimeStamps) {
            buf.append(this._dateFormat.format(time));
            buf.append(' ');
        }
        if (this._logTags) {
            buf.append(tag);
        }
        if (this._logLabels && frame != null) {
            buf.append(frame.toString());
        }
        if (this._logStackSize && frame != null) {
            if (frame.getDepth() < 10) {
                buf.append('0');
            }
            buf.append(Integer.toString(frame.getDepth()));
            buf.append("> ");
        }
        String nl = __lineSeparator;
        if (this._logLabels && !this._logOneLine && this._buffer.size() > 0) {
            buf.append(nl);
        }
        String string = msg == null ? "???" : (smsg = msg instanceof String ? (String)msg : msg.toString());
        if (this._logOneLine) {
            smsg = StringUtil.replace(smsg, "\r\n", "<|");
            smsg = StringUtil.replace(smsg, "\r", "<");
            smsg = StringUtil.replace(smsg, "\n", "|");
        } else {
            smsg = StringUtil.replace(smsg, "\r\n", "<|");
            smsg = StringUtil.replace(smsg, "\r", "<|");
            smsg = StringUtil.replace(smsg, "\n", "<|");
            smsg = StringUtil.replace(smsg, "<|", nl);
        }
        buf.append(smsg);
        if (this._logStackTrace && frame != null) {
            buf.append(nl);
            buf.append(frame.getStack());
        }
        this.log(buf.toString());
    }

    public synchronized void log(String formattedLog) {
        if (this._reopen) {
            this.stop();
            this.start();
        }
        try {
            this._buffer.write(formattedLog);
            this._buffer.write(StringUtil.__LINE_SEPARATOR);
            if (this._flushOn || this._buffer.size() > this._bufferSize) {
                this._buffer.writeTo(this._out);
                this._buffer.resetWriter();
                this._out.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void start() {
        this._buffer = new ByteArrayISO8859Writer(this._bufferSize);
        this._reopen = false;
        if (this._started) {
            return;
        }
        if (this._out == null && this._filename != null) {
            try {
                RolloverFileOutputStream rfos = new RolloverFileOutputStream(this._filename, this._append, this._retainDays);
                this._out = rfos;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this._out == null) {
            this._out = System.err;
        }
        this._started = true;
    }

    public synchronized void stop() {
        block9: {
            this._started = false;
            if (this._out != null) {
                block8: {
                    try {
                        if (this._buffer.size() > 0) {
                            this._buffer.writeTo(this._out);
                        }
                        this._out.flush();
                        this._buffer = null;
                    }
                    catch (Exception e) {
                        if (!Code.debug()) break block8;
                        e.printStackTrace();
                    }
                }
                Thread.yield();
            }
            if (this._out != null && this._out != System.err) {
                try {
                    this._out.close();
                }
                catch (Exception e) {
                    if (!Code.debug()) break block9;
                    e.printStackTrace();
                }
            }
        }
        if (this._filename != null) {
            this._out = null;
        }
    }

    public boolean isStarted() {
        return this._started;
    }
}

