/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.deli;

import com.hp.hpl.deli.ProfileDiff;
import com.hp.hpl.deli.Workspace;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

class ProcessHttpRequest {
    protected Vector referenceVector = new Vector();
    protected Vector orderedDiffVector = new Vector();
    protected HashMap profileDiffMap = new HashMap();
    protected HashMap profileDiffDigestMap = new HashMap();
    protected Workspace workspace;

    protected void supportLegacyDevices(String string) {
        this.workspace.printDebug("ProcessHttpRequest: Querying legacy device database");
        if (this.workspace.supportLegacyDevices) {
            String string2 = this.workspace.legacyDevice.getReference(string);
            if (string2 != null) {
                this.referenceVector.add(string2);
            } else {
                this.workspace.printDebug("ProcessHttpRequest: Unable to find useragent " + string + " in legacy device database");
            }
        } else {
            this.workspace.printDebug("ProcessHttpRequest: Legacy device support disabled");
        }
    }

    protected void validateProfileDiffs(HttpServletRequest httpServletRequest) throws Exception {
        String string;
        Object object;
        int n = 0;
        while (n < this.profileDiffDigestMap.size()) {
            object = new Integer(n + 1);
            string = (String)this.profileDiffDigestMap.get(object);
            String string2 = (String)this.profileDiffMap.get(object);
            if (this.workspace.profileDiffDigestVerification) {
                String string3 = ProfileDiff.calculateProfileDiffDigest(string2, this.workspace.normaliseWhitespaceInProfileDiff);
                if (!string.equals(string3)) {
                    this.workspace.printDebug("ProcessHttpRequest|ValidateProfileDiff: ");
                    this.workspace.printDebug("ProfileDiffDigest and ProfileDiff do not match");
                    this.workspace.printDebug("\tProfileDiffDigest:   " + string);
                    this.workspace.printDebug("\tCalculatedDiffDigest:" + string3);
                } else {
                    this.orderedDiffVector.add(string2);
                }
            } else {
                this.orderedDiffVector.add(string2);
            }
            ++n;
        }
        if (this.referenceVector.size() == 0) {
            this.workspace.printDebug("ProcessHttpRequest: No headers found");
            object = httpServletRequest.getHeaders("user-agent");
            while (object.hasMoreElements()) {
                string = (String)object.nextElement();
                this.supportLegacyDevices(string);
            }
        }
    }

    protected Vector getReferences() {
        return this.referenceVector;
    }

    protected Vector getDiffs() {
        return this.orderedDiffVector;
    }

    ProcessHttpRequest(Workspace workspace, HttpServletRequest httpServletRequest) {
        this.workspace = workspace;
        this.workspace.printDebug("UAProfProcessHttpRequest: Starting to process HTTP request");
        String string = null;
        int n = 0;
        try {
            String string2;
            Object object;
            Object object2;
            Enumeration enumeration = httpServletRequest.getHeaders("x-wap-profile");
            if (!enumeration.hasMoreElements()) {
                enumeration = httpServletRequest.getHeaders("profile");
            }
            if (!enumeration.hasMoreElements()) {
                object2 = httpServletRequest.getHeaders("opt");
                while (object2.hasMoreElements()) {
                    object = (String)object2.nextElement();
                    string = ((String)object).substring(((String)object).indexOf("ns=") + 2, ((String)object).length());
                }
                enumeration = httpServletRequest.getHeaders(string + "-profile");
            }
            while (enumeration.hasMoreElements()) {
                object2 = (String)enumeration.nextElement();
                object = new StringTokenizer((String)object2, "\",");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    string2 = ((StringTokenizer)object).nextToken();
                    if (string2.startsWith("http")) {
                        this.referenceVector.add(string2);
                    }
                    if (string2.indexOf(45) <= 0) continue;
                    int n2 = Integer.parseInt(string2.substring(0, string2.indexOf(45)));
                    if (n2 > n) {
                        n = n2;
                    }
                    String string3 = string2.substring(string2.indexOf(45) + 1, string2.length());
                    this.profileDiffDigestMap.put(new Integer(n2), string3);
                }
            }
            object2 = httpServletRequest.getHeaders("x-wap-profile-diff");
            if (!object2.hasMoreElements()) {
                object2 = httpServletRequest.getHeaders("profile-diff");
            }
            if (!object2.hasMoreElements()) {
                object2 = httpServletRequest.getHeaders(string + "-profile-diff");
            }
            if (!object2.hasMoreElements()) {
                int n3 = 1;
                while (n3 <= n) {
                    enumeration = httpServletRequest.getHeaders(string + "-profile-diff-" + n3);
                    while (object2.hasMoreElements()) {
                        string2 = (String)object2.nextElement();
                        String string4 = string2.trim();
                        if (string4.charAt(0) == '\"') {
                            this.profileDiffMap.put(new Integer(n3), string4.substring(1, string4.length() - 1));
                            continue;
                        }
                        this.profileDiffMap.put(new Integer(n3), string4);
                    }
                    ++n3;
                }
            }
            while (object2.hasMoreElements()) {
                String string5 = (String)object2.nextElement();
                int n4 = Integer.parseInt(string5.substring(0, string5.indexOf(59)));
                String string6 = string5.substring(string5.indexOf(59) + 1, string5.length());
                string6.trim();
                if (string6.charAt(0) == '\"') {
                    this.profileDiffMap.put(new Integer(n4), string6.substring(1, string6.length() - 1));
                    continue;
                }
                this.profileDiffMap.put(new Integer(n4), string6);
            }
            if (this.profileDiffDigestMap.size() != this.profileDiffMap.size()) {
                this.workspace.printDebug("UAProfProcessHttpRequest: ");
                this.workspace.printDebug("The number of profile-diff-digests and profile-diffs do not match");
                this.workspace.printDebug("Dumping the request headers");
                Enumeration enumeration2 = httpServletRequest.getHeaderNames();
                while (enumeration2.hasMoreElements()) {
                    String string7 = (String)enumeration2.nextElement();
                    String string8 = httpServletRequest.getHeader(string7);
                    this.workspace.printDebug(string7 + ": " + string8);
                }
                this.workspace.printDebug("End of request headers");
            }
            this.validateProfileDiffs(httpServletRequest);
        }
        catch (Exception exception) {
            this.workspace.printDebug("ProcessHttpRequest: Could not process HTTP request");
            this.workspace.printDebug(exception.toString());
        }
    }
}

