/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.common;

import com.hp.hpl.mesa.rdf.jena.common.Util;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;

class XMLContentHandler
implements ContentHandler {
    String content;
    boolean active;
    boolean elementEmpty = false;

    XMLContentHandler() {
    }

    public void activate() {
        this.active = true;
        this.content = "";
    }

    public String deActivate() {
        String string = this.content;
        this.active = false;
        this.content = null;
        return string;
    }

    public void characters(char[] cArray, int n, int n2) {
        if (!this.active) {
            return;
        }
        this.closeOpenElement();
        this.content = this.content + Util.substituteStandardEntities(String.valueOf(cArray, n, n2));
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
        this.characters(cArray, n, n2);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (!this.active) {
            return;
        }
        this.closeOpenElement();
        this.content = this.content + "<" + string3;
        int n = 0;
        while (n < attributes.getLength()) {
            this.content = this.content + " " + attributes.getQName(n) + "=\"" + Util.replace(attributes.getValue(n), "\"", "&quote;") + "\"";
            ++n;
        }
        this.elementEmpty = true;
    }

    public void endElement(String string, String string2, String string3) {
        if (!this.active) {
            return;
        }
        this.content = this.elementEmpty ? this.content + "/>" : this.content + "</" + string3 + ">";
        this.elementEmpty = false;
    }

    public void processingInstruction(String string, String string2) {
        if (!this.active) {
            return;
        }
        this.closeOpenElement();
        this.content = this.content + "<?" + string + " " + string2 + "?>";
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void startPrefixMapping(String string, String string2) {
    }

    public void endPrefixMapping(String string) {
    }

    public void skippedEntity(String string) {
    }

    public void setDocumentLocator(Locator locator) {
    }

    void closeOpenElement() {
        if (this.elementEmpty) {
            this.content = this.content + ">";
            this.elementEmpty = false;
        }
    }
}

