/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components;

import java.util.HashSet;
import java.util.Set;
import org.apache.avalon.excalibur.component.ExcaliburComponentSelector;
import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;

public class ExtendedComponentSelector
extends ExcaliburComponentSelector {
    protected RoleManager roles;
    protected ComponentSelector parentSelector;
    protected ClassLoader classLoader;
    protected Set parentComponents;
    protected String roleName;
    protected String defaultHint;

    public ExtendedComponentSelector() {
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    public ExtendedComponentSelector(ClassLoader loader) {
        super(loader);
        this.classLoader = loader == null ? Thread.currentThread().getContextClassLoader() : loader;
    }

    protected String getComponentInstanceName() {
        return null;
    }

    protected String getClassAttributeName() {
        return "class";
    }

    protected String getDefaultHintAttributeName() {
        return "default";
    }

    public void setRoleManager(RoleManager roles) {
        super.setRoleManager(roles);
        this.roles = roles;
    }

    public void setParentSelector(ComponentSelector parent) {
        if (this.parentSelector != null) {
            throw new IllegalStateException("Parent selector is already set");
        }
        this.parentSelector = parent;
        this.parentComponents = new HashSet();
    }

    protected String getRoleName(Configuration config2) {
        String roleName = config2.getAttribute("role", null);
        if (roleName == null && this.roles != null) {
            roleName = this.roles.getRoleForName(config2.getName());
        }
        return roleName;
    }

    public void configure(Configuration config2) throws ConfigurationException {
        this.roleName = this.getRoleName(config2);
        DefaultConfiguration temp = new DefaultConfiguration(config2.getName(), config2.getLocation());
        if (config2.getAttribute("role", null) != null) {
            temp.setAttribute("role", this.roleName);
        }
        super.configure((Configuration)temp);
        this.defaultHint = config2.getAttribute(this.getDefaultHintAttributeName(), null);
        String compInstanceName = this.getComponentInstanceName();
        Configuration[] instances = config2.getChildren();
        int i = 0;
        while (i < instances.length) {
            Configuration instance = instances[i];
            String hint = instance.getAttribute("name").trim();
            String classAttr = instance.getAttribute(this.getClassAttributeName(), null);
            String className = compInstanceName == null ? (classAttr == null ? this.roles.getDefaultClassNameForHint(this.roleName, instance.getName()) : classAttr.trim()) : (compInstanceName.equals(instance.getName()) ? (classAttr == null ? null : classAttr.trim()) : this.roles.getDefaultClassNameForHint(this.roleName, instance.getName()));
            if (className == null) {
                String message = "Unable to determine class name for component named '" + hint + "' at " + instance.getLocation();
                this.getLogger().error(message);
                throw new ConfigurationException(message);
            }
            try {
                Class<?> clazz = this.classLoader.loadClass(className);
                this.addComponent(hint, clazz, instance);
            }
            catch (Exception e) {
                String message = "Could not load class " + className + " for component named '" + hint + "' at " + instance.getLocation();
                this.getLogger().error(message, (Throwable)e);
                throw new ConfigurationException(message, (Throwable)e);
            }
            ++i;
        }
    }

    public String getDefaultHint() {
        return this.defaultHint;
    }

    public Component select(Object hint) throws ComponentException {
        if (hint == null) {
            hint = this.defaultHint;
        }
        if (this.parentSelector == null) {
            return super.select(hint);
        }
        try {
            return super.select(hint);
        }
        catch (ComponentException ce) {
            Component component = this.parentSelector.select(hint);
            this.parentComponents.add(component);
            return component;
        }
    }

    public void release(Component component) {
        if (this.parentComponents != null && this.parentComponents.remove(component)) {
            this.parentSelector.release(component);
        } else {
            super.release(component);
        }
    }

    public boolean hasComponent(Object hint) {
        boolean exists = super.hasComponent(hint);
        if (!exists && this.parentSelector != null) {
            exists = this.parentSelector.hasComponent(hint);
        }
        return exists;
    }
}

