/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.acting.AbstractComplementaryConfigurableAction;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ImageDirectoryGenerator;

public abstract class AbstractDatabaseAction
extends AbstractComplementaryConfigurableAction
implements Configurable,
Disposable {
    protected Map files = new HashMap();
    protected static final Map typeConstants;
    protected ComponentSelector dbselector;

    public void compose(ComponentManager manager) throws ComponentException {
        this.dbselector = (ComponentSelector)manager.lookup(DataSourceComponent.ROLE + "Selector");
        super.compose(manager);
    }

    protected final DataSourceComponent getDataSource(Configuration conf) throws ComponentException {
        Configuration dsn = conf.getChild("connection");
        return (DataSourceComponent)this.dbselector.select((Object)dsn.getValue(""));
    }

    protected final boolean isLargeObject(String type) {
        if ("ascii".equals(type)) {
            return true;
        }
        if ("binary".equals(type)) {
            return true;
        }
        return "image".equals(type);
    }

    protected Object getColumn(ResultSet set, Request request, Configuration entry) throws Exception {
        Integer type = (Integer)typeConstants.get(entry.getAttribute("type"));
        String attribute = entry.getAttribute("param", "");
        String dbcol = entry.getAttribute("dbcol", "");
        Object value = null;
        switch (type) {
            case 2005: {
                Clob dbClob = set.getClob(dbcol);
                int length = (int)dbClob.length();
                BufferedInputStream asciiStream = new BufferedInputStream(dbClob.getAsciiStream());
                byte[] buffer = new byte[length];
                ((InputStream)asciiStream).read(buffer);
                String str = new String(buffer);
                ((InputStream)asciiStream).close();
                value = str;
                break;
            }
            case -5: {
                value = set.getBigDecimal(dbcol);
                break;
            }
            case -6: {
                value = new Byte(set.getByte(dbcol));
                break;
            }
            case 12: {
                value = set.getString(dbcol);
                break;
            }
            case 91: {
                value = set.getDate(dbcol);
                break;
            }
            case 8: {
                value = new Double(set.getDouble(dbcol));
                break;
            }
            case 6: {
                value = new Float(set.getFloat(dbcol));
                break;
            }
            case 4: {
                value = new Integer(set.getInt(dbcol));
                break;
            }
            case 2: {
                value = new Long(set.getLong(dbcol));
                break;
            }
            case 5: {
                value = new Short(set.getShort(dbcol));
                break;
            }
            case 92: {
                value = set.getTime(dbcol);
                break;
            }
            case 93: {
                value = set.getTimestamp(dbcol);
                break;
            }
            case 2003: {
                value = set.getArray(dbcol);
                break;
            }
            case -7: {
                value = new Integer(set.getInt(dbcol));
                break;
            }
            case 1: {
                value = new Integer(set.getInt(dbcol));
                break;
            }
            case 2002: {
                value = (Struct)set.getObject(dbcol);
                break;
            }
            case 1111: {
                value = set.getObject(dbcol);
                break;
            }
            default: {
                value = "";
            }
        }
        this.setRequestAttribute(request, attribute, value);
        return value;
    }

    protected void setColumn(PreparedStatement statement, int position, Request request, Configuration entry) throws Exception {
        this.setColumn(statement, position, request, entry, entry.getAttribute("param", ""));
    }

    protected void setColumn(PreparedStatement statement, int position, Request request, Configuration entry, String param) throws Exception {
        Object value = request.getParameter(param);
        if (value == null) {
            value = request.getAttribute(param);
        }
        if (value == null) {
            value = request.get(param);
        }
        this.setColumn(statement, position, request, entry, param, value);
    }

    protected void setColumn(PreparedStatement statement, int position, Request request, Configuration entry, String param, Object value) throws Exception {
        this.setColumn(statement, position, request, entry, param, value, 0);
    }

    protected void setColumn(PreparedStatement statement, int position, Request request, Configuration entry, String param, Object value, int rowIndex) throws Exception {
        String typeName;
        Integer typeObject;
        this.getLogger().debug("Setting column " + position + " named " + param + " with value " + value);
        if (value instanceof String) {
            value = ((String)value).trim();
        }
        if ((typeObject = (Integer)typeConstants.get(typeName = entry.getAttribute("type"))) == null) {
            throw new SQLException("Can't set column because the type " + typeName + " is unrecognized");
        }
        if (!(value != null || typeName.equals("image-width") || typeName.equals("image-height") || typeName.equals("image-size") || typeName.equals("row-index") || typeName.equals("image-mime-type"))) {
            statement.setNull(position, typeObject);
            return;
        }
        if ("".equals(value)) {
            switch (typeObject) {
                case 1: 
                case 12: 
                case 2005: {
                    break;
                }
                case 4: {
                    if (typeName.equals("image-width") || typeName.equals("image-height") || typeName.equals("image-size") || typeName.equals("row-index")) break;
                }
                default: {
                    statement.setNull(position, typeObject);
                    return;
                }
            }
        }
        this.setRequestAttribute(request, param, value);
        switch (typeObject) {
            case 2005: {
                int length = -1;
                BufferedInputStream asciiStream = null;
                if (value instanceof File) {
                    File asciiFile = (File)value;
                    asciiStream = new BufferedInputStream(new FileInputStream(asciiFile));
                    length = (int)asciiFile.length();
                } else {
                    String asciiText = (String)value;
                    asciiStream = new BufferedInputStream(new ByteArrayInputStream(asciiText.getBytes()));
                    length = asciiText.length();
                }
                statement.setAsciiStream(position, (InputStream)asciiStream, length);
                break;
            }
            case -5: {
                BigDecimal bd = null;
                bd = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal((String)value);
                statement.setBigDecimal(position, bd);
                break;
            }
            case -6: {
                Byte b = null;
                b = value instanceof Byte ? (Byte)value : new Byte((String)value);
                statement.setByte(position, b);
                break;
            }
            case 91: {
                Date d = null;
                d = value instanceof Date ? (Date)value : (value instanceof java.util.Date ? new Date(((java.util.Date)value).getTime()) : new Date(this.dateValue((String)value, entry.getAttribute("format", "M/d/yyyy"))));
                statement.setDate(position, d);
                break;
            }
            case 8: {
                Double db = null;
                db = value instanceof Double ? (Double)value : new Double((String)value);
                statement.setDouble(position, db);
                break;
            }
            case 6: {
                Float f = null;
                f = value instanceof Float ? (Float)value : new Float((String)value);
                statement.setFloat(position, f.floatValue());
                break;
            }
            case 2: {
                Long l = null;
                l = value instanceof Long ? (Long)value : new Long((String)value);
                statement.setLong(position, l);
                break;
            }
            case 5: {
                Short s = null;
                s = value instanceof Short ? (Short)value : new Short((String)value);
                statement.setShort(position, s);
                break;
            }
            case 92: {
                Time t = null;
                t = value instanceof Time ? (Time)value : new Time(this.dateValue((String)value, entry.getAttribute("format", "h:m:s a")));
                statement.setTime(position, t);
                break;
            }
            case 93: {
                Timestamp ts = null;
                ts = value instanceof Time ? (Timestamp)value : new Timestamp(this.dateValue((String)value, entry.getAttribute("format", "M/d/yyyy h:m:s a")));
                statement.setTimestamp(position, ts);
                break;
            }
            case 2003: {
                statement.setArray(position, (Array)value);
                break;
            }
            case 1111: 
            case 2002: {
                statement.setObject(position, value);
                break;
            }
            case -4: {
                statement.setTimestamp(position, new Timestamp(new java.util.Date().getTime()));
                break;
            }
            case 12: {
                if ("string".equals(typeName)) {
                    statement.setString(position, (String)value);
                    break;
                }
                if ("image-mime-type".equals(typeName)) {
                    String imageAttr = param.substring(0, param.length() - "-mime-type".length());
                    File file = (File)request.get(imageAttr);
                    Map map = this.files;
                    synchronized (map) {
                        Parameters parameters = (Parameters)this.files.get(file);
                        String imageMimeType = parameters.getParameter("image-mime-type", (String)this.settings.get("image-mime-type", ""));
                        statement.setString(position, imageMimeType);
                        this.setRequestAttribute(request, param, imageMimeType);
                        break;
                    }
                }
            }
            case 2004: {
                File file;
                if (value instanceof File) {
                    file = (File)value;
                } else if (value instanceof String) {
                    file = new File((String)value);
                } else {
                    throw new SQLException("Invalid type for blob: " + value.getClass().getName());
                }
                FileInputStream input = new FileInputStream(file);
                statement.setBinaryStream(position, (InputStream)input, (int)file.length());
                if (!"image".equals(typeName)) break;
                Parameters parameters = new Parameters();
                parameters.setParameter("image-size", Long.toString(file.length()));
                int[] dimensions = ImageDirectoryGenerator.getSize(file);
                String type = ImageDirectoryGenerator.getFileType(file);
                parameters.setParameter("image-width", Integer.toString(dimensions[0]));
                parameters.setParameter("image-height", Integer.toString(dimensions[1]));
                parameters.setParameter("image-mime-type", type);
                Map map = this.files;
                synchronized (map) {
                    this.files.put(file, parameters);
                    break;
                }
            }
            case 4: {
                if ("int".equals(typeName)) {
                    Integer i = null;
                    i = value instanceof Integer ? (Integer)value : new Integer((String)value);
                    statement.setInt(position, i);
                    break;
                }
                if ("image-width".equals(typeName)) {
                    String imageAttr = param.substring(0, param.length() - "-width".length());
                    File file = (File)request.get(imageAttr);
                    Map map = this.files;
                    synchronized (map) {
                        Parameters parameters = (Parameters)this.files.get(file);
                        statement.setInt(position, parameters.getParameterAsInteger("image-width", Integer.parseInt((String)this.settings.get("image-width", "-1"))));
                        this.setRequestAttribute(request, param, parameters.getParameter("image-width", (String)this.settings.get("image-width", "")));
                        break;
                    }
                }
                if ("image-height".equals(typeName)) {
                    String imageAttr = param.substring(0, param.length() - "-height".length());
                    File file = (File)request.get(imageAttr);
                    Map map = this.files;
                    synchronized (map) {
                        Parameters parameters = (Parameters)this.files.get(file);
                        statement.setInt(position, parameters.getParameterAsInteger("image-height", Integer.parseInt((String)this.settings.get("image-height", "-1"))));
                        this.setRequestAttribute(request, param, parameters.getParameter("image-height", (String)this.settings.get("image-height", "")));
                        break;
                    }
                }
                if ("image-size".equals(typeName)) {
                    String imageAttr = param.substring(0, param.length() - "-size".length());
                    File file = (File)request.get(imageAttr);
                    Map map = this.files;
                    synchronized (map) {
                        Parameters parameters = (Parameters)this.files.get(file);
                        statement.setInt(position, parameters.getParameterAsInteger("image-size", Integer.parseInt((String)this.settings.get("image-height", "-1"))));
                        this.setRequestAttribute(request, param, parameters.getParameter("image-size", (String)this.settings.get("image-size", "")));
                        break;
                    }
                }
                if ("row-index".equals(typeName)) {
                    statement.setInt(position, rowIndex);
                    break;
                }
            }
            default: {
                throw new SQLException("Impossible exception - invalid type " + typeName);
            }
        }
    }

    private final long dateValue(String value, String format) throws Exception {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.parse(value).getTime();
    }

    public void dispose() {
        this.manager.release((Component)this.dbselector);
    }

    protected void setRequestAttribute(Request request, String key, Object value) {
        request.setAttribute("org.apache.cocoon.acting.AbstractDatabaseAction:" + key, value);
    }

    protected Object getRequestAttribute(Request request, String key) {
        return request.getAttribute("org.apache.cocoon.acting.AbstractDatabaseAction:" + key);
    }

    static {
        HashMap<String, Integer> constants = new HashMap<String, Integer>();
        constants.put("ascii", new Integer(2005));
        constants.put("big-decimal", new Integer(-5));
        constants.put("binary", new Integer(2004));
        constants.put("byte", new Integer(-6));
        constants.put("string", new Integer(12));
        constants.put("date", new Integer(91));
        constants.put("double", new Integer(8));
        constants.put("float", new Integer(6));
        constants.put("int", new Integer(4));
        constants.put("long", new Integer(2));
        constants.put("short", new Integer(5));
        constants.put("time", new Integer(92));
        constants.put("time-stamp", new Integer(93));
        constants.put("now", new Integer(-4));
        constants.put("image", new Integer(2004));
        constants.put("image-width", new Integer(4));
        constants.put("image-height", new Integer(4));
        constants.put("image-size", new Integer(4));
        constants.put("row-index", new Integer(4));
        constants.put("image-mime-type", new Integer(12));
        constants.put("array", new Integer(2003));
        constants.put("row", new Integer(2002));
        constants.put("object", new Integer(1111));
        typeConstants = Collections.unmodifiableMap(constants);
    }
}

