/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.sdx.thesaurus;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.logger.NullLogger;
import org.apache.cocoon.serialization.XMLSerializer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

import fr.gouv.culture.sdx.utils.constants.Node;

/**
 * Created by IntelliJ IDEA.
 * User: rpandey
 * Date: Jan 31, 2003
 * Time: 4:49:51 PM
 * To change this template use Options | File Templates.
 */
public class LuceneThesaurusBuilder extends AbstractThesaurusBuilder {

    protected int openConcepts = 0;
    protected ByteArrayOutputStream conceptBytes = null;
    
    /** A configuration object needed to make sure we use Saxon */
    protected Configuration saxonConf = null;

    public void startElement(String uri, String loc, String raw, Attributes a)
            throws SAXException {
    	
        if (uri.equals(Thesaurus.NAMESPACE_URI)) {
        	// If not already created, we create a configuration object in order
        	// to tell the XMLSerializer to use Saxon. This prevents the usage
        	// of Xalan, which has major bigs with parsing/serializing XML fragments
        	if ( saxonConf == null ) {
                saxonConf = new DefaultConfiguration("conf");
                DefaultConfiguration cfTf = new DefaultConfiguration("transformer-factory");
                cfTf.setValue("com.icl.saxon.TransformerFactoryImpl");
                ((DefaultConfiguration)saxonConf).addChild(cfTf);
        	}
            if (loc.equals(Node.Name.CONCEPT)) {
                if (openConcepts == 0) {
                    XMLSerializer cBytes = new XMLSerializer();
                    cBytes.enableLogging(new NullLogger());
                    this.conceptBytes = new ByteArrayOutputStream();
                    try {
                        cBytes.configure(saxonConf);
                    	cBytes.setOutputStream(conceptBytes);

                    } catch (IOException e){
                    	throw new SAXException(e.getMessage(),e);
                    } catch (ConfigurationException e) {
                        throw new SAXException(e.getMessage(), e);
                    }
                    super.setConsumer(cBytes);
                    super.startDocument();

                }
                openConcepts++;
            }

        }
        super.startElement(uri, loc, raw, a);
    }

    public void endElement(String uri, String loc, String raw)
            throws SAXException {

        super.endElement(uri, loc, raw);

        if (uri.equals(Thesaurus.NAMESPACE_URI)) {

            if (loc.equals(Node.Name.CONCEPT)) {
                openConcepts--;
                if (openConcepts == 0) {
                    super.endDocument();
                    if (this.conceptBytes != null) {
                        Concept concept = new LuceneConcept();
                        try {
                            this.conceptBytes.flush();
                        } catch (IOException e) {
                            throw new SAXException(e.getMessage(), e);
                        }
                        concept.setContent(this.conceptBytes.toByteArray());
                        concepts.add(concept);
                        this.conceptBytes = null;
                    }
                    super.recycle();
                }
            }

        }

    }


}
