/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
/*
 * Created by IntelliJ IDEA.
 * User: rpandey
 * Date: 17 oct. 2002
 * Time: 16:06:46
 * To change template for new class use
 * Code Style | Class Templates options (Tools | IDE Options).
 */
package fr.gouv.culture.sdx.repository;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.exception.SDXExceptionCode;
import fr.gouv.culture.sdx.utils.Utilities;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexWriter;

import java.io.IOException;

public class LuceneRepositoryConnection extends AbstractRepositoryConnection {

    /**The Directory for the index which should be optimized*/
    private String indexPath = null;

    /**The analyzer for the index*/
    private final StandardAnalyzer analyzer = new StandardAnalyzer();

    /**Adding the necessary parameters for optimization*/
    public void setUp(String indexPath) {
        this.indexPath = indexPath;
    }

    /**Can do optimization of a Repository if needed*/
    public void optimize() throws SDXException {

        if (Utilities.checkString(this.indexPath) && this.analyzer != null) {
            //passing false so as to not overwrite contents
            IndexWriter w = null;
            try {
                w = new IndexWriter(this.indexPath, this.analyzer, false);
                w.optimize();
            } catch (IOException e) {
                String[] args = new String[1];
                args[0] = this.indexPath;
                throw new SDXException(super.getLog(), SDXExceptionCode.ERROR_LUCENE_OPTIMIZE, args, e);

            } finally {
                if (w != null)
                    try {
                        w.close();
                    } catch (IOException e) {
                        String[] args = new String[1];
                        args[0] = this.indexPath;
                        throw new SDXException(super.getLog(), SDXExceptionCode.ERROR_LUCENE_OPTIMIZE, args, e);
                    }
            }
        }
    }


}
