/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.xml.sax;

import java.util.Enumeration;
import org.xml.sax.AttributeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class ContentHandlerAdapter
implements DocumentHandler {
    private static final String XMLNS = "xmlns";
    private static final String XMLNS_PREFIX = "xmlns:";
    private final ContentHandler m_handler;
    private final NamespaceSupport m_support = new NamespaceSupport();

    public ContentHandlerAdapter(ContentHandler handler) {
        this.m_handler = handler;
    }

    public void setDocumentLocator(Locator locator) {
        this.m_handler.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        this.m_handler.startDocument();
    }

    public void endDocument() throws SAXException {
        this.m_handler.endDocument();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.m_handler.characters(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.m_handler.ignorableWhitespace(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.m_handler.processingInstruction(target, data);
    }

    public void startElement(String name, AttributeList atts) throws SAXException {
        String[] parts;
        this.m_support.pushContext();
        int i = 0;
        while (i < atts.getLength()) {
            String attributeName = atts.getName(i);
            if (attributeName.startsWith(XMLNS_PREFIX)) {
                this.m_support.declarePrefix(attributeName.substring(6), atts.getValue(i));
            } else if (attributeName.equals(XMLNS)) {
                this.m_support.declarePrefix("", atts.getValue(i));
            }
            ++i;
        }
        AttributesImpl attributes = new AttributesImpl();
        int i2 = 0;
        while (i2 < atts.getLength()) {
            String attributeName = atts.getName(i2);
            if (!attributeName.startsWith(XMLNS_PREFIX) && !attributeName.equals(XMLNS)) {
                parts = this.m_support.processName(attributeName, new String[3], true);
                attributes.addAttribute(parts[0], parts[1], parts[2], atts.getType(i2), atts.getValue(i2));
            }
            ++i2;
        }
        Enumeration<String> e = this.m_support.getDeclaredPrefixes();
        while (e.hasMoreElements()) {
            String prefix = e.nextElement();
            this.m_handler.startPrefixMapping(prefix, this.m_support.getURI(prefix));
        }
        parts = this.m_support.processName(name, new String[3], false);
        this.m_handler.startElement(parts[0], parts[1], parts[2], attributes);
    }

    public void endElement(String name) throws SAXException {
        String[] parts = this.m_support.processName(name, new String[3], false);
        this.m_handler.endElement(parts[0], parts[1], parts[2]);
        Enumeration<String> e = this.m_support.getDeclaredPrefixes();
        while (e.hasMoreElements()) {
            String prefix = e.nextElement();
            this.m_handler.endPrefixMapping(prefix);
        }
        this.m_support.popContext();
    }

    static {
        XMLNS = XMLNS;
        XMLNS_PREFIX = XMLNS_PREFIX;
    }
}

