/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.utils.servlet.session;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.utils.servlet.session.DistSession;
import org.apache.jcs.utils.servlet.session.ISessionConstants;

class DistSessionGC
extends Thread
implements ISessionConstants {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$utils$servlet$session$DistSessionGC == null ? (class$org$apache$jcs$utils$servlet$session$DistSessionGC = DistSessionGC.class$("org.apache.jcs.utils.servlet.session.DistSessionGC")) : class$org$apache$jcs$utils$servlet$session$DistSessionGC));
    private static final long IDLE_PERIOD = 3600000L;
    private final Set sessIdSet;
    static /* synthetic */ Class class$org$apache$jcs$utils$servlet$session$DistSessionGC;

    DistSessionGC(Set sessIdSet) {
        this.sessIdSet = sessIdSet;
    }

    void notifySession() {
        DistSessionGC distSessionGC = this;
        synchronized (distSessionGC) {
            this.notify();
        }
    }

    public void run() {
        block10: while (true) {
            if (this.sessIdSet.size() == 0) {
                DistSessionGC distSessionGC = this;
                synchronized (distSessionGC) {
                    if (this.sessIdSet.size() == 0) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"entering into a wait state");
                        }
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("sessIdSet.size()=" + this.sessIdSet.size()));
                    log.debug((Object)"sleeping for 3600000");
                }
                Thread.currentThread();
                Thread.sleep(3600000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            long now = System.currentTimeMillis();
            String[] sessIds = null;
            Set set = this.sessIdSet;
            synchronized (set) {
                sessIds = this.sessIdSet.toArray(new String[0]);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"garbage collecting...");
            }
            int i = 0;
            while (true) {
                int max;
                long idleTime;
                if (i >= sessIds.length) continue block10;
                DistSession sess = new DistSession();
                String session_id = sessIds[i];
                if (sess.init(session_id) && (idleTime = System.currentTimeMillis() - sess.getLastAccessedTime()) >= (long)(max = sess.getMaxInactiveInterval())) {
                    this.sessIdSet.remove(session_id);
                    sess.invalidate();
                }
                ++i;
            }
            break;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

