/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.lateral.javagroups;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.lateral.LateralCacheInfo;
import org.apache.jcs.auxiliary.lateral.behavior.ILateralCacheAttributes;
import org.apache.jcs.auxiliary.lateral.behavior.ILateralCacheListener;
import org.apache.jcs.auxiliary.lateral.javagroups.LateralJGReceiver;
import org.apache.jcs.auxiliary.lateral.javagroups.behavior.ILateralCacheJGListener;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.control.CompositeCache;
import org.apache.jcs.engine.control.CompositeCacheManager;

public class LateralCacheJGListener
implements ILateralCacheJGListener,
Serializable {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$lateral$javagroups$LateralCacheJGListener == null ? (class$org$apache$jcs$auxiliary$lateral$javagroups$LateralCacheJGListener = LateralCacheJGListener.class$("org.apache.jcs.auxiliary.lateral.javagroups.LateralCacheJGListener")) : class$org$apache$jcs$auxiliary$lateral$javagroups$LateralCacheJGListener));
    protected static transient CompositeCacheManager cacheMgr;
    protected static final HashMap instances;
    private LateralJGReceiver receiver;
    private ILateralCacheAttributes ilca;
    private boolean inited = false;
    private int puts = 0;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$lateral$javagroups$LateralCacheJGListener;

    protected LateralCacheJGListener(ILateralCacheAttributes ilca) {
        this.ilca = ilca;
    }

    public void init() {
        try {
            this.receiver = new LateralJGReceiver(this.ilca, this);
            Thread t = new Thread(this.receiver);
            t.start();
        }
        catch (Exception ex) {
            log.error((Object)ex);
            throw new IllegalStateException(ex.getMessage());
        }
        this.inited = true;
    }

    public void setListenerId(byte id) throws IOException {
        LateralCacheInfo.listenerId = id;
        if (log.isDebugEnabled()) {
            log.debug((Object)("set listenerId = " + id));
        }
    }

    public byte getListenerId() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("get listenerId = " + LateralCacheInfo.listenerId));
        }
        return LateralCacheInfo.listenerId;
    }

    public static ILateralCacheListener getInstance(ILateralCacheAttributes ilca) {
        ILateralCacheListener ins = (ILateralCacheListener)instances.get(ilca.getJGChannelProperties());
        if (ins == null) {
            Class clazz = class$org$apache$jcs$auxiliary$lateral$javagroups$LateralCacheJGListener == null ? (class$org$apache$jcs$auxiliary$lateral$javagroups$LateralCacheJGListener = LateralCacheJGListener.class$("org.apache.jcs.auxiliary.lateral.javagroups.LateralCacheJGListener")) : class$org$apache$jcs$auxiliary$lateral$javagroups$LateralCacheJGListener;
            synchronized (clazz) {
                if (ins == null) {
                    ins = new LateralCacheJGListener(ilca);
                    ins.init();
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("created new listener " + ilca.getJGChannelProperties()));
                }
                instances.put(ilca.getJGChannelProperties(), ins);
            }
        }
        return ins;
    }

    public void handlePut(ICacheElement element) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"PUTTING ELEMENT FROM LATERAL");
        }
        ++this.puts;
        if (log.isInfoEnabled() && this.puts % 100 == 0) {
            log.info((Object)("puts = " + this.puts));
        }
        this.getCache(element.getCacheName()).localUpdate(element);
    }

    public void handleRemove(String cacheName, Serializable key) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("handleRemove> cacheName=" + cacheName + ", key=" + key));
        }
        this.getCache(cacheName).localRemove(key);
    }

    public void handleRemoveAll(String cacheName) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("handleRemoveAll> cacheName=" + cacheName));
        }
        CompositeCache cache = this.getCache(cacheName);
        cache.removeAll();
    }

    public Serializable handleGet(String cacheName, Serializable key) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("handleGet> cacheName=" + cacheName + ", key = " + key));
        }
        return this.getCache(cacheName).localGet(key);
    }

    public void handleDispose(String cacheName) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("handleDispose> cacheName=" + cacheName));
        }
        CompositeCacheManager cm = cacheMgr;
        cm.freeCache(cacheName, true);
    }

    protected CompositeCache getCache(String name) {
        if (cacheMgr == null) {
            cacheMgr = CompositeCacheManager.getInstance();
            if (log.isDebugEnabled()) {
                log.debug((Object)("cacheMgr = " + cacheMgr));
            }
        }
        return cacheMgr.getCache(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        instances = new HashMap();
    }
}

