/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.mail;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import org.apache.cocoon.mail.ContentTypePreference;

public class MimeMessageUtil {
    public static final String SENDER_NOT_AVAILABLE = "-not available-";
    public static final String NO_SUBJECT = "-none-";

    public static String getSender(MimeMessage msg) {
        String sender = null;
        try {
            InternetAddress[] from = (InternetAddress[])msg.getFrom();
            if (from != null && from.length > 0 && (sender = from[0].getPersonal()) == null) {
                sender = from[0].getAddress();
            }
            if (sender == null) {
                sender = SENDER_NOT_AVAILABLE;
            }
        }
        catch (AddressException e) {
            sender = SENDER_NOT_AVAILABLE;
        }
        catch (MessagingException e) {
            sender = SENDER_NOT_AVAILABLE;
        }
        if (sender == null || sender.trim().equals("")) {
            sender = SENDER_NOT_AVAILABLE;
        }
        return sender;
    }

    public static String getSenderEmail(MimeMessage msg) {
        String senderEmail = null;
        try {
            InternetAddress[] from = (InternetAddress[])msg.getFrom();
            if (from != null && from.length > 0) {
                senderEmail = from[0].getAddress();
            }
        }
        catch (AddressException e) {
            senderEmail = SENDER_NOT_AVAILABLE;
        }
        catch (MessagingException e) {
            senderEmail = SENDER_NOT_AVAILABLE;
        }
        if (senderEmail == null || senderEmail.trim().equals("")) {
            senderEmail = SENDER_NOT_AVAILABLE;
        }
        return senderEmail;
    }

    public static String getSubject(MimeMessage msg) {
        String subject = null;
        try {
            subject = msg.getSubject();
        }
        catch (MessagingException e) {
            subject = NO_SUBJECT;
        }
        if (subject == null || subject.trim().equals("")) {
            subject = NO_SUBJECT;
        }
        return subject;
    }

    public static Date getDate(MimeMessage msg) {
        Date date;
        block4: {
            date = null;
            try {
                date = msg.getReceivedDate();
            }
            catch (MessagingException messagingexception) {
                // empty catch block
            }
            if (date != null) break block4;
            try {
                date = msg.getSentDate();
            }
            catch (MessagingException messagingexception) {}
        }
        return date;
    }

    public static String getID(MimeMessage msg) {
        String id = null;
        try {
            id = msg.getMessageID();
        }
        catch (MessagingException messagingexception) {}
        return id;
    }

    private static void flattenMessageHelper(MimePart part, ContentTypePreference ctPref, List l) {
        block9: {
            try {
                if (part.isMimeType("multipart/alternative")) {
                    MimeMultipart mp = (MimeMultipart)part.getContent();
                    MimePart bestPart = null;
                    int ctMax = 0;
                    int i = 0;
                    while (i < mp.getCount()) {
                        MimePart p = (MimePart)mp.getBodyPart(i);
                        int ctPrefN = ctPref.preference(part);
                        if (ctPrefN > ctMax) {
                            ctMax = ctPrefN;
                            bestPart = p;
                        }
                        ++i;
                    }
                    if (bestPart == null) break block9;
                    l.add(bestPart);
                    break block9;
                }
                if (part.isMimeType("multipart/*")) {
                    MimeMultipart mp = (MimeMultipart)part.getContent();
                    int i = 0;
                    while (i < mp.getCount()) {
                        MimeMessageUtil.flattenMessageHelper((MimePart)mp.getBodyPart(i), ctPref, l);
                        ++i;
                    }
                    break block9;
                }
                if (part.isMimeType("message/rfc822")) {
                    MimeMessageUtil.flattenMessageHelper((MimePart)part.getContent(), ctPref, l);
                    break block9;
                }
                if (ctPref.preference(part) <= 0) break block9;
                l.add(part);
            }
            catch (MessagingException e) {
            }
            catch (IOException ioexception) {}
        }
    }

    public static MimePart[] flattenMessage(MimeMessage message, ContentTypePreference ctPref) {
        ArrayList parts = new ArrayList();
        MimeMessageUtil.flattenMessageHelper((MimePart)message, ctPref, parts);
        return parts.toArray(new MimePart[0]);
    }
}

