/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.mm.mysql.jdbc2.optional;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import org.gjt.mm.mysql.jdbc2.optional.LogicalHandle;

public class MysqlPooledConnection
implements PooledConnection {
    private Hashtable eventListeners;
    protected Connection logicalHandle = null;
    protected Connection physicalConn;

    public MysqlPooledConnection(Connection connection) {
        this.physicalConn = connection;
        this.eventListeners = new Hashtable(10);
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (this.eventListeners != null) {
            this.eventListeners.put(connectionEventListener, connectionEventListener);
        }
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (this.eventListeners != null) {
            this.eventListeners.remove(connectionEventListener);
        }
    }

    public synchronized Connection getConnection() throws SQLException {
        if (this.physicalConn == null) {
            SQLException sQLException = new SQLException("Physical Connection doesn't exist");
            this.callListener(2, sQLException);
            return null;
        }
        try {
            if (this.logicalHandle != null) {
                this.logicalHandle.close();
            }
            this.logicalHandle = new LogicalHandle(this, this.physicalConn);
        }
        catch (SQLException sQLException) {
            this.callListener(2, sQLException);
            return null;
        }
        return this.logicalHandle;
    }

    public synchronized void close() throws SQLException {
        this.physicalConn.close();
        this.physicalConn = null;
        this.callListener(2, null);
    }

    protected synchronized void callListener(int n, SQLException sQLException) {
        if (this.eventListeners == null) {
            return;
        }
        Enumeration enumeration = this.eventListeners.keys();
        ConnectionEvent connectionEvent = new ConnectionEvent(this, sQLException);
        while (enumeration.hasMoreElements()) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)enumeration.nextElement();
            ConnectionEventListener connectionEventListener2 = (ConnectionEventListener)this.eventListeners.get(connectionEventListener);
            if (n == 1) {
                connectionEventListener2.connectionClosed(connectionEvent);
                continue;
            }
            if (n != 2) continue;
            connectionEventListener2.connectionErrorOccurred(connectionEvent);
        }
    }
}

