/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.mpool;

import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.commons.collections.BoundedFifoBuffer;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUnderflowException;
import org.apache.excalibur.mpool.ObjectFactory;
import org.apache.excalibur.mpool.Pool;
import org.apache.excalibur.mpool.PoolUtil;

public final class BlockingFixedSizePool
implements Pool,
Disposable,
Initializable {
    private boolean m_disposed = false;
    private final Buffer m_buffer;
    private final ObjectFactory m_factory;
    private final long m_timeout;
    private final int m_maxSize;
    protected final Object m_semaphore = new Object();

    public BlockingFixedSizePool(ObjectFactory factory, int size) throws Exception {
        this(factory, size, 1000L);
    }

    public BlockingFixedSizePool(ObjectFactory factory, int size, long timeout) throws Exception {
        this.m_timeout = timeout < 1L ? 0L : timeout;
        this.m_buffer = new BoundedFifoBuffer(size);
        this.m_maxSize = size;
        this.m_factory = factory;
    }

    public void initialize() throws Exception {
        int i = 0;
        while (i < this.m_maxSize) {
            this.m_buffer.add(this.newInstance());
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object acquire() {
        if (this.m_disposed) {
            throw new IllegalStateException("Cannot get an object from a disposed pool");
        }
        Object object = null;
        Object object2 = this.m_semaphore;
        synchronized (object2) {
            if (this.m_buffer.isEmpty()) {
                long blockStart = System.currentTimeMillis();
                if (this.m_timeout > 0L) {
                    long blockWait = this.m_timeout;
                    do {
                        try {
                            this.m_semaphore.wait(blockWait);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                        if (this.m_disposed) {
                            throw new IllegalStateException("Pool disposed of while waiting for resources to free up");
                        }
                        if (!this.m_buffer.isEmpty()) continue;
                        blockWait = this.m_timeout - (System.currentTimeMillis() - blockStart);
                    } while (this.m_buffer.isEmpty() && blockWait > 0L);
                } else {
                    do {
                        try {
                            this.m_semaphore.wait();
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                        if (!this.m_disposed) continue;
                        throw new IllegalStateException("Pool disposed of while waiting for resources to free up");
                    } while (this.m_buffer.isEmpty());
                }
            }
            try {
                object = this.m_buffer.remove();
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                // empty catch block
            }
        }
        if (object == null) {
            throw new IllegalStateException("Timeout exceeded without acquiring resource.");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Object object) {
        Object object2 = this.m_semaphore;
        synchronized (object2) {
            if (this.m_disposed) {
                try {
                    this.m_factory.dispose(object);
                }
                catch (Exception e) {}
            } else if (this.m_buffer.size() < this.m_maxSize) {
                this.m_buffer.add(PoolUtil.recycle(object));
                this.m_semaphore.notify();
            } else {
                try {
                    this.m_factory.dispose(object);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public Object newInstance() throws Exception {
        return this.m_factory.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispose() {
        this.m_disposed = true;
        Object object = this.m_semaphore;
        synchronized (object) {
            while (!this.m_buffer.isEmpty()) {
                try {
                    this.m_factory.dispose(this.m_buffer.remove());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.m_semaphore.notifyAll();
            return;
        }
    }
}

