/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.pluto.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.cocoon.portal.pluto.PortletURLProviderImpl;
import org.apache.pluto.om.window.PortletWindow;

public class ServletRequestImpl
implements HttpServletRequest {
    protected final HttpServletRequest request;
    protected Map portletParameterMap;
    protected final PortletURLProviderImpl provider;
    protected PortletWindow window;

    public ServletRequestImpl(HttpServletRequest request, PortletURLProviderImpl provider) {
        this.request = request;
        this.provider = provider;
    }

    public ServletRequestImpl(HttpServletRequest request, PortletURLProviderImpl provider, PortletWindow window) {
        this.request = request;
        this.provider = provider;
        this.window = window;
    }

    public ServletRequestImpl getRequest(PortletWindow window) {
        return new ServletRequestImpl(this.request, this.provider, window);
    }

    public String getAuthType() {
        return this.request.getAuthType();
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public Cookie[] getCookies() {
        return this.request.getCookies();
    }

    public long getDateHeader(String arg0) {
        return this.request.getDateHeader(arg0);
    }

    public String getHeader(String arg0) {
        return this.request.getHeader(arg0);
    }

    public Enumeration getHeaderNames() {
        return this.request.getHeaderNames();
    }

    public Enumeration getHeaders(String arg0) {
        return this.request.getHeaders(arg0);
    }

    public int getIntHeader(String arg0) {
        return this.request.getIntHeader(arg0);
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getPathInfo() {
        return this.request.getPathInfo();
    }

    public String getPathTranslated() {
        return this.request.getPathTranslated();
    }

    public String getQueryString() {
        return null;
    }

    public String getRemoteUser() {
        return this.request.getRemoteUser();
    }

    public String getRequestedSessionId() {
        return this.request.getRequestedSessionId();
    }

    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    public StringBuffer getRequestURL() {
        return null;
    }

    public String getServletPath() {
        return this.request.getServletPath();
    }

    public HttpSession getSession() {
        return this.request.getSession();
    }

    public HttpSession getSession(boolean arg0) {
        return this.request.getSession(arg0);
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.request.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.request.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.request.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdValid() {
        return this.request.isRequestedSessionIdValid();
    }

    public boolean isUserInRole(String arg0) {
        return this.request.isUserInRole(arg0);
    }

    public Object getAttribute(String arg0) {
        return this.request.getAttribute(arg0);
    }

    public Enumeration getAttributeNames() {
        return this.request.getAttributeNames();
    }

    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.request.getInputStream();
    }

    public Locale getLocale() {
        return this.request.getLocale();
    }

    public Enumeration getLocales() {
        return this.request.getLocales();
    }

    public String getProtocol() {
        return this.request.getProtocol();
    }

    public BufferedReader getReader() throws IOException {
        return this.request.getReader();
    }

    public String getRealPath(String arg0) {
        return this.request.getRealPath(arg0);
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.request.getRemoteHost();
    }

    public RequestDispatcher getRequestDispatcher(String arg0) {
        return this.request.getRequestDispatcher(arg0);
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public String getServerName() {
        return this.request.getServerName();
    }

    public int getServerPort() {
        return this.request.getServerPort();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public void removeAttribute(String arg0) {
        this.request.removeAttribute(arg0);
    }

    public void setAttribute(String arg0, Object arg1) {
        this.request.setAttribute(arg0, arg1);
    }

    public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
    }

    public String getContentType() {
        String contentType = "text/html";
        if (this.getCharacterEncoding() != null) {
            contentType = contentType + ";" + this.getCharacterEncoding();
        }
        return contentType;
    }

    public String getParameter(String name) {
        return (String)this.getParameterMap().get(name);
    }

    public Map getParameterMap() {
        if (this.portletParameterMap == null) {
            this.portletParameterMap = new HashMap();
            if (this.provider != null && this.provider.getPortletWindow().equals(this.window)) {
                Iterator i = this.provider.getParameters().entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    if (entry.getValue() instanceof String) {
                        this.portletParameterMap.put(entry.getKey(), new String[]{(String)entry.getValue()});
                        continue;
                    }
                    this.portletParameterMap.put(entry.getKey(), entry.getValue());
                }
                Enumeration parameters = this.request.getParameterNames();
                while (parameters.hasMoreElements()) {
                    String paramName = (String)parameters.nextElement();
                    String[] paramValues = this.request.getParameterValues(paramName);
                    String[] values = (String[])this.portletParameterMap.get(paramName);
                    if (values != null) {
                        String[] temp = new String[paramValues.length + values.length];
                        System.arraycopy(paramValues, 0, temp, 0, paramValues.length);
                        System.arraycopy(values, 0, temp, paramValues.length, values.length);
                        paramValues = temp;
                    }
                    this.portletParameterMap.put(paramName, paramValues);
                }
            }
        }
        return this.portletParameterMap;
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this.getParameterMap().keySet());
    }

    public String[] getParameterValues(String name) {
        return (String[])this.getParameterMap().get(name);
    }
}

