/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.coplets.basket;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.excalibur.io.IOUtil;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.portal.PortalService;
import org.apache.cocoon.portal.coplet.CopletData;
import org.apache.cocoon.portal.coplet.CopletInstanceData;
import org.apache.cocoon.portal.coplets.basket.AddItemEvent;
import org.apache.cocoon.portal.coplets.basket.Basket;
import org.apache.cocoon.portal.coplets.basket.BasketManager;
import org.apache.cocoon.portal.coplets.basket.CleanBasketEvent;
import org.apache.cocoon.portal.coplets.basket.ContentItem;
import org.apache.cocoon.portal.coplets.basket.RefreshBasketEvent;
import org.apache.cocoon.portal.coplets.basket.RemoveItemEvent;
import org.apache.cocoon.portal.coplets.basket.SaveBasketEvent;
import org.apache.cocoon.portal.coplets.basket.ShowBasketEvent;
import org.apache.cocoon.portal.coplets.basket.ShowItemEvent;
import org.apache.cocoon.portal.coplets.basket.UploadItemEvent;
import org.apache.cocoon.portal.event.Event;
import org.apache.cocoon.portal.event.EventManager;
import org.apache.cocoon.portal.event.Filter;
import org.apache.cocoon.portal.event.Subscriber;
import org.apache.cocoon.portal.layout.impl.CopletLayout;
import org.apache.cocoon.servlet.multipart.Part;
import org.apache.cocoon.servlet.multipart.PartOnDisk;
import org.apache.cocoon.util.ClassUtils;
import org.apache.cocoon.webapps.authentication.AuthenticationManager;
import org.apache.cocoon.webapps.authentication.user.RequestState;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class BasketManagerImpl
extends AbstractLogEnabled
implements BasketManager,
Serviceable,
Subscriber,
Contextualizable,
Initializable,
Parameterizable,
ThreadSafe,
Component {
    protected ServiceManager manager;
    protected Context context;
    protected String directory;
    protected String basketClassName = (class$org$apache$cocoon$portal$coplets$basket$Basket == null ? (class$org$apache$cocoon$portal$coplets$basket$Basket = BasketManagerImpl.class$("org.apache.cocoon.portal.coplets.basket.Basket")) : class$org$apache$cocoon$portal$coplets$basket$Basket).getName();
    static /* synthetic */ Class class$org$apache$cocoon$portal$coplets$basket$Basket;
    static /* synthetic */ Class class$org$apache$cocoon$portal$coplets$basket$BasketEvent;

    public void parameterize(Parameters parameters) throws ParameterException {
        this.directory = parameters.getParameter("directory", this.directory);
        this.basketClassName = parameters.getParameter("basket-class", this.basketClassName);
    }

    public void contextualize(Context context) throws ContextException {
        this.context = context;
        this.directory = ((File)context.get((Object)"work-directory")).getAbsolutePath();
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws Exception {
        EventManager eventManager = null;
        try {
            eventManager = (EventManager)this.manager.lookup(EventManager.ROLE);
            eventManager.getRegister().subscribe(this);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.manager.release((Object)eventManager);
            throw throwable;
        }
        this.manager.release((Object)eventManager);
    }

    public Class getEventType() {
        return class$org$apache$cocoon$portal$coplets$basket$BasketEvent == null ? (class$org$apache$cocoon$portal$coplets$basket$BasketEvent = BasketManagerImpl.class$("org.apache.cocoon.portal.coplets.basket.BasketEvent")) : class$org$apache$cocoon$portal$coplets$basket$BasketEvent;
    }

    public Filter getFilter() {
        return null;
    }

    public void inform(Event event) {
        Session session = ContextHelper.getRequest((Context)this.context).getSession();
        Basket basket = this.getBasket();
        if (event instanceof AddItemEvent) {
            this.processAddItemEvent((AddItemEvent)event, basket);
        } else if (event instanceof RemoveItemEvent) {
            this.processRemoveItemEvent((RemoveItemEvent)event, basket);
        } else if (event instanceof SaveBasketEvent) {
            this.saveBasket(basket);
        } else if (event instanceof RefreshBasketEvent) {
            session.removeAttribute(BasketManager.ALL_BASKETS_KEY);
        } else if (event instanceof CleanBasketEvent) {
            this.processCleanBasketEvent((CleanBasketEvent)event, session);
        } else if (event instanceof UploadItemEvent) {
            this.processUploadItemEvent((UploadItemEvent)event, basket);
        } else if (event instanceof ShowItemEvent) {
            this.processShowItemEvent((ShowItemEvent)event, basket);
        } else if (event instanceof ShowBasketEvent) {
            this.processShowBasketEvent((ShowBasketEvent)event, session);
        }
    }

    protected void processUploadItemEvent(UploadItemEvent event, Basket basket) {
        Request req = ContextHelper.getRequest((Context)this.context);
        List paramNames = event.getItemNames();
        Iterator i = paramNames.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            Object o = req.get(name);
            if (o == null || !(o instanceof Part)) continue;
            Part file = (Part)o;
            try {
                byte[] c = IOUtil.toByteArray((InputStream)file.getInputStream());
                ContentItem ci = new ContentItem(file.getFileName(), true);
                ci.setContent(c);
                basket.addItem(ci);
            }
            catch (Exception ignore) {
                // empty catch block
            }
            if (!(file instanceof PartOnDisk)) continue;
            ((PartOnDisk)file).getFile().delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void processShowItemEvent(ShowItemEvent event, Basket basket) {
        block16: {
            if (!(event.getItem() instanceof ContentItem)) break block16;
            PortalService service = null;
            try {
                CopletInstanceData cid;
                CopletLayout layout;
                block18: {
                    ContentItem ci;
                    block19: {
                        SourceResolver resolver;
                        block13: {
                            block17: {
                                service = (PortalService)this.manager.lookup(PortalService.ROLE);
                                ci = (ContentItem)event.getItem();
                                layout = (CopletLayout)event.getLayout();
                                cid = null;
                                if (!ci.isContent()) break block17;
                                CopletData copletData = service.getComponentManager().getProfileManager().getCopletData(event.getCopletDataId());
                                cid = service.getComponentManager().getCopletFactory().newInstance(copletData);
                                cid.setAttribute("item-content", ci.getContent());
                                break block18;
                            }
                            if (ci.getURL() == null) break block19;
                            resolver = null;
                            Source source = null;
                            String url = null;
                            try {
                                resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
                                url = ci.getURL();
                                source = resolver.resolveURI(url);
                                CopletData copletData = service.getComponentManager().getProfileManager().getCopletData(event.getCopletDataId());
                                cid = service.getComponentManager().getCopletFactory().newInstance(copletData);
                                cid.setAttribute("item-content", IOUtil.toByteArray((InputStream)source.getInputStream()));
                                if (source == null) break block13;
                            }
                            catch (IOException se) {
                                block14: {
                                    this.getLogger().warn("Unable to get content for " + url, (Throwable)se);
                                    if (source == null) break block14;
                                    resolver.release(source);
                                }
                                this.manager.release((Object)resolver);
                            }
                            catch (ServiceException se2) {
                                block15: {
                                    this.getLogger().warn("Unable to get source resolver.", (Throwable)se2);
                                    if (source == null) break block15;
                                    {
                                        catch (Throwable throwable) {
                                            if (source != null) {
                                                resolver.release(source);
                                            }
                                            this.manager.release((Object)resolver);
                                            throw throwable;
                                        }
                                    }
                                    resolver.release(source);
                                }
                                this.manager.release((Object)resolver);
                            }
                            resolver.release(source);
                        }
                        this.manager.release((Object)resolver);
                        break block18;
                    }
                    CopletData copletData = service.getComponentManager().getProfileManager().getCopletInstanceData(ci.getCopletId()).getCopletData();
                    cid = service.getComponentManager().getCopletFactory().newInstance(copletData);
                    Map attributes = (Map)ci.getAttribute("coplet-attributes");
                    Iterator i = attributes.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry entry = i.next();
                        cid.setAttribute(entry.getKey().toString(), entry.getValue());
                    }
                }
                layout.setCopletInstanceData(cid);
                Object var14_21 = null;
            }
            catch (Throwable throwable) {
                Object var14_24 = null;
                this.manager.release((Object)service);
                throw throwable;
            }
            this.manager.release((Object)service);
            {
                break block16;
                catch (ProcessingException pe) {
                    this.getLogger().warn("Unable to create new instance.", (Throwable)pe);
                    Object var14_22 = null;
                    this.manager.release((Object)service);
                    break block16;
                }
                catch (ServiceException se) {
                    this.getLogger().warn("Unable to lookup portal service.", (Throwable)se);
                    Object var14_23 = null;
                    this.manager.release((Object)service);
                }
            }
        }
    }

    protected void processShowBasketEvent(ShowBasketEvent event, Session session) {
        Basket basket = this.loadBasket(event.getBasketId());
        session.setAttribute(BasketManager.BASKET_KEY, (Object)basket);
    }

    protected void processCleanBasketEvent(CleanBasketEvent event, Session session) {
        String basketId = event.getBasketId();
        List baskets = (List)session.getAttribute(BasketManager.ALL_BASKETS_KEY);
        if (basketId == null) {
            if (baskets != null) {
                Iterator i = baskets.iterator();
                while (i.hasNext()) {
                    BasketManager.BasketDescription entry = (BasketManager.BasketDescription)i.next();
                    this.deleteBasket(entry.id);
                }
                session.removeAttribute(BasketManager.ALL_BASKETS_KEY);
            }
        } else {
            this.deleteBasket(basketId);
            if (baskets != null) {
                Iterator i = baskets.iterator();
                boolean found = false;
                while (i.hasNext() && !found) {
                    BasketManager.BasketDescription entry = (BasketManager.BasketDescription)i.next();
                    if (!entry.id.equals(basketId)) continue;
                    found = true;
                    i.remove();
                }
            }
        }
    }

    protected void processRemoveItemEvent(RemoveItemEvent event, Basket basket) {
        Object item = event.getItem();
        basket.removeItem(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void processAddItemEvent(AddItemEvent event, Basket basket) {
        block17: {
            Object item;
            block18: {
                ContentItem ci;
                block19: {
                    SourceResolver resolver;
                    block15: {
                        item = event.getItem();
                        if (!(item instanceof ContentItem)) break block18;
                        ci = (ContentItem)item;
                        boolean found = false;
                        if (found) break block17;
                        basket.addItem(ci);
                        if (!ci.isContent()) break block19;
                        resolver = null;
                        Source source = null;
                        String url = null;
                        try {
                            resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
                            url = ci.getURL();
                            if (url == null) {
                                url = "coplet://" + ci.getCopletId();
                            }
                            source = resolver.resolveURI(url);
                            ci.setContent(IOUtil.toByteArray((InputStream)source.getInputStream()));
                            if (source == null) break block15;
                        }
                        catch (IOException se) {
                            block16: {
                                this.getLogger().warn("Unable to get content for " + url, (Throwable)se);
                                if (source == null) break block16;
                                resolver.release(source);
                            }
                            this.manager.release((Object)resolver);
                        }
                        catch (ServiceException se2) {
                            this.getLogger().warn("Unable to get source resolver.", (Throwable)se2);
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                        }
                        finally {
                            if (source != null) {
                                resolver.release(source);
                            }
                            this.manager.release((Object)resolver);
                        }
                        resolver.release(source);
                    }
                    this.manager.release((Object)resolver);
                    break block17;
                }
                if (ci.getURL() == null) {
                    PortalService service = null;
                    try {
                        service = (PortalService)this.manager.lookup(PortalService.ROLE);
                        CopletInstanceData cid = service.getComponentManager().getProfileManager().getCopletInstanceData(ci.getCopletId());
                        HashMap attributes = new HashMap();
                        Iterator i = cid.getAttributes().entrySet().iterator();
                        while (i.hasNext()) {
                            Map.Entry entry = i.next();
                            attributes.put(entry.getKey(), entry.getValue());
                        }
                        ci.setAttribute("coplet-attributes", attributes);
                        Object var13_18 = null;
                    }
                    catch (Throwable throwable) {
                        Object var13_20 = null;
                        this.manager.release((Object)service);
                        throw throwable;
                    }
                    this.manager.release((Object)service);
                    {
                        break block17;
                        catch (ServiceException se) {
                            this.getLogger().warn("Unable to lookup portal service.", (Throwable)se);
                            Object var13_19 = null;
                            this.manager.release((Object)service);
                            break block17;
                        }
                    }
                }
                break block17;
            }
            basket.addItem(item);
        }
    }

    protected Basket loadBasket(String userId) {
        File file;
        if (this.directory != null && (file = new File(this.directory, userId + ".basket")).exists()) {
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));
                Basket basket = (Basket)ois.readObject();
                ois.close();
                return basket;
            }
            catch (Exception ignore) {
            }
        }
        return null;
    }

    protected Basket loadBasket() {
        Basket basket;
        block5: {
            basket = null;
            AuthenticationManager authManager = null;
            try {
                authManager = (AuthenticationManager)this.manager.lookup(AuthenticationManager.ROLE);
                RequestState rs = authManager.getState();
                String user = (String)rs.getHandler().getContext().getContextInfo().get("ID");
                basket = this.loadBasket(user);
            }
            catch (ProcessingException ignore) {
            }
            catch (ServiceException ignore) {
                // empty catch block
            }
            if (basket != null) break block5;
            try {
                basket = (Basket)ClassUtils.newInstance((String)this.basketClassName);
            }
            catch (Exception ignore) {
                basket = new Basket();
            }
        }
        return basket;
    }

    protected void deleteBasket(String userId) {
        File file;
        if (this.directory != null && (file = new File(this.directory, userId + ".basket")).exists()) {
            file.delete();
        }
    }

    protected void saveBasket(Basket basket, String userId) {
        block3: {
            if (this.directory == null) break block3;
            File file = new File(this.directory, userId + ".basket");
            try {
                if (!file.exists()) {
                    file.createNewFile();
                    file = new File(this.directory, userId + ".basket");
                }
                ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(file));
                oos.writeObject(basket);
                oos.close();
            }
            catch (Exception ignore) {}
        }
    }

    protected List loadBaskets() {
        File directory;
        if (this.directory != null && (directory = new File(this.directory)).exists()) {
            ArrayList<BasketManager.BasketDescription> baskets = new ArrayList<BasketManager.BasketDescription>();
            File[] files = directory.listFiles();
            int i = 0;
            while (i < files.length) {
                Basket basket;
                String user = files[i].getName();
                int pos = user.indexOf(".basket");
                if (pos != -1 && (basket = this.loadBasket(user = user.substring(0, pos))) != null) {
                    BasketManager.BasketDescription bd = new BasketManager.BasketDescription();
                    bd.id = user;
                    bd.size = basket.contentSize();
                    baskets.add(bd);
                }
                ++i;
            }
            return baskets;
        }
        return null;
    }

    protected void saveBasket(Basket basket) {
        block3: {
            if (basket == null) break block3;
            AuthenticationManager authManager = null;
            try {
                authManager = (AuthenticationManager)this.manager.lookup(AuthenticationManager.ROLE);
                RequestState rs = authManager.getState();
                String user = (String)rs.getHandler().getContext().getContextInfo().get("ID");
                this.saveBasket(basket, user);
            }
            catch (ProcessingException ignore) {
            }
            catch (ServiceException ignore) {}
        }
    }

    public Basket getBasket() {
        Session session = ContextHelper.getRequest((Context)this.context).getSession();
        Basket basket = (Basket)session.getAttribute(BasketManager.BASKET_KEY);
        if (basket == null) {
            basket = this.loadBasket();
            session.setAttribute(BasketManager.BASKET_KEY, (Object)basket);
        }
        return basket;
    }

    public List getBaskets() {
        Session session = ContextHelper.getRequest((Context)this.context).getSession();
        List baskets = (ArrayList)session.getAttribute(BasketManager.ALL_BASKETS_KEY);
        if (baskets == null) {
            baskets = this.loadBaskets();
            if (baskets == null) {
                baskets = new ArrayList();
            }
            session.setAttribute(BasketManager.ALL_BASKETS_KEY, baskets);
        }
        return baskets;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

