/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.coplets.basket;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.portal.PortalService;
import org.apache.cocoon.portal.coplet.CopletInstanceData;
import org.apache.cocoon.xml.SaxBuffer;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.xml.sax.SAXParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BasketContentGenerator
extends ServiceableGenerator {
    protected String attributeName;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        this.attributeName = par.getParameter("attribute-name", null);
    }

    protected CopletInstanceData getCopletInstanceData() throws SAXException {
        CopletInstanceData copletInstanceData;
        PortalService portalService = null;
        try {
            portalService = (PortalService)this.manager.lookup(PortalService.ROLE);
            Map context = (Map)this.objectModel.get("parent-context");
            String copletId = (String)context.get("cocoon-portal-copletId");
            CopletInstanceData object = portalService.getComponentManager().getProfileManager().getCopletInstanceData(copletId);
            if (object == null) {
                throw new SAXException("Could not find coplet instance data for " + copletId);
            }
            copletInstanceData = object;
            Object var7_7 = null;
        }
        catch (ServiceException e) {
            try {
                throw new SAXException("Error getting portal service.", (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.manager.release((Object)portalService);
                throw throwable;
            }
        }
        this.manager.release((Object)portalService);
        return copletInstanceData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generate() throws IOException, SAXException, ProcessingException {
        SAXParser parser;
        block12: {
            block11: {
                boolean streamed = false;
                parser = null;
                try {
                    try {
                        parser = (SAXParser)this.manager.lookup(SAXParser.ROLE);
                        if (this.attributeName != null) {
                            CopletInstanceData cid = this.getCopletInstanceData();
                            byte[] content = (byte[])cid.getAttribute(this.attributeName);
                            if (content == null) {
                                this.xmlConsumer.startDocument();
                                XMLUtils.createElement((ContentHandler)this.xmlConsumer, (String)"p");
                                this.xmlConsumer.endDocument();
                                Object var10_6 = null;
                                break block11;
                            }
                            try {
                                InputSource is = new InputSource(new ByteArrayInputStream(content));
                                SaxBuffer buffer = new SaxBuffer();
                                parser.parse(is, (ContentHandler)buffer);
                                streamed = true;
                                buffer.toSAX((ContentHandler)this.xmlConsumer);
                            }
                            catch (Exception ignore) {
                                // empty catch block
                            }
                        }
                        if (streamed) break block12;
                        Source source = null;
                        try {
                            source = this.resolver.resolveURI(this.source);
                            parser.parse(SourceUtil.getInputSource((Source)source), (ContentHandler)this.xmlConsumer);
                            Object var8_12 = null;
                        }
                        catch (Throwable throwable) {
                            Object var8_13 = null;
                            this.resolver.release(source);
                            throw throwable;
                        }
                        this.resolver.release(source);
                        break block12;
                    }
                    catch (ServiceException se) {
                        throw new ProcessingException("Unable to lookup parser.", (Throwable)se);
                    }
                }
                catch (Throwable throwable) {
                    Object var10_8 = null;
                    this.manager.release((Object)parser);
                    throw throwable;
                }
            }
            this.manager.release((Object)parser);
            return;
        }
        Object var10_7 = null;
        this.manager.release((Object)parser);
    }
}

