/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.Locale;
import org.apache.cocoon.forms.FormContext;
import org.apache.cocoon.forms.datatype.Datatype;
import org.apache.cocoon.forms.datatype.SelectionList;
import org.apache.cocoon.forms.datatype.convertor.ConversionResult;
import org.apache.cocoon.forms.event.DeferredValueChangedEvent;
import org.apache.cocoon.forms.event.ValueChangedEvent;
import org.apache.cocoon.forms.event.ValueChangedListener;
import org.apache.cocoon.forms.event.ValueChangedListenerEnabled;
import org.apache.cocoon.forms.event.WidgetEvent;
import org.apache.cocoon.forms.event.WidgetEventMulticaster;
import org.apache.cocoon.forms.formmodel.AbstractWidget;
import org.apache.cocoon.forms.formmodel.DataWidget;
import org.apache.cocoon.forms.formmodel.ExpressionContextImpl;
import org.apache.cocoon.forms.formmodel.FieldDefinition;
import org.apache.cocoon.forms.formmodel.SelectableWidget;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.forms.util.I18nMessage;
import org.apache.cocoon.forms.validation.ValidationError;
import org.apache.cocoon.forms.validation.ValidationErrorAware;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Field
extends AbstractWidget
implements ValidationErrorAware,
DataWidget,
SelectableWidget,
ValueChangedListenerEnabled {
    protected SelectionList selectionList;
    private ValueChangedListener listener;
    private final FieldDefinition fieldDefinition;
    protected String enteredValue;
    protected Object value;
    protected boolean needsParse = true;
    protected boolean needsValidate = true;
    private boolean isValidating;
    protected ValidationError validationError;
    private static final String FIELD_EL = "field";
    private static final String VALUE_EL = "value";
    private static final String VALIDATION_MSG_EL = "validation-message";

    public Field(FieldDefinition fieldDefinition) {
        this.fieldDefinition = fieldDefinition;
    }

    public final FieldDefinition getFieldDefinition() {
        return this.fieldDefinition;
    }

    protected WidgetDefinition getDefinition() {
        return this.fieldDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue() {
        if (this.needsParse) {
            this.value = null;
            if (this.enteredValue != null) {
                ConversionResult conversionResult = this.getDatatype().convertFromString(this.enteredValue, this.getForm().getLocale());
                if (conversionResult.isSuccessful()) {
                    this.value = conversionResult.getResult();
                    this.needsParse = false;
                    this.needsValidate = true;
                } else {
                    this.validationError = conversionResult.getValidationError();
                    this.needsValidate = false;
                }
            } else {
                this.needsParse = false;
                this.needsValidate = true;
            }
        }
        if (this.isValidating) {
            return this.value;
        }
        if (this.needsValidate) {
            this.isValidating = true;
            try {
                if (super.validate()) {
                    if (this.value != null) {
                        this.validationError = this.getDatatype().validate(this.value, new ExpressionContextImpl(this));
                    } else if (this.getFieldDefinition().isRequired()) {
                        this.validationError = new ValidationError(new I18nMessage("general.field-required", "forms"));
                    }
                }
                this.needsValidate = false;
                Object var3_2 = null;
                this.isValidating = false;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.isValidating = false;
                throw throwable;
            }
        }
        return this.validationError == null ? this.value : null;
    }

    public void setValue(Object newValue) {
        boolean changed;
        if (newValue != null && !this.getDatatype().getTypeClass().isAssignableFrom(newValue.getClass())) {
            throw new RuntimeException("Incorrect value type for \"" + this.getRequestParameterName() + "\" (expected " + this.getDatatype().getTypeClass() + ", got " + newValue.getClass() + ".");
        }
        Object oldValue = this.value;
        boolean bl = changed = !(oldValue == null ? "" : oldValue).equals(newValue == null ? "" : newValue);
        if (changed || newValue == null) {
            this.value = newValue;
            this.needsParse = false;
            this.validationError = null;
            this.needsValidate = true;
            this.enteredValue = newValue != null ? this.getDatatype().convertToString(newValue, this.getForm().getLocale()) : null;
            if (changed) {
                this.getForm().addWidgetEvent(new ValueChangedEvent(this, oldValue, newValue));
            }
        }
    }

    public void readFromRequest(FormContext formContext) {
        String newEnteredValue = formContext.getRequest().getParameter(this.getRequestParameterName());
        this.readFromRequest(newEnteredValue);
    }

    protected void readFromRequest(String newEnteredValue) {
        if (newEnteredValue != null && (newEnteredValue = newEnteredValue.trim()).length() == 0) {
            newEnteredValue = null;
        }
        if (!(newEnteredValue == null ? "" : newEnteredValue).equals(this.enteredValue == null ? "" : this.enteredValue)) {
            this.getForm().addWidgetEvent(new DeferredValueChangedEvent(this, this.value));
            this.enteredValue = newEnteredValue;
            this.validationError = null;
            this.value = null;
            this.needsParse = true;
        }
        this.needsValidate = true;
    }

    public boolean validate() {
        this.getValue();
        return this.validationError == null;
    }

    public ValidationError getValidationError() {
        return this.validationError;
    }

    public void setValidationError(ValidationError error) {
        this.validationError = error;
    }

    public boolean isRequired() {
        return this.getFieldDefinition().isRequired();
    }

    public String getXMLElementName() {
        return FIELD_EL;
    }

    public AttributesImpl getXMLElementAttributes() {
        AttributesImpl attrs = super.getXMLElementAttributes();
        attrs.addCDATAAttribute("required", String.valueOf(this.isRequired()));
        return attrs;
    }

    public void generateItemSaxFragment(ContentHandler contentHandler, Locale locale) throws SAXException {
        if (this.enteredValue != null || this.value != null) {
            contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", VALUE_EL, "fi:value", (Attributes)XMLUtils.EMPTY_ATTRIBUTES);
            String stringValue = this.value != null ? this.getDatatype().convertToString(this.value, locale) : this.enteredValue;
            contentHandler.characters(stringValue.toCharArray(), 0, stringValue.length());
            contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", VALUE_EL, "fi:value");
        }
        if (this.validationError != null) {
            contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", VALIDATION_MSG_EL, "fi:validation-message", (Attributes)XMLUtils.EMPTY_ATTRIBUTES);
            this.validationError.generateSaxFragment(contentHandler);
            contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", VALIDATION_MSG_EL, "fi:validation-message");
        }
        if (this.selectionList != null) {
            this.selectionList.generateSaxFragment(contentHandler, locale);
        } else if (this.getFieldDefinition().getSelectionList() != null) {
            this.getFieldDefinition().getSelectionList().generateSaxFragment(contentHandler, locale);
        }
        this.fieldDefinition.getDatatype().generateSaxFragment(contentHandler, locale);
    }

    public void setSelectionList(SelectionList selectionList) {
        if (selectionList != null && selectionList.getDatatype() != null && selectionList.getDatatype() != this.getDatatype()) {
            throw new RuntimeException("Tried to assign a SelectionList that is not associated with this widget's datatype.");
        }
        this.selectionList = selectionList;
    }

    public void setSelectionList(String uri) {
        this.setSelectionList(this.getFieldDefinition().buildSelectionList(uri));
    }

    public void setSelectionList(Object model, String valuePath, String labelPath) {
        this.setSelectionList(this.getFieldDefinition().buildSelectionListFromModel(model, valuePath, labelPath));
    }

    public Datatype getDatatype() {
        return this.getFieldDefinition().getDatatype();
    }

    public void addValueChangedListener(ValueChangedListener listener) {
        this.listener = WidgetEventMulticaster.add(this.listener, listener);
    }

    public void removeValueChangedListener(ValueChangedListener listener) {
        this.listener = WidgetEventMulticaster.remove(this.listener, listener);
    }

    private void fireValueChangedEvent(ValueChangedEvent event) {
        if (this.listener != null) {
            this.listener.valueChanged(event);
        }
    }

    public void broadcastEvent(WidgetEvent event) {
        this.getFieldDefinition().fireValueChangedEvent((ValueChangedEvent)event);
        this.fireValueChangedEvent((ValueChangedEvent)event);
    }
}

