/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreDocComparator;
import org.apache.lucene.search.SortComparatorSource;

public abstract class SortComparator
implements SortComparatorSource {
    public ScoreDocComparator newComparator(final IndexReader reader, String fieldname) throws IOException {
        final String field = fieldname.intern();
        return new ScoreDocComparator(){
            protected Comparable[] cachedValues;
            {
                this.cachedValues = FieldCache.DEFAULT.getCustom(reader, field, SortComparator.this);
            }

            public int compare(ScoreDoc i, ScoreDoc j) {
                return this.cachedValues[i.doc].compareTo(this.cachedValues[j.doc]);
            }

            public Comparable sortValue(ScoreDoc i) {
                return this.cachedValues[i.doc];
            }

            public int sortType() {
                return 9;
            }
        };
    }

    protected abstract Comparable getComparable(String var1);
}

