/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import com.icl.saxon.Controller;
import com.icl.saxon.DOMDriver;
import com.icl.saxon.Filter;
import com.icl.saxon.IdentityTransformer;
import com.icl.saxon.IdentityTransformerHandler;
import com.icl.saxon.Loader;
import com.icl.saxon.PIGrabber;
import com.icl.saxon.PreparedStyleSheet;
import com.icl.saxon.StandardErrorListener;
import com.icl.saxon.StandardURIResolver;
import com.icl.saxon.TemplatesHandlerImpl;
import com.icl.saxon.TransformerHandlerImpl;
import com.icl.saxon.TreeDriver;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.trace.TraceListener;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.ParserAdapter;

public class TransformerFactoryImpl
extends SAXTransformerFactory {
    private URIResolver resolver = new StandardURIResolver(this);
    private ErrorListener listener = new StandardErrorListener();
    private int treeModel = 1;
    private boolean lineNumbering = false;
    private TraceListener traceListener = null;
    private int recoveryPolicy = 1;
    private String messageEmitterClass = "com.icl.saxon.output.MessageEmitter";
    private String sourceParserClass;
    private String styleParserClass;
    private boolean timing = false;
    private boolean allowExternalFunctions = true;

    public Transformer newTransformer(Source source) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(source);
        Transformer transformer = templates.newTransformer();
        return transformer;
    }

    public Transformer newTransformer() throws TransformerConfigurationException {
        return new IdentityTransformer(this);
    }

    public Templates newTemplates(Source source) throws TransformerConfigurationException {
        PreparedStyleSheet preparedStyleSheet = new PreparedStyleSheet(this);
        SAXSource sAXSource = this.getSAXSource(source, true);
        preparedStyleSheet.prepare(sAXSource);
        return preparedStyleSheet;
    }

    public SAXSource getSAXSource(Source source, boolean bl) {
        if (source instanceof SAXSource) {
            if (((SAXSource)source).getXMLReader() == null) {
                SAXSource sAXSource = new SAXSource();
                sAXSource.setInputSource(((SAXSource)source).getInputSource());
                sAXSource.setSystemId(source.getSystemId());
                sAXSource.setXMLReader(bl ? this.getStyleParser() : this.getSourceParser());
                return sAXSource;
            }
            return (SAXSource)source;
        }
        if (source instanceof DOMSource) {
            InputSource inputSource = new InputSource("dummy");
            Node node = ((DOMSource)source).getNode();
            Document document = node instanceof Document ? (Document)node : node.getOwnerDocument();
            DOMDriver dOMDriver = node instanceof NodeInfo ? new TreeDriver() : new DOMDriver();
            dOMDriver.setStartNode(document);
            inputSource.setSystemId(source.getSystemId());
            dOMDriver.setSystemId(source.getSystemId());
            return new SAXSource(dOMDriver, inputSource);
        }
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            String string = source.getSystemId();
            InputSource inputSource = new InputSource(string);
            inputSource.setCharacterStream(streamSource.getReader());
            inputSource.setByteStream(streamSource.getInputStream());
            return new SAXSource(bl ? this.getStyleParser() : this.getSourceParser(), inputSource);
        }
        throw new IllegalArgumentException("Unknown type of source");
    }

    public Source getAssociatedStylesheet(Source source, String string, String string2, String string3) throws TransformerConfigurationException {
        PIGrabber pIGrabber = new PIGrabber();
        pIGrabber.setCriteria(string, string2, string3);
        pIGrabber.setBaseURI(source.getSystemId());
        pIGrabber.setURIResolver(this.resolver);
        SAXSource sAXSource = this.getSAXSource(source, false);
        XMLReader xMLReader = sAXSource.getXMLReader();
        xMLReader.setContentHandler(pIGrabber);
        try {
            xMLReader.parse(sAXSource.getInputSource());
        }
        catch (SAXException sAXException) {
            if (!sAXException.getMessage().equals("#start#")) {
                System.err.println("Failed while looking for xml-stylesheet PI");
                System.err.println(sAXException.getMessage());
                if (sAXException.getException() != null) {
                    sAXException.getException().printStackTrace();
                }
                if (sAXException instanceof SAXParseException) {
                    SAXParseException sAXParseException = (SAXParseException)sAXException;
                    System.err.println("At line " + sAXParseException.getLineNumber() + " in " + sAXParseException.getSystemId());
                }
                throw new TransformerConfigurationException(sAXException);
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            throw new TransformerConfigurationException("XML parsing failure while looking for <?xml-stylesheet?>");
        }
        try {
            SAXSource[] sAXSourceArray = pIGrabber.getAssociatedStylesheets();
            if (sAXSourceArray == null) {
                throw new TransformerConfigurationException("No matching <?xml-stylesheet?> processing instruction found");
            }
            return this.compositeStylesheet(sAXSourceArray);
        }
        catch (TransformerException transformerException) {
            if (transformerException instanceof TransformerConfigurationException) {
                throw (TransformerConfigurationException)transformerException;
            }
            throw new TransformerConfigurationException(transformerException);
        }
    }

    public Source compositeStylesheet(SAXSource[] sAXSourceArray) throws TransformerConfigurationException {
        if (sAXSourceArray.length == 1) {
            return sAXSourceArray[0];
        }
        if (sAXSourceArray.length == 0) {
            throw new TransformerConfigurationException("No stylesheets were supplied");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<xsl:stylesheet version='1.0' ");
        stringBuffer.append(" xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>");
        int n = 0;
        while (n < sAXSourceArray.length) {
            stringBuffer.append("<xsl:import href='" + sAXSourceArray[n].getInputSource().getSystemId() + "'/>");
            ++n;
        }
        stringBuffer.append("</xsl:stylesheet>");
        InputSource inputSource = new InputSource();
        inputSource.setCharacterStream(new StringReader(stringBuffer.toString()));
        return new SAXSource(this.getSourceParser(), inputSource);
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.resolver = uRIResolver;
    }

    public URIResolver getURIResolver() {
        return this.resolver;
    }

    public boolean getFeature(String string) {
        if (string.equals("http://javax.xml.transform.sax.SAXSource/feature")) {
            return true;
        }
        if (string.equals("http://javax.xml.transform.sax.SAXResult/feature")) {
            return true;
        }
        if (string.equals("http://javax.xml.transform.dom.DOMSource/feature")) {
            return true;
        }
        if (string.equals("http://javax.xml.transform.dom.DOMResult/feature")) {
            return true;
        }
        if (string.equals("http://javax.xml.transform.stream.StreamSource/feature")) {
            return true;
        }
        if (string.equals("http://javax.xml.transform.stream.StreamResult/feature")) {
            return true;
        }
        if (string.equals("http://javax.xml.transform.sax.SAXTransformerFactory/feature")) {
            return true;
        }
        if (string.equals("http://javax.xml.transform.sax.SAXTransformerFactory/feature/xmlfilter")) {
            return true;
        }
        throw new IllegalArgumentException("Unknown feature " + string);
    }

    public void setAttribute(String string, Object object) throws IllegalArgumentException {
        if (string.equals("http://icl.com/saxon/feature/treeModel")) {
            if (!(object instanceof Integer)) {
                throw new IllegalArgumentException("Tree model must be an Integer");
            }
            this.treeModel = (Integer)object;
        } else if (string.equals("http://icl.com/saxon/feature/allow-external-functions")) {
            if (!(object instanceof Boolean)) {
                throw new IllegalArgumentException("allow-external-functions must be a boolean");
            }
            this.allowExternalFunctions = (Boolean)object;
        } else if (string.equals("http://icl.com/saxon/feature/timing")) {
            if (!(object instanceof Boolean)) {
                throw new IllegalArgumentException("Timing must be a boolean");
            }
            this.timing = (Boolean)object;
        } else if (string.equals("http://icl.com/saxon/feature/traceListener")) {
            if (!(object instanceof TraceListener)) {
                throw new IllegalArgumentException("Trace listener is of wrong class");
            }
            this.traceListener = (TraceListener)object;
        } else if (string.equals("http://icl.com/saxon/feature/linenumbering")) {
            if (!(object instanceof Boolean)) {
                throw new IllegalArgumentException("Line Numbering value must be Boolean");
            }
            this.lineNumbering = (Boolean)object;
        } else if (string.equals("http://icl.com/saxon/feature/recoveryPolicy")) {
            if (!(object instanceof Integer)) {
                throw new IllegalArgumentException("Recovery Policy value must be Integer");
            }
            this.recoveryPolicy = (Integer)object;
        } else if (string.equals("http://icl.com/saxon/feature/messageEmitterClass")) {
            if (!(object instanceof String)) {
                throw new IllegalArgumentException("Message Emitter class must be a String");
            }
            this.messageEmitterClass = (String)object;
        } else if (string.equals("http://icl.com/saxon/feature/sourceParserClass")) {
            if (!(object instanceof String)) {
                throw new IllegalArgumentException("Source Parser class must be a String");
            }
            this.sourceParserClass = (String)object;
        } else if (string.equals("http://icl.com/saxon/feature/styleParserClass")) {
            if (!(object instanceof String)) {
                throw new IllegalArgumentException("Style Parser class must be a String");
            }
            this.styleParserClass = (String)object;
        } else {
            throw new IllegalArgumentException("Unknown attribute " + string);
        }
    }

    public Object getAttribute(String string) throws IllegalArgumentException {
        if (string.equals("http://icl.com/saxon/feature/treeModel")) {
            return new Integer(this.treeModel);
        }
        if (string.equals("http://icl.com/saxon/feature/timing")) {
            return new Boolean(this.timing);
        }
        if (string.equals("http://icl.com/saxon/feature/allow-external-functions")) {
            return new Boolean(this.allowExternalFunctions);
        }
        if (string.equals("http://icl.com/saxon/feature/traceListener")) {
            return this.traceListener;
        }
        if (string.equals("http://icl.com/saxon/feature/linenumbering")) {
            return new Boolean(this.lineNumbering);
        }
        if (string.equals("http://icl.com/saxon/feature/recoveryPolicy")) {
            return new Integer(this.recoveryPolicy);
        }
        if (string.equals("http://icl.com/saxon/feature/messageEmitterClass")) {
            return this.messageEmitterClass;
        }
        if (string.equals("http://icl.com/saxon/feature/sourceParserClass")) {
            return this.sourceParserClass;
        }
        if (string.equals("http://icl.com/saxon/feature/styleParserClass")) {
            return this.styleParserClass;
        }
        throw new IllegalArgumentException("Unknown attribute " + string);
    }

    public void setErrorListener(ErrorListener errorListener) throws IllegalArgumentException {
        this.listener = errorListener;
    }

    public ErrorListener getErrorListener() {
        return this.listener;
    }

    public XMLReader getSourceParser() throws TransformerFactoryConfigurationError {
        if (this.sourceParserClass != null) {
            return TransformerFactoryImpl.makeParser(this.sourceParserClass);
        }
        try {
            return SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        }
        catch (Exception exception) {
            throw new TransformerFactoryConfigurationError(exception);
        }
    }

    public XMLReader getStyleParser() throws TransformerFactoryConfigurationError {
        if (this.styleParserClass != null) {
            return TransformerFactoryImpl.makeParser(this.styleParserClass);
        }
        try {
            return SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        }
        catch (Exception exception) {
            throw new TransformerFactoryConfigurationError(exception);
        }
    }

    public static XMLReader makeParser(String string) throws TransformerFactoryConfigurationError {
        Object object;
        try {
            object = Loader.getInstance(string);
        }
        catch (TransformerException transformerException) {
            throw new TransformerFactoryConfigurationError(transformerException);
        }
        if (object instanceof XMLReader) {
            return (XMLReader)object;
        }
        if (object instanceof Parser) {
            return new ParserAdapter((Parser)object);
        }
        throw new TransformerFactoryConfigurationError("Class " + string + " is neither a SAX1 Parser nor a SAX2 XMLReader");
    }

    public TransformerHandler newTransformerHandler(Source source) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(source);
        return this.newTransformerHandler(templates);
    }

    public TransformerHandler newTransformerHandler(Templates templates) throws TransformerConfigurationException {
        if (!(templates instanceof PreparedStyleSheet)) {
            throw new TransformerConfigurationException("Templates object was not created by Saxon");
        }
        Controller controller = (Controller)templates.newTransformer();
        if (controller.usesPreviewMode()) {
            throw new TransformerConfigurationException("Preview mode is not available with a TransformerHandler");
        }
        TransformerHandlerImpl transformerHandlerImpl = new TransformerHandlerImpl(controller);
        return transformerHandlerImpl;
    }

    public TransformerHandler newTransformerHandler() throws TransformerConfigurationException {
        IdentityTransformer identityTransformer = new IdentityTransformer(this);
        return new IdentityTransformerHandler(identityTransformer);
    }

    public TemplatesHandler newTemplatesHandler() throws TransformerConfigurationException {
        return new TemplatesHandlerImpl(this);
    }

    public XMLFilter newXMLFilter(Source source) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(source);
        return this.newXMLFilter(templates);
    }

    public XMLFilter newXMLFilter(Templates templates) throws TransformerConfigurationException {
        if (!(templates instanceof PreparedStyleSheet)) {
            throw new TransformerConfigurationException("Supplied Templates object was not created using Saxon");
        }
        Controller controller = (Controller)templates.newTransformer();
        return new Filter(controller);
    }
}

