/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.om.NamespaceException;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.tree.AttributeCollection;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class XSLElement
extends StyleElement {
    private Expression elementName;
    private Expression namespace = null;
    private String use;
    private boolean declared = false;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainTemplateBody() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            int n3 = n2 & 0xFFFFF;
            if (n3 == standardNames.NAME) {
                string = attributeCollection.getValue(n);
            } else if (n3 == standardNames.NAMESPACE) {
                string2 = attributeCollection.getValue(n);
            } else if (n3 == standardNames.USE_ATTRIBUTE_SETS) {
                this.use = attributeCollection.getValue(n);
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string == null) {
            this.reportAbsence("name");
        } else {
            this.elementName = this.makeAttributeValueTemplate(string);
            if (this.elementName instanceof StringValue && !Name.isQName(string)) {
                this.compileError("Element name is not a valid QName");
            }
        }
        if (string2 != null) {
            this.namespace = this.makeAttributeValueTemplate(string2);
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        if (this.use != null) {
            this.findAttributeSets(this.use);
        }
    }

    public void process(Context context) throws TransformerException {
        String string;
        short s;
        Controller controller = context.getController();
        NamePool namePool = controller.getNamePool();
        String string2 = this.elementName.evaluateAsString(context);
        if (!Name.isQName(string2)) {
            controller.reportRecoverableError("Invalid element name: " + string2, this);
            this.processChildren(context);
            return;
        }
        String string3 = Name.getPrefix(string2);
        if (this.namespace == null) {
            try {
                s = this.getURICodeForPrefix(string3);
            }
            catch (NamespaceException namespaceException) {
                throw this.styleError(namespaceException.getMessage());
            }
        } else {
            string = this.namespace.evaluateAsString(context);
            if (string.equals("")) {
                string3 = "";
            }
            s = namePool.allocateCodeForURI(string);
        }
        string = Name.getLocalName(string2);
        int n = namePool.allocate(string3, s, string);
        Outputter outputter = context.getOutputter();
        outputter.writeStartTag(n);
        outputter.writeNamespaceDeclaration(namePool.allocateNamespaceCode(n));
        this.processAttributeSets(context);
        this.processChildren(context);
        outputter.writeEndTag(n);
    }
}

