/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.functions;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.FragmentValue;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.SingletonNodeSet;
import com.icl.saxon.expr.TextFragmentValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.Builder;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;

public class Document
extends Function {
    private Controller boundController = null;

    public String getName() {
        return "document";
    }

    public int getDataType() {
        return 4;
    }

    public Expression simplify() throws XPathException {
        int n = this.checkArgumentCount(1, 2);
        this.argument[0] = this.argument[0].simplify();
        if (n == 2) {
            this.argument[1] = this.argument[1].simplify();
        }
        return this;
    }

    public Value evaluate(Context context) throws XPathException {
        int n = this.getNumberOfArguments();
        Value value = this.argument[0].evaluate(context);
        NodeSetValue nodeSetValue = null;
        if (n == 2) {
            nodeSetValue = this.argument[1].evaluateAsNodeSet(context);
        }
        String string = this.getStaticContext().getBaseURI();
        return this.getDocuments(value, nodeSetValue, string, context);
    }

    public NodeSetValue getDocuments(Value value, NodeSetValue nodeSetValue, String string, Context context) throws XPathException {
        Object object;
        if (value instanceof NodeSetValue && !(value instanceof FragmentValue) && !(value instanceof TextFragmentValue)) {
            NodeEnumeration nodeEnumeration = ((NodeSetValue)value).enumerate();
            NodeSetExtent nodeSetExtent = new NodeSetExtent(context.getController());
            while (nodeEnumeration.hasMoreElements()) {
                NodeInfo nodeInfo;
                String string2;
                NodeInfo nodeInfo2 = nodeEnumeration.nextElement();
                if (nodeSetValue == null) {
                    string2 = nodeInfo2.getBaseURI();
                } else {
                    nodeInfo = nodeSetValue.getFirst();
                    if (nodeInfo == null) {
                        throw new XPathException("Second argument to document() is empty node-set");
                    }
                    string2 = nodeInfo.getBaseURI();
                }
                nodeInfo = this.makeDoc(nodeInfo2.getStringValue(), string2, context);
                if (nodeInfo == null) continue;
                nodeSetExtent.append(nodeInfo);
            }
            return nodeSetExtent;
        }
        Object object2 = nodeSetValue == null ? string : ((object = nodeSetValue.getFirst()) == null ? null : object.getBaseURI());
        object = value.asString();
        DocumentInfo documentInfo = this.makeDoc((String)object, (String)object2, context);
        return new SingletonNodeSet(documentInfo);
    }

    private DocumentInfo makeDoc(String string, String string2, Context context) throws XPathException {
        Object object;
        String string3;
        if (string2 == null) {
            try {
                string3 = new URL(string).toString();
            }
            catch (MalformedURLException malformedURLException) {
                string3 = string2 + "/" + string;
                string2 = "";
            }
        } else {
            try {
                object = new URL(new URL(string2), string);
                string3 = ((URL)object).toString();
            }
            catch (MalformedURLException malformedURLException) {
                string3 = string2 + "/../" + string;
            }
        }
        object = this.boundController;
        if (object == null) {
            object = context.getController();
        }
        if (object == null) {
            throw new XPathException("Internal error: no controller available for document() function");
        }
        DocumentInfo documentInfo = ((Controller)object).getDocumentPool().find(string3);
        if (documentInfo != null) {
            return documentInfo;
        }
        try {
            URIResolver uRIResolver = ((Controller)object).getURIResolver();
            Source source = uRIResolver.resolve(string, string2);
            if (source == null) {
                uRIResolver = ((Controller)object).getStandardURIResolver();
                source = uRIResolver.resolve(string, string2);
            }
            DocumentInfo documentInfo2 = null;
            if (source instanceof DocumentInfo) {
                documentInfo2 = (DocumentInfo)source;
            } else {
                Source source2;
                if (source instanceof DOMSource && (source2 = (DOMSource)source).getNode() instanceof DocumentInfo) {
                    documentInfo2 = (DocumentInfo)((Object)source2.getNode());
                }
                if (documentInfo2 == null) {
                    source2 = ((Controller)object).getTransformerFactory().getSAXSource(source, false);
                    Builder builder = ((Controller)object).makeBuilder();
                    documentInfo2 = builder.build((SAXSource)source2);
                }
            }
            ((Controller)object).getDocumentPool().add(documentInfo2, string3);
            return documentInfo2;
        }
        catch (TransformerException transformerException) {
            try {
                ((Controller)object).reportRecoverableError(transformerException);
            }
            catch (TransformerException transformerException2) {
                throw new XPathException(transformerException);
            }
            return null;
        }
    }

    public int getDependencies() {
        int n = this.argument[0].getDependencies();
        if (this.getNumberOfArguments() == 2) {
            n |= this.argument[1].getDependencies();
        }
        if (this.boundController == null) {
            return n | 0x40;
        }
        return n;
    }

    public Expression reduce(int n, Context context) throws XPathException {
        Document document = new Document();
        document.addArgument(this.argument[0].reduce(n, context));
        if (this.getNumberOfArguments() == 2) {
            document.addArgument(this.argument[1].reduce(n, context));
        }
        document.setStaticContext(this.getStaticContext());
        if (this.boundController == null && (n & 0x40) != 0) {
            document.boundController = context.getController();
        }
        if (document.getDependencies() == 0) {
            return document.evaluate(context);
        }
        return document;
    }
}

