/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.flow.Interpreter;
import org.apache.cocoon.components.treeprocessor.AbstractProcessingNode;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.sitemap.PipelinesNode;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolverFactory;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.sitemap.PatternException;

public class CallFunctionNode
extends AbstractProcessingNode
implements Configurable,
Composable {
    protected List parameters;
    protected VariableResolver functionName;
    protected VariableResolver continuationId;
    protected ComponentManager manager;
    protected Interpreter interpreter;

    public static List resolveList(List expressions, ComponentManager manager, InvokeContext context, Map objectModel) throws PatternException {
        int size;
        if (expressions == null || (size = expressions.size()) == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Interpreter.Argument> result = new ArrayList<Interpreter.Argument>(size);
        int i = 0;
        while (i < size) {
            Interpreter.Argument arg = (Interpreter.Argument)expressions.get(i);
            String value = VariableResolverFactory.getResolver(arg.value, manager).resolve(context, objectModel);
            result.add(new Interpreter.Argument(arg.name, value));
            ++i;
        }
        return result;
    }

    public CallFunctionNode(VariableResolver functionName, VariableResolver continuationId) {
        this.functionName = functionName;
        this.continuationId = continuationId;
    }

    public void setInterpreter(Interpreter interp) throws Exception {
        this.interpreter = interp;
    }

    public void configure(Configuration config) throws ConfigurationException {
        this.parameters = new ArrayList();
        Configuration[] params = config.getChildren("parameter");
        int i = 0;
        while (i < params.length) {
            Configuration param = params[i];
            String name = param.getAttribute("name", null);
            String value = param.getAttribute("value", null);
            this.parameters.add(new Interpreter.Argument(name, value));
            ++i;
        }
    }

    public void compose(ComponentManager manager) {
        this.manager = manager;
    }

    public boolean invoke(Environment env, InvokeContext context) throws Exception {
        String continuation;
        List params = null;
        if (this.parameters != null) {
            params = CallFunctionNode.resolveList(this.parameters, this.manager, context, env.getObjectModel());
        }
        if ((continuation = this.continuationId.resolve(context, env.getObjectModel())) != null && continuation.length() > 0) {
            this.interpreter.handleContinuation(continuation, params, PipelinesNode.getRedirector(env));
            return true;
        }
        String name = this.functionName.resolve(context, env.getObjectModel());
        if (name != null && name.length() > 0) {
            this.interpreter.callFunction(name, params, PipelinesNode.getRedirector(env));
            return true;
        }
        throw new ProcessingException("No function nor continuation given in <map:call function> at " + this.getLocation());
    }
}

