/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.Processor;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.components.CocoonComponentManager;
import org.apache.cocoon.components.pipeline.ProcessingPipeline;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.wrapper.EnvironmentWrapper;
import org.apache.cocoon.environment.wrapper.MutableEnvironmentFacade;
import org.apache.cocoon.xml.ContentHandlerWrapper;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.xml.sax.XMLizable;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public final class SitemapSource
extends AbstractLogEnabled
implements Source,
XMLizable {
    private SourceValidity sourceValidity;
    private String systemId;
    private String systemIdForCaching;
    private ComponentManager manager;
    private Processor processor;
    private Processor pipelineProcessor;
    private MutableEnvironmentFacade environment;
    private ProcessingPipeline processingPipeline;
    private Source redirectSource;
    private SourceValidity redirectValidity;
    private SAXException exception;
    private boolean needsRefresh;
    private Object processKey;
    private String protocol;
    private SourceResolver sourceResolver;
    private String mimeType;

    public SitemapSource(ComponentManager manager, String uri, Map parameters, Logger logger) throws MalformedURLException {
        String tmp;
        int index;
        String prefix;
        Environment env = CocoonComponentManager.getCurrentEnvironment();
        if (env == null) {
            throw new MalformedURLException("The cocoon protocol can not be used outside an environment.");
        }
        this.manager = manager;
        this.enableLogging(logger);
        boolean rawMode = false;
        int position = uri.indexOf(58) + 1;
        if (position != 0) {
            this.protocol = uri.substring(0, position - 1);
            if (uri.startsWith("raw:", position)) {
                position += 4;
                rawMode = true;
            }
        } else {
            throw new MalformedURLException("No protocol found for sitemap source in " + uri);
        }
        if (uri.startsWith("//", position)) {
            position += 2;
            try {
                this.processor = (Processor)this.manager.lookup(Processor.ROLE);
            }
            catch (ComponentException e) {
                throw new MalformedURLException("Cannot get Processor instance");
            }
            prefix = "";
        } else if (uri.startsWith("/", position)) {
            ++position;
            prefix = null;
            this.processor = CocoonComponentManager.getCurrentProcessor();
        } else {
            throw new MalformedURLException("Malformed cocoon URI: " + uri);
        }
        String queryString = null;
        int queryStringPos = uri.indexOf(63, position);
        if (queryStringPos != -1) {
            queryString = uri.substring(queryStringPos + 1);
            uri = uri.substring(position, queryStringPos);
        } else if (position > 0) {
            uri = uri.substring(position);
        }
        String view = null;
        view = queryString != null ? ((index = queryString.indexOf("cocoon-view")) != -1 && (index == 0 || queryString.charAt(index - 1) == '&') && queryString.length() > index + "cocoon-view".length() && queryString.charAt(index + "cocoon-view".length()) == '=' ? ((index = (tmp = queryString.substring(index + "cocoon-view".length() + 1)).indexOf(38)) != -1 ? tmp.substring(0, index) : tmp) : env.getView()) : env.getView();
        String requestURI = prefix == null ? env.getURIPrefix() + uri : uri;
        this.systemId = queryString == null ? this.protocol + "://" + requestURI : this.protocol + "://" + requestURI + "?" + queryString;
        EnvironmentWrapper wrapper = new EnvironmentWrapper(env, requestURI, queryString, logger, manager, rawMode, view);
        wrapper.setURI(prefix, uri);
        this.environment = new MutableEnvironmentFacade(wrapper);
        if (null != parameters) {
            this.environment.getObjectModel().put("parent-context", parameters);
        } else {
            this.environment.getObjectModel().remove("parent-context");
        }
        this.init();
    }

    public String getScheme() {
        return this.protocol;
    }

    public long getContentLength() {
        return -1L;
    }

    public long getLastModified() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getInputStream() throws IOException, SourceException {
        if (this.needsRefresh) {
            this.refresh();
        }
        if (this.exception != null) {
            throw new SourceException("Cannot get input stream for " + this.getURI(), (Throwable)this.exception);
        }
        if (this.redirectSource != null) {
            return this.redirectSource.getInputStream();
        }
        try {
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                this.environment.setOutputStream(os);
                CocoonComponentManager.enterEnvironment(this.environment, this.manager, this.pipelineProcessor);
                try {
                    this.processingPipeline.process(this.environment);
                    Object var3_3 = null;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    CocoonComponentManager.leaveEnvironment();
                    throw throwable;
                }
                CocoonComponentManager.leaveEnvironment();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(os.toByteArray());
                Object var5_8 = null;
                this.environment.setOutputStream(null);
                this.reset();
                return byteArrayInputStream;
            }
            catch (ResourceNotFoundException e) {
                throw new SourceNotFoundException("Exception during processing of " + this.systemId, (Throwable)((Object)e));
            }
            catch (Exception e) {
                throw new SourceException("Exception during processing of " + this.systemId, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.environment.setOutputStream(null);
            this.reset();
            throw throwable;
        }
    }

    public String getURI() {
        return this.systemIdForCaching;
    }

    public boolean exists() {
        return true;
    }

    public SourceValidity getValidity() {
        if (this.needsRefresh) {
            this.refresh();
        }
        if (this.redirectSource != null) {
            return this.redirectValidity;
        }
        return this.sourceValidity;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void refresh() {
        this.reset();
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        block12: {
            this.systemIdForCaching = this.systemId;
            try {
                this.processKey = CocoonComponentManager.startProcessing(this.environment);
                this.processingPipeline = this.processor.buildPipeline(this.environment);
                this.pipelineProcessor = CocoonComponentManager.getLastProcessor(this.environment);
                this.environment.changeToLastContext();
                String redirectURL = this.environment.getRedirectURL();
                if (redirectURL == null) {
                    CocoonComponentManager.enterEnvironment(this.environment, this.manager, this.pipelineProcessor);
                    try {
                        this.processingPipeline.prepareInternal(this.environment);
                        this.sourceValidity = this.processingPipeline.getValidityForEventPipeline();
                        this.mimeType = this.environment.getContentType();
                        String eventPipelineKey = this.processingPipeline.getKeyForEventPipeline();
                        if (eventPipelineKey != null) {
                            StringBuffer buffer = new StringBuffer(this.systemId);
                            if (this.systemId.indexOf(63) == -1) {
                                buffer.append('?');
                            } else {
                                buffer.append('&');
                            }
                            buffer.append("pipelinehash=");
                            buffer.append(eventPipelineKey);
                            this.systemIdForCaching = buffer.toString();
                        } else {
                            this.systemIdForCaching = this.systemId;
                        }
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        CocoonComponentManager.leaveEnvironment();
                        throw throwable;
                    }
                    CocoonComponentManager.leaveEnvironment();
                    {
                        break block12;
                    }
                }
                if (redirectURL.indexOf(":") == -1) {
                    redirectURL = this.protocol + ":/" + redirectURL;
                }
                if (this.sourceResolver == null) {
                    this.sourceResolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
                }
                this.redirectSource = this.sourceResolver.resolveURI(redirectURL);
                this.redirectValidity = this.redirectSource.getValidity();
                this.mimeType = this.redirectSource.getMimeType();
            }
            catch (SAXException e) {
                this.reset();
                this.exception = e;
            }
            catch (Exception e) {
                this.reset();
                this.exception = new SAXException("Could not get sitemap source " + this.systemId, e);
            }
        }
        this.needsRefresh = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toSAX(ContentHandler contentHandler) throws SAXException {
        if (this.needsRefresh) {
            this.refresh();
        }
        if (this.exception != null) {
            throw this.exception;
        }
        try {
            try {
                if (this.redirectSource != null) {
                    SourceUtil.parse(this.manager, this.redirectSource, contentHandler);
                } else {
                    XMLConsumer consumer = contentHandler instanceof XMLConsumer ? (XMLConsumer)((Object)contentHandler) : (contentHandler instanceof LexicalHandler ? new ContentHandlerWrapper(contentHandler, (LexicalHandler)((Object)contentHandler)) : new ContentHandlerWrapper(contentHandler));
                    CocoonComponentManager.enterEnvironment(this.environment, this.manager, this.pipelineProcessor);
                    try {
                        this.processingPipeline.process(this.environment, CocoonComponentManager.createEnvironmentAwareConsumer(consumer));
                        Object var4_4 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        CocoonComponentManager.leaveEnvironment();
                        throw throwable;
                    }
                    CocoonComponentManager.leaveEnvironment();
                    {
                    }
                }
                Object var6_8 = null;
                this.reset();
            }
            catch (SAXException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SAXException("Exception during processing of " + this.systemId, e);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.reset();
            throw throwable;
        }
    }

    private void reset() {
        if (this.processingPipeline != null) {
            this.processingPipeline.release();
        }
        if (this.processKey != null) {
            CocoonComponentManager.endProcessing(this.environment, this.processKey);
            this.processKey = null;
        }
        this.processingPipeline = null;
        this.sourceValidity = null;
        if (this.redirectSource != null) {
            this.sourceResolver.release(this.redirectSource);
        }
        this.environment.reset();
        this.redirectSource = null;
        this.redirectValidity = null;
        this.exception = null;
        this.needsRefresh = true;
        this.pipelineProcessor = null;
    }

    public void recycle() {
        this.reset();
        if (this.sourceResolver != null) {
            this.manager.release((Component)this.sourceResolver);
        }
    }

    public String getParameter(String name) {
        return null;
    }

    public long getParameterAsLong(String name) {
        return 0L;
    }

    public Iterator getParameterNames() {
        return Collections.EMPTY_LIST.iterator();
    }
}

