/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.Map;
import org.apache.cocoon.util.SourceCache;
import org.apache.cocoon.util.SourceReloader;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;

public class SoftSourceCache
implements SourceCache {
    Map objectCache = null;
    SourceReloader reloader = null;

    private synchronized void init() {
        if (this.objectCache == null) {
            this.objectCache = Collections.synchronizedMap(new ReferenceMap(1, 1));
        }
    }

    public void register(SourceReloader reloader) {
        this.reloader = reloader;
    }

    public Object getObject(SourceResolver resolver, Object key, String uri, Object parameter) throws MalformedURLException, IOException {
        CacheEntry cacheEntry;
        Object result = null;
        if (this.objectCache == null) {
            this.init();
        }
        if ((cacheEntry = (CacheEntry)this.objectCache.get(key)) != null) {
            SourceValidity previous = cacheEntry.validity;
            Source source = null;
            switch (previous.isValid()) {
                case 1: {
                    result = cacheEntry.object;
                    break;
                }
                case 0: {
                    source = resolver.resolveURI(uri);
                    SourceValidity fresh = source.getValidity();
                    switch (previous.isValid(fresh)) {
                        case 1: {
                            result = cacheEntry.object;
                            break;
                        }
                        case -1: 
                        case 0: {
                            result = this.reloader.reload(source, parameter);
                            this.objectCache.put(key, new CacheEntry(fresh, result));
                        }
                    }
                    resolver.release(source);
                    break;
                }
                case -1: {
                    source = resolver.resolveURI(uri);
                    result = this.reloader.reload(source, parameter);
                    this.objectCache.put(uri, new CacheEntry(source.getValidity(), result));
                    resolver.release(source);
                }
            }
        }
        return result;
    }

    private class CacheEntry {
        public SourceValidity validity = null;
        public Object object = null;

        public CacheEntry(SourceValidity val, Object obj) {
            this.validity = val;
            this.object = obj;
        }
    }
}

