/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.store;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.excalibur.store.Store;
import org.apache.excalibur.store.StoreJanitor;

public class EHStore
extends AbstractLogEnabled
implements Store,
Parameterizable,
Initializable,
Disposable,
ThreadSafe,
Serviceable {
    private Cache cache;
    private CacheManager cacheManager;
    private String cacheName;
    private int maximumSize;
    private boolean overflowToDisk;
    private String configFile;
    private ServiceManager manager;
    private StoreJanitor storeJanitor;

    public void service(ServiceManager aManager) throws ServiceException {
        this.manager = aManager;
        this.storeJanitor = (StoreJanitor)this.manager.lookup(StoreJanitor.ROLE);
    }

    public void parameterize(Parameters parameters) throws ParameterException {
        this.cacheName = parameters.getParameter("cache-name", "main");
        this.maximumSize = parameters.getParameterAsInteger("maxobjects", 10000);
        this.overflowToDisk = parameters.getParameterAsBoolean("overflow-to-disk", true);
        this.configFile = parameters.getParameter("config-file", "org/apache/cocoon/components/store/ehcache-defaults.xml");
    }

    public void initialize() throws Exception {
        URL configFileURL = Thread.currentThread().getContextClassLoader().getResource(this.configFile);
        this.cacheManager = CacheManager.create((URL)configFileURL);
        this.cache = new Cache(this.cacheName, this.maximumSize, this.overflowToDisk, true, 0L, 0L);
        this.cacheManager.addCache(this.cache);
        this.storeJanitor.register((Store)this);
    }

    public void dispose() {
        if (this.storeJanitor != null) {
            this.storeJanitor.unregister((Store)this);
            this.manager.release((Object)this.storeJanitor);
            this.storeJanitor = null;
        }
        this.manager = null;
        this.cacheManager.shutdown();
        this.cacheManager = null;
        this.cache = null;
    }

    public Object get(Object key) {
        Serializable value = null;
        try {
            Element element = this.cache.get((Serializable)key);
            if (element != null) {
                value = element.getValue();
            }
        }
        catch (CacheException e) {
            this.getLogger().error("Failure retrieving object from store", (Throwable)e);
        }
        if (this.getLogger().isDebugEnabled()) {
            if (value != null) {
                this.getLogger().debug("Found key: " + key);
            } else {
                this.getLogger().debug("NOT Found key: " + key);
            }
        }
        return value;
    }

    public void store(Object key, Object value) throws IOException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Store object " + value + " with key " + key);
        }
        Element element = new Element((Serializable)key, (Serializable)value);
        this.cache.put(element);
    }

    public void free() {
    }

    public void remove(Object key) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Removing item " + key);
        }
        this.cache.remove((Serializable)key);
    }

    public void clear() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Clearing the store");
        }
        try {
            this.cache.removeAll();
        }
        catch (IOException e) {
            this.getLogger().error("Failure to clearing store", (Throwable)e);
        }
    }

    public boolean containsKey(Object key) {
        try {
            return this.cache.get((Serializable)key) != null;
        }
        catch (CacheException e) {
            this.getLogger().error("Failure retrieving object from store", (Throwable)e);
            return false;
        }
    }

    public Enumeration keys() {
        return Collections.enumeration(this.cache.getKeys());
    }

    public int size() {
        return this.cache.getSize();
    }
}

