/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.search.LuceneCocoonHelper;
import org.apache.cocoon.components.search.LuceneCocoonPager;
import org.apache.cocoon.components.search.LuceneCocoonSearcher;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.search.Hits;
import org.apache.lucene.store.Directory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SearchGenerator
extends ServiceableGenerator
implements Contextualizable,
Initializable,
Disposable {
    protected static final String NAMESPACE = "http://apache.org/cocoon/search/1.0";
    protected static final String PREFIX = "search";
    protected static final String XLINK_NAMESPACE = "http://www.w3.org/1999/xlink";
    protected static final String CDATA = "CDATA";
    protected static final String RESULTS_ELEMENT = "results";
    protected static final String Q_RESULTS_ELEMENT = "search:results";
    protected static final String DATE_ATTRIBUTE = "date";
    protected static final String QUERY_STRING_ATTRIBUTE = "query-string";
    protected static final String START_INDEX_ATTRIBUTE = "start-index";
    protected static final String PAGE_LENGTH_ATTRIBUTE = "page-length";
    protected static final String NAME_ATTRIBUTE = "name";
    protected static final String HITS_ELEMENT = "hits";
    protected static final String Q_HITS_ELEMENT = "search:hits";
    protected static final String TOTAL_COUNT_ATTRIBUTE = "total-count";
    protected static final String COUNT_OF_PAGES_ATTRIBUTE = "count-of-pages";
    protected static final String HIT_ELEMENT = "hit";
    protected static final String Q_HIT_ELEMENT = "search:hit";
    protected static final String RANK_ATTRIBUTE = "rank";
    protected static final String SCORE_ATTRIBUTE = "score";
    protected static final String URI_ATTRIBUTE = "uri";
    protected static final String FIELD_ELEMENT = "field";
    protected static final String Q_FIELD_ELEMENT = "search:field";
    protected static final String NAVIGATION_ELEMENT = "navigation";
    protected static final String Q_NAVIGATION_ELEMENT = "search:navigation";
    protected static final String NAVIGATION_PAGE_ELEMENT = "navigation-page";
    protected static final String Q_NAVIGATION_PAGE_ELEMENT = "search:navigation-page";
    protected static final String HAS_NEXT_ATTRIBUTE = "has-next";
    protected static final String HAS_PREVIOUS_ATTRIBUTE = "has-previous";
    protected static final String NEXT_INDEX_ATTRIBUTE = "next-index";
    protected static final String PREVIOUS_INDEX_ATTRIBUTE = "previous-index";
    protected static final String INDEX_PARAM = "index";
    protected static final String INDEX_PARAM_DEFAULT = "index";
    protected static final String QUERY_PARAM = "query";
    protected static final String QUERY_STRING_PARAM = "query-string";
    protected static final String QUERY_STRING_PARAM_DEFAULT = "queryString";
    protected static final String START_INDEX_PARAM = "start-index";
    protected static final String START_INDEX_PARAM_DEFAULT = "startIndex";
    protected static final String START_INDEX_NEXT_PARAM = "start-next-index";
    protected static final String START_INDEX_NEXT_PARAM_DEFAULT = "startNextIndex";
    protected static final String START_INDEX_PREVIOUS_PARAM = "start-previous-index";
    protected static final String START_INDEX_PREVIOUS_PARAM_DEFAULT = "startPreviousIndex";
    protected static final int START_INDEX_DEFAULT = 0;
    protected static final String PAGE_LENGTH_PARAM = "page-length";
    protected static final String PAGE_LENGTH_PARAM_DEFAULT = "pageLength";
    protected static final int PAGE_LENGTH_DEFAULT = 10;
    private File workDir = null;
    private LuceneCocoonSearcher lcs;
    private File index = null;
    private String queryString = "";
    private final AttributesImpl atts = new AttributesImpl();
    private Integer startIndex = null;
    private Integer pageLength = null;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        String param_name;
        super.setup(resolver, objectModel, src, par);
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String index_file_name = par.getParameter("index", "index");
        if (request.getParameter("index") != null) {
            index_file_name = request.getParameter("index");
        }
        this.index = new File(index_file_name);
        if (!this.index.isAbsolute()) {
            this.index = new File(this.workDir, this.index.toString());
        }
        this.queryString = par.getParameter(QUERY_PARAM, "");
        if (this.queryString.equals("") && request.getParameter(param_name = par.getParameter("query-string", QUERY_STRING_PARAM_DEFAULT)) != null) {
            this.queryString = request.getParameter(param_name);
        }
        this.startIndex = null;
        param_name = par.getParameter(START_INDEX_NEXT_PARAM, START_INDEX_NEXT_PARAM_DEFAULT);
        if (request.getParameter(param_name) != null) {
            this.startIndex = this.createInteger(request.getParameter(param_name));
        }
        if (this.startIndex == null && request.getParameter(param_name = par.getParameter(START_INDEX_PREVIOUS_PARAM, START_INDEX_PREVIOUS_PARAM_DEFAULT)) != null) {
            this.startIndex = this.createInteger(request.getParameter(param_name));
        }
        if (this.startIndex == null && request.getParameter(param_name = par.getParameter("start-index", START_INDEX_PARAM_DEFAULT)) != null) {
            this.startIndex = this.createInteger(request.getParameter(param_name));
        }
        if (request.getParameter(param_name = par.getParameter("page-length", PAGE_LENGTH_PARAM_DEFAULT)) != null) {
            this.pageLength = this.createInteger(request.getParameter(param_name));
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.workDir = (File)context.get((Object)"work-directory");
    }

    public void initialize() throws IOException {
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        if (this.startIndex == null) {
            this.startIndex = new Integer(0);
        }
        if (this.pageLength == null) {
            this.pageLength = new Integer(10);
        }
        this.contentHandler.startDocument();
        this.contentHandler.startPrefixMapping(PREFIX, NAMESPACE);
        this.contentHandler.startPrefixMapping("xlink", XLINK_NAMESPACE);
        this.generateResults();
        this.contentHandler.endPrefixMapping("xlink");
        this.contentHandler.endPrefixMapping(PREFIX);
        this.contentHandler.endDocument();
    }

    private Integer createInteger(String s) {
        Integer i;
        block2: {
            i = null;
            try {
                i = new Integer(s);
            }
            catch (NumberFormatException nfe) {
                if (!this.getLogger().isWarnEnabled()) break block2;
                this.getLogger().warn("Cannot convert " + s + " to Integer", (Throwable)nfe);
            }
        }
        return i;
    }

    private void generateResults() throws SAXException, ProcessingException {
        LuceneCocoonPager pager = this.buildHits();
        long time = System.currentTimeMillis();
        this.atts.clear();
        this.atts.addAttribute("", DATE_ATTRIBUTE, DATE_ATTRIBUTE, CDATA, String.valueOf(time));
        if (this.queryString != null && this.queryString.length() > 0) {
            this.atts.addAttribute("", "query-string", "query-string", CDATA, String.valueOf(this.queryString));
        }
        this.atts.addAttribute("", "start-index", "start-index", CDATA, String.valueOf(this.startIndex));
        this.atts.addAttribute("", "page-length", "page-length", CDATA, String.valueOf(this.pageLength));
        this.contentHandler.startElement(NAMESPACE, RESULTS_ELEMENT, Q_RESULTS_ELEMENT, this.atts);
        this.generateHits(pager);
        this.generateNavigation(pager);
        this.contentHandler.endElement(NAMESPACE, RESULTS_ELEMENT, Q_RESULTS_ELEMENT);
    }

    private void generateHits(LuceneCocoonPager pager) throws SAXException {
        if (pager != null && pager.hasNext()) {
            this.atts.clear();
            this.atts.addAttribute("", TOTAL_COUNT_ATTRIBUTE, TOTAL_COUNT_ATTRIBUTE, CDATA, String.valueOf(pager.getCountOfHits()));
            this.atts.addAttribute("", COUNT_OF_PAGES_ATTRIBUTE, COUNT_OF_PAGES_ATTRIBUTE, CDATA, String.valueOf(pager.getCountOfPages()));
            this.contentHandler.startElement(NAMESPACE, HITS_ELEMENT, Q_HITS_ELEMENT, this.atts);
            this.generateHit(pager);
            this.contentHandler.endElement(NAMESPACE, HITS_ELEMENT, Q_HITS_ELEMENT);
        }
    }

    private void generateHit(LuceneCocoonPager pager) throws SAXException {
        int counter = pager.getStartIndex();
        List l = (List)pager.next();
        Iterator i = l.iterator();
        while (i.hasNext()) {
            LuceneCocoonPager.HitWrapper hw = (LuceneCocoonPager.HitWrapper)i.next();
            Document doc = hw.getDocument();
            float score = hw.getScore();
            String uri = doc.get("url");
            this.atts.clear();
            this.atts.addAttribute("", RANK_ATTRIBUTE, RANK_ATTRIBUTE, CDATA, String.valueOf(counter));
            this.atts.addAttribute("", SCORE_ATTRIBUTE, SCORE_ATTRIBUTE, CDATA, String.valueOf(score));
            this.atts.addAttribute("", URI_ATTRIBUTE, URI_ATTRIBUTE, CDATA, String.valueOf(uri));
            this.contentHandler.startElement(NAMESPACE, HIT_ELEMENT, Q_HIT_ELEMENT, this.atts);
            Enumeration e = doc.fields();
            while (e.hasMoreElements()) {
                Field field = (Field)e.nextElement();
                if (!field.isStored() || "url".equals(field.name())) continue;
                this.atts.clear();
                this.atts.addAttribute("", NAME_ATTRIBUTE, NAME_ATTRIBUTE, CDATA, field.name());
                this.contentHandler.startElement(NAMESPACE, FIELD_ELEMENT, Q_FIELD_ELEMENT, this.atts);
                String value = field.stringValue();
                this.contentHandler.characters(value.toCharArray(), 0, value.length());
                this.contentHandler.endElement(NAMESPACE, FIELD_ELEMENT, Q_FIELD_ELEMENT);
            }
            this.contentHandler.endElement(NAMESPACE, HIT_ELEMENT, Q_HIT_ELEMENT);
            ++counter;
        }
    }

    private void generateNavigation(LuceneCocoonPager pager) throws SAXException {
        if (pager != null) {
            this.atts.clear();
            this.atts.addAttribute("", TOTAL_COUNT_ATTRIBUTE, TOTAL_COUNT_ATTRIBUTE, CDATA, String.valueOf(pager.getCountOfHits()));
            this.atts.addAttribute("", COUNT_OF_PAGES_ATTRIBUTE, COUNT_OF_PAGES_ATTRIBUTE, CDATA, String.valueOf(pager.getCountOfPages()));
            this.atts.addAttribute("", HAS_NEXT_ATTRIBUTE, HAS_NEXT_ATTRIBUTE, CDATA, String.valueOf(pager.hasNext()));
            this.atts.addAttribute("", HAS_PREVIOUS_ATTRIBUTE, HAS_PREVIOUS_ATTRIBUTE, CDATA, String.valueOf(pager.hasPrevious()));
            this.atts.addAttribute("", NEXT_INDEX_ATTRIBUTE, NEXT_INDEX_ATTRIBUTE, CDATA, String.valueOf(pager.nextIndex()));
            this.atts.addAttribute("", PREVIOUS_INDEX_ATTRIBUTE, PREVIOUS_INDEX_ATTRIBUTE, CDATA, String.valueOf(pager.previousIndex()));
            this.contentHandler.startElement(NAMESPACE, NAVIGATION_ELEMENT, Q_NAVIGATION_ELEMENT, this.atts);
            int count_of_pages = pager.getCountOfPages();
            int i = 0;
            int page_start_index = 0;
            while (i < count_of_pages) {
                this.atts.clear();
                this.atts.addAttribute("", "start-index", "start-index", CDATA, String.valueOf(page_start_index));
                this.contentHandler.startElement(NAMESPACE, NAVIGATION_PAGE_ELEMENT, Q_NAVIGATION_PAGE_ELEMENT, this.atts);
                this.contentHandler.endElement(NAMESPACE, NAVIGATION_PAGE_ELEMENT, Q_NAVIGATION_PAGE_ELEMENT);
                ++i;
                page_start_index += this.pageLength.intValue();
            }
            this.contentHandler.endElement(NAMESPACE, NAVIGATION_ELEMENT, Q_NAVIGATION_ELEMENT);
        }
    }

    private LuceneCocoonPager buildHits() throws ProcessingException {
        if (this.queryString != null && this.queryString.length() != 0) {
            Hits hits = null;
            try {
                this.lcs = (LuceneCocoonSearcher)this.manager.lookup("org.apache.cocoon.components.search.LuceneCocoonSearcher");
                Analyzer analyzer = LuceneCocoonHelper.getAnalyzer("org.apache.lucene.analysis.standard.StandardAnalyzer");
                this.lcs.setAnalyzer(analyzer);
                Directory directory = LuceneCocoonHelper.getDirectory(this.index, false);
                this.lcs.setDirectory(directory);
                hits = this.lcs.search(this.queryString, "body");
            }
            catch (IOException ioe) {
                throw new ProcessingException("IOException in search", (Throwable)ioe);
            }
            catch (ServiceException ce) {
                throw new ProcessingException("ComponentException in search", (Throwable)ce);
            }
            finally {
                if (this.lcs != null) {
                    this.manager.release((Object)this.lcs);
                    this.lcs = null;
                }
            }
            LuceneCocoonPager pager = new LuceneCocoonPager(hits);
            int start_index = 0;
            if (this.startIndex != null) {
                start_index = this.startIndex;
                if (start_index <= 0) {
                    start_index = 0;
                }
                pager.setStartIndex(start_index);
            }
            int page_length = 10;
            if (this.pageLength != null) {
                page_length = this.pageLength;
                if (page_length <= 0) {
                    page_length = hits.length();
                }
                pager.setCountOfHitsPerPage(page_length);
            }
            return pager;
        }
        return null;
    }

    public void recycle() {
        super.recycle();
        this.queryString = null;
        this.startIndex = null;
        this.pageLength = null;
        this.index = null;
    }

    public void dispose() {
        super.dispose();
    }
}

