/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.search;

import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.crawler.CocoonCrawler;
import org.apache.cocoon.components.search.LuceneCocoonIndexer;
import org.apache.cocoon.components.search.LuceneXMLIndexer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.store.Directory;

public class SimpleLuceneCocoonIndexerImpl
extends AbstractLogEnabled
implements LuceneCocoonIndexer,
Configurable,
Serviceable,
Disposable {
    public static final String ANALYZER_CLASSNAME_CONFIG = "analyzer-classname";
    public static final String ANALYZER_CLASSNAME_DEFAULT = "org.apache.lucene.analysis.standard.StandardAnalyzer";
    public static final String DIRECTORY_CONFIG = "directory";
    public static final String DIRECTORY_DEFAULT = null;
    public static final String MERGE_FACTOR_CONFIG = "merge-factor";
    public static final int MERGE_FACTOR_DEFAULT = 10;
    protected ServiceManager manager = null;
    protected Analyzer analyzer;
    private int mergeFactor = 10;

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public void configure(Configuration conf) throws ConfigurationException {
        Configuration child = conf.getChild(MERGE_FACTOR_CONFIG, false);
        if (child != null) {
            int int_value;
            this.mergeFactor = int_value = child.getValueAsInteger(10);
        }
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public void dispose() {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void index(Directory index, boolean create, URL base_url) throws ProcessingException {
        CocoonCrawler cocoonCrawler;
        LuceneXMLIndexer lxi;
        IndexWriter writer;
        block17: {
            writer = null;
            lxi = null;
            cocoonCrawler = null;
            lxi = (LuceneXMLIndexer)this.manager.lookup("org.apache.cocoon.components.search.LuceneXMLIndexer");
            writer = new IndexWriter(index, this.analyzer, create);
            writer.mergeFactor = this.mergeFactor;
            cocoonCrawler = (CocoonCrawler)this.manager.lookup(CocoonCrawler.ROLE);
            cocoonCrawler.crawl(base_url);
            Iterator cocoonCrawlerIterator = cocoonCrawler.iterator();
            while (cocoonCrawlerIterator.hasNext()) {
                URL crawl_url = (URL)cocoonCrawlerIterator.next();
                if (crawl_url == null) continue;
                if (!crawl_url.getHost().equals(base_url.getHost()) || crawl_url.getPort() != base_url.getPort()) {
                    if (!this.getLogger().isDebugEnabled()) continue;
                    this.getLogger().debug("Skipping crawling URL " + crawl_url.toString() + " as base_url is " + base_url.toString());
                    continue;
                }
                Iterator i = lxi.build(crawl_url).iterator();
                while (i.hasNext()) {
                    writer.addDocument((Document)i.next());
                }
            }
            writer.optimize();
            if (writer == null) break block17;
            try {
                writer.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            writer = null;
        }
        if (lxi != null) {
            this.manager.release((Object)lxi);
            lxi = null;
        }
        if (cocoonCrawler == null) return;
        this.manager.release((Object)cocoonCrawler);
        return;
        catch (IOException ioe) {
            try {
                throw new ProcessingException("IOException in index()", (Throwable)ioe);
                catch (ServiceException se) {
                    throw new ProcessingException("Could not lookup service in index()", (Throwable)se);
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException ioe2) {
                        // empty catch block
                    }
                    writer = null;
                }
                if (lxi != null) {
                    this.manager.release((Object)lxi);
                    lxi = null;
                }
                if (cocoonCrawler == null) throw throwable;
                this.manager.release(cocoonCrawler);
                cocoonCrawler = null;
                throw throwable;
            }
        }
    }

    static class DocumentDeletableIterator {
        private IndexReader reader;
        private TermEnum uidIter;

        public DocumentDeletableIterator(Directory directory) throws IOException {
            this.reader = IndexReader.open((Directory)directory);
            this.uidIter = this.reader.terms(new Term("uid", ""));
        }

        public void deleteAllStaleDocuments() throws IOException {
            while (this.uidIter.term() != null && this.uidIter.term().field() == "uid") {
                this.reader.delete(this.uidIter.term());
                this.uidIter.next();
            }
        }

        public void deleteModifiedDocuments(String uid) throws IOException {
            while (this.documentHasBeenModified(this.uidIter.term(), uid)) {
                this.reader.delete(this.uidIter.term());
                this.uidIter.next();
            }
            if (this.documentHasNotBeenModified(this.uidIter.term(), uid)) {
                this.uidIter.next();
            }
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (this.uidIter != null) {
                this.uidIter.close();
                this.uidIter = null;
            }
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }

        boolean documentIsDeletable(Term term) {
            return term != null && term.field() == "uid";
        }

        boolean documentHasBeenModified(Term term, String uid) {
            return this.documentIsDeletable(term) && term.text().compareTo(uid) < 0;
        }

        boolean documentHasNotBeenModified(Term term, String uid) {
            return this.documentIsDeletable(term) && term.text().compareTo(uid) == 0;
        }
    }
}

