/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.xscript;

import java.util.Map;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.xscript.XScriptManager;
import org.apache.cocoon.components.xscript.XScriptObject;
import org.apache.cocoon.components.xscript.XScriptObjectFromURL;
import org.apache.cocoon.components.xscript.XScriptVariableScope;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;

public class XScriptManagerImpl
extends AbstractLogEnabled
implements XScriptManager,
Serviceable,
Component,
Parameterizable,
Contextualizable,
ThreadSafe {
    public static final String CONTEXT = "org.apache.cocoon.components.xscript.scope";
    protected ServiceManager manager = null;
    protected Context context = null;

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this.context = (Context)context.get((Object)"environment-context");
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public void register(XScriptObject object) {
        try {
            object.service(this.manager);
        }
        catch (ServiceException ignored) {}
    }

    public void parameterize(Parameters params) throws ParameterException {
        String[] names = params.getNames();
        XScriptVariableScope s = new XScriptVariableScope();
        this.context.setAttribute(CONTEXT, (Object)s);
        int i = 0;
        while (i < names.length) {
            String resourceString = params.getParameter(names[i]);
            XScriptObjectFromURL resource = new XScriptObjectFromURL(this, resourceString);
            s.put(names[i], resource);
            ++i;
        }
    }

    private IllegalArgumentException createAccessException(String msg, String name, int scope) {
        StringBuffer message = new StringBuffer("Cannot ").append(msg).append(" variable named '").append(name).append("' in ");
        if (scope == 1) {
            message.append("global scope");
        } else if (scope == 2) {
            message.append("session scope");
        } else if (scope == 3) {
            message.append("page scope");
        } else if (scope == 5) {
            message.append("request scope");
        } else if (scope == 4) {
            message.append("any scope");
        } else {
            message.append("unknown scope (").append(scope).append(")");
        }
        return new IllegalArgumentException(message.toString());
    }

    public XScriptObject get(XScriptVariableScope pageScope, Map objectModel, String name, int scope) throws IllegalArgumentException {
        XScriptObject o;
        XScriptVariableScope s = null;
        if (scope == 1) {
            s = (XScriptVariableScope)ObjectModelHelper.getContext((Map)objectModel).getAttribute(CONTEXT);
        } else if (scope == 2) {
            Request request = ObjectModelHelper.getRequest((Map)objectModel);
            s = (XScriptVariableScope)request.getSession().getAttribute(CONTEXT);
        } else if (scope == 5) {
            Request request = ObjectModelHelper.getRequest((Map)objectModel);
            s = (XScriptVariableScope)request.getAttribute(CONTEXT);
        } else if (scope == 3) {
            s = pageScope;
        } else if (scope == 4) {
            Request request = ObjectModelHelper.getRequest((Map)objectModel);
            s = (XScriptVariableScope)request.getAttribute(CONTEXT);
            if (s != null && (o = s.get(name)) != null) {
                return o;
            }
            s = (XScriptVariableScope)request.getSession().getAttribute(CONTEXT);
            if (s != null && (o = s.get(name)) != null) {
                return o;
            }
            o = pageScope.get(name);
            if (o != null) {
                return o;
            }
            s = (XScriptVariableScope)ObjectModelHelper.getContext((Map)objectModel).getAttribute(CONTEXT);
            if (s != null && (o = s.get(name)) != null) {
                return o;
            }
            s = null;
        }
        if (s != null && (o = s.get(name)) != null) {
            return o;
        }
        throw this.createAccessException("find", name, scope);
    }

    public XScriptObject getFirst(XScriptVariableScope pageScope, Map objectModel, String name) throws IllegalArgumentException {
        return this.get(pageScope, objectModel, name, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(XScriptVariableScope pageScope, Map objectModel, String name, XScriptObject value, int scope) {
        XScriptVariableScope s;
        if (scope == 1) {
            Context context;
            Context context2 = context = ObjectModelHelper.getContext((Map)objectModel);
            synchronized (context2) {
                s = (XScriptVariableScope)context.getAttribute(CONTEXT);
                if (s == null) {
                    s = new XScriptVariableScope();
                    context.setAttribute(CONTEXT, (Object)s);
                }
            }
        } else if (scope == 2) {
            Session session;
            Session session2 = session = ObjectModelHelper.getRequest((Map)objectModel).getSession();
            synchronized (session2) {
                s = (XScriptVariableScope)session.getAttribute(CONTEXT);
                if (s == null) {
                    s = new XScriptVariableScope();
                    session.setAttribute(CONTEXT, (Object)s);
                }
            }
        } else if (scope == 5) {
            Request request;
            Request request2 = request = ObjectModelHelper.getRequest((Map)objectModel);
            synchronized (request2) {
                s = (XScriptVariableScope)request.getAttribute(CONTEXT);
                if (s == null) {
                    s = new XScriptVariableScope();
                    request.setAttribute(CONTEXT, (Object)s);
                }
            }
        } else if (scope == 3) {
            s = pageScope;
        } else {
            throw this.createAccessException("create", name, scope);
        }
        s.put(name, value);
    }

    public XScriptObject remove(XScriptVariableScope pageScope, Map objectModel, String name, int scope) throws IllegalArgumentException {
        XScriptObject o;
        XScriptVariableScope s = null;
        if (scope == 1) {
            s = (XScriptVariableScope)ObjectModelHelper.getContext((Map)objectModel).getAttribute(CONTEXT);
        } else if (scope == 2) {
            Request request = ObjectModelHelper.getRequest((Map)objectModel);
            s = (XScriptVariableScope)request.getSession().getAttribute(CONTEXT);
        } else if (scope == 5) {
            Request request = ObjectModelHelper.getRequest((Map)objectModel);
            s = (XScriptVariableScope)request.getAttribute(CONTEXT);
        } else if (scope == 3) {
            s = pageScope;
        } else if (scope == 4) {
            Request request = ObjectModelHelper.getRequest((Map)objectModel);
            s = (XScriptVariableScope)request.getAttribute(CONTEXT);
            if (s != null && (o = s.remove(name)) != null) {
                return o;
            }
            s = (XScriptVariableScope)request.getSession().getAttribute(CONTEXT);
            if (s != null && (o = s.remove(name)) != null) {
                return o;
            }
            o = pageScope.remove(name);
            if (o != null) {
                return o;
            }
            s = (XScriptVariableScope)ObjectModelHelper.getContext((Map)objectModel).getAttribute(CONTEXT);
            if (s != null && (o = s.remove(name)) != null) {
                return o;
            }
            s = null;
        }
        if (s != null && (o = s.remove(name)) != null) {
            return o;
        }
        throw this.createAccessException("remove", name, scope);
    }

    public XScriptObject removeFirst(XScriptVariableScope pageScope, Map objectModel, String name) throws IllegalArgumentException {
        return this.remove(pageScope, objectModel, name, 4);
    }
}

