/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.programming;

import java.io.File;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.components.language.LanguageException;
import org.apache.cocoon.components.language.programming.AbstractProgrammingLanguage;
import org.apache.cocoon.components.language.programming.Program;
import org.apache.cocoon.components.language.programming.java.JavaProgram;
import org.apache.cocoon.util.ClassUtils;
import org.apache.cocoon.util.IOUtils;

public abstract class CompiledProgrammingLanguage
extends AbstractProgrammingLanguage
implements Contextualizable {
    protected Class compilerClass;
    protected String classpath;
    protected boolean deleteSources = false;

    public void parameterize(Parameters params) throws ParameterException {
        super.parameterize(params);
        String compilerClass = params.getParameter("compiler");
        try {
            this.compilerClass = ClassUtils.loadClass((String)compilerClass);
        }
        catch (ClassNotFoundException e) {
            throw new ParameterException("Unable to load compiler: " + compilerClass, (Throwable)e);
        }
        this.deleteSources = params.getParameterAsBoolean("delete-sources", false);
    }

    public void contextualize(Context context) throws ContextException {
        this.classpath = (String)context.get((Object)"classpath");
    }

    public abstract String getObjectExtension();

    public abstract void doUnload(Object var1) throws LanguageException;

    protected final void doUnload(Object program, String filename, File baseDirectory) throws LanguageException {
        int index = filename.lastIndexOf(File.separator);
        String dir = filename.substring(0, index);
        String file = filename.substring(index + 1);
        File baseDir = new File(baseDirectory, dir);
        File[] files = baseDir.listFiles();
        int i = 0;
        while (files != null && i < files.length) {
            if (files[i].getName().startsWith(file)) {
                files[i].delete();
            }
            ++i;
        }
        this.doUnload(program);
    }

    protected abstract Class loadProgram(String var1, File var2) throws LanguageException;

    protected abstract void compile(String var1, File var2, String var3) throws LanguageException;

    public Program preload(String filename, File baseDirectory, String encoding) throws LanguageException {
        try {
            Class program = this.loadProgram(filename, baseDirectory);
            program.newInstance();
            return new JavaProgram(program);
        }
        catch (Throwable t) {
            throw new LanguageException("Unable to preload program " + filename, t);
        }
    }

    public Program load(String filename, File baseDirectory, String encoding) throws LanguageException {
        File sourceFile = new File(baseDirectory, filename + "." + this.getSourceExtension());
        if (!sourceFile.exists()) {
            throw new LanguageException("Can't load program - File doesn't exist: " + IOUtils.getFullFilename((File)sourceFile));
        }
        if (!sourceFile.isFile()) {
            throw new LanguageException("Can't load program - File is not a normal file: " + IOUtils.getFullFilename((File)sourceFile));
        }
        if (!sourceFile.canRead()) {
            throw new LanguageException("Can't load program - File cannot be read: " + IOUtils.getFullFilename((File)sourceFile));
        }
        this.compile(filename, baseDirectory, encoding);
        if (this.deleteSources) {
            sourceFile.delete();
        }
        Class program = this.loadProgram(filename, baseDirectory);
        try {
            program.newInstance();
        }
        catch (IllegalAccessException iae) {
            this.getLogger().debug("No public constructor for class " + program.getName());
        }
        catch (Exception e) {
            this.doUnload(program);
            new File(baseDirectory, filename + "." + this.getObjectExtension()).delete();
            String message = "Error while instantiating " + filename;
            this.getLogger().debug(message, (Throwable)e);
            throw new LanguageException(message, e);
        }
        if (program == null) {
            throw new LanguageException("Can't load program : " + baseDirectory.toString() + File.separator + filename);
        }
        return new JavaProgram(program);
    }
}

