/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.webapps.authentication.user;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.webapps.authentication.configuration.ApplicationConfiguration;
import org.apache.cocoon.webapps.authentication.configuration.HandlerConfiguration;
import org.apache.cocoon.webapps.authentication.context.AuthenticationContext;

public final class UserHandler
implements Serializable {
    private HandlerConfiguration handler;
    private boolean appsLoaded = false;
    private AuthenticationContext context;
    private List loadedApps = new ArrayList(3);
    private List applicationContexts;
    private String userID;

    public UserHandler(HandlerConfiguration handler, AuthenticationContext context) {
        this.context = context;
        this.handler = handler;
        this.context.init(this);
    }

    public boolean getApplicationsLoaded() {
        if (this.handler.getApplications().isEmpty()) {
            return true;
        }
        return this.appsLoaded;
    }

    public AuthenticationContext getContext() {
        return this.context;
    }

    public String getHandlerName() {
        return this.handler.getName();
    }

    public HandlerConfiguration getHandlerConfiguration() {
        return this.handler;
    }

    public boolean isApplicationLoaded(ApplicationConfiguration appConf) {
        return this.loadedApps.contains(appConf);
    }

    public void setApplicationIsLoaded(ApplicationConfiguration appConf) {
        this.loadedApps.add(appConf);
        this.appsLoaded = this.loadedApps.size() == this.handler.getApplications().size();
    }

    public String getUserId() {
        block2: {
            if (null != this.userID) break block2;
            try {
                this.userID = (String)this.context.getContextInfo().get("ID");
            }
            catch (ProcessingException ignore) {
                this.userID = "";
            }
        }
        return this.userID;
    }

    public void addApplicationContext(String name) {
        if (this.applicationContexts == null) {
            this.applicationContexts = new ArrayList(3);
        }
        this.applicationContexts.add(name);
    }

    public List getApplicationContexts() {
        return this.applicationContexts;
    }
}

