/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.webapps.authentication.components;

import java.io.IOException;
import java.util.Properties;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.webapps.authentication.components.Authenticator;
import org.apache.cocoon.webapps.authentication.configuration.HandlerConfiguration;
import org.apache.cocoon.webapps.authentication.user.UserHandler;
import org.apache.cocoon.webapps.session.MediaManager;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.cocoon.xml.dom.DOMUtil;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceParameters;
import org.apache.excalibur.source.SourceResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class PipelineAuthenticator
extends AbstractLogEnabled
implements Serviceable,
ThreadSafe,
Disposable,
Authenticator {
    protected ServiceManager manager;
    protected SourceResolver resolver;

    private boolean isValidAuthenticationFragment(Document authenticationFragment) throws ProcessingException {
        Node child;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN isValidAuthenticationFragment fragment=" + XMLUtils.serializeNode((Node)authenticationFragment, (Properties)XMLUtils.createPropertiesForXML((boolean)false)));
        }
        boolean isValid = false;
        if (authenticationFragment.hasChildNodes() && authenticationFragment.getChildNodes().getLength() == 1 && (child = authenticationFragment.getFirstChild()).getNodeType() == 1 && child.getNodeName().equals("authentication") && child.hasChildNodes()) {
            NodeList children = child.getChildNodes();
            boolean found = false;
            int i = 0;
            int l = children.getLength();
            while (!found && i < l) {
                child = children.item(i);
                if (child.getNodeType() == 1 && child.getNodeName().equals("ID")) {
                    found = true;
                    continue;
                }
                ++i;
            }
            if (found) {
                String value;
                child.normalize();
                if (child.hasChildNodes() && child.getChildNodes().getLength() == 1 && child.getChildNodes().item(0).getNodeType() == 3 && (value = child.getChildNodes().item(0).getNodeValue().trim()).length() > 0) {
                    isValid = true;
                }
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END isValidAuthenticationFragment valid=" + isValid);
        }
        return isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Authenticator.AuthenticationResult authenticate(HandlerConfiguration configuration, SourceParameters parameters) throws ProcessingException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("start authenticator using handler " + configuration.getName());
        }
        String authenticationResourceName = configuration.getAuthenticationResource();
        SourceParameters authenticationParameters = configuration.getAuthenticationResourceParameters();
        if (parameters != null) {
            parameters.add(authenticationParameters);
        } else {
            parameters = authenticationParameters;
        }
        Document doc = null;
        String exceptionMsg = null;
        try {
            Source source = null;
            try {
                try {
                    source = SourceUtil.getSource((String)authenticationResourceName, null, (SourceParameters)parameters, (SourceResolver)this.resolver);
                    doc = SourceUtil.toDOM((Source)source);
                }
                catch (SAXException se) {
                    throw new ProcessingException((Exception)se);
                }
                catch (SourceException se) {
                    throw SourceUtil.handle((SourceException)se);
                }
                catch (IOException e) {
                    throw new ProcessingException((Exception)e);
                }
                Object var12_10 = null;
            }
            catch (Throwable throwable) {
                Object var12_11 = null;
                this.resolver.release(source);
                throw throwable;
            }
            this.resolver.release(source);
        }
        catch (ProcessingException local) {
            this.getLogger().error("authenticator: " + local.getMessage(), (Throwable)local);
            exceptionMsg = local.getMessage();
        }
        boolean isValid = false;
        Authenticator.AuthenticationResult result = null;
        if (doc != null && (isValid = this.isValidAuthenticationFragment(doc))) {
            String mediaType;
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("Authenticator: User authenticated using handler '" + configuration.getName() + "'");
            }
            MediaManager mediaManager = null;
            try {
                try {
                    mediaManager = (MediaManager)this.manager.lookup(MediaManager.ROLE);
                    mediaType = mediaManager.getMediaType();
                }
                catch (ServiceException se) {
                    throw new ProcessingException("Unable to lookup media manager.", (Throwable)se);
                }
                Object var14_21 = null;
            }
            catch (Throwable throwable) {
                Object var14_22 = null;
                this.manager.release((Object)mediaManager);
                throw throwable;
            }
            this.manager.release((Object)mediaManager);
            HandlerConfiguration se = configuration;
            synchronized (se) {
                Element authNode = (Element)doc.getFirstChild();
                Element specialElement = doc.createElementNS(null, "type");
                Text specialValue = doc.createTextNode("cocoon.authentication");
                specialElement.appendChild(specialValue);
                authNode.appendChild(specialElement);
                specialElement = doc.createElementNS(null, "media");
                specialValue = doc.createTextNode(mediaType);
                specialElement.appendChild(specialValue);
                authNode.appendChild(specialElement);
                result = new Authenticator.AuthenticationResult(true, doc);
            }
        }
        if (!isValid) {
            Text text;
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("Authenticator: Failed authentication using handler '" + configuration.getName() + "'");
            }
            Node data = null;
            if (doc != null) {
                data = DOMUtil.getFirstNodeFromPath((Node)doc, (String[])new String[]{"authentication", "data"}, (boolean)false);
            }
            doc = DOMUtil.createDocument();
            Element root = doc.createElementNS(null, "root");
            doc.appendChild(root);
            Element element = doc.createElementNS(null, "failed");
            root.appendChild(element);
            if (exceptionMsg != null) {
                text = doc.createTextNode(exceptionMsg);
                element.appendChild(text);
            }
            if (data == null) {
                element = doc.createElementNS(null, "data");
                root.appendChild(element);
                text = doc.createTextNode("No information available");
                element.appendChild(text);
            } else {
                root.appendChild(doc.importNode(data, true));
            }
            result = new Authenticator.AuthenticationResult(false, doc);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("end authenticator");
        }
        return result;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
        this.resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Object)this.resolver);
            this.manager = null;
            this.resolver = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void logout(UserHandler handler) {
        HandlerConfiguration configuration;
        String logoutResourceName;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logout using handler " + handler.getHandlerName());
        }
        if ((logoutResourceName = (configuration = handler.getHandlerConfiguration()).getLogoutResource()) == null) return;
        SourceParameters parameters = configuration.getAuthenticationResourceParameters();
        Source source = null;
        try {
            try {
                source = SourceUtil.getSource((String)logoutResourceName, null, (SourceParameters)parameters, (SourceResolver)this.resolver);
                SourceUtil.toDOM((Source)source);
            }
            catch (Exception ignore) {
                this.getLogger().error("logout: " + ignore.getMessage(), (Throwable)ignore);
                Object var8_7 = null;
                this.resolver.release(source);
                return;
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.resolver.release(source);
            throw throwable;
        }
        this.resolver.release(source);
    }
}

