/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.caching.impl;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CachedResponse;
import org.apache.cocoon.caching.EventAware;
import org.apache.cocoon.caching.EventRegistry;
import org.apache.cocoon.caching.PipelineCacheKey;
import org.apache.cocoon.caching.impl.CacheImpl;
import org.apache.cocoon.caching.validity.Event;
import org.apache.cocoon.caching.validity.EventValidity;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.AbstractAggregatedValidity;

public class EventAwareCacheImpl
extends CacheImpl
implements Initializable,
EventAware {
    private ServiceManager m_manager;
    private EventRegistry m_eventRegistry;

    public void clear() {
        super.clear();
        this.m_eventRegistry.clear();
    }

    public void store(Serializable key, CachedResponse response) throws ProcessingException {
        SourceValidity[] validities = response.getValidityObjects();
        int i = 0;
        while (i < validities.length) {
            SourceValidity val = validities[i];
            this.examineValidity(val, key);
            ++i;
        }
        super.store(key, response);
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.m_manager = manager;
        super.service(manager);
        this.m_eventRegistry = (EventRegistry)manager.lookup(EventRegistry.ROLE);
    }

    public void remove(PipelineCacheKey key) {
        super.remove((Serializable)key);
        this.m_eventRegistry.removeKey((Serializable)key);
    }

    public void processEvent(Event e) {
        if (e == null) {
            return;
        }
        Serializable[] keys = this.m_eventRegistry.keysForEvent(e);
        if (keys == null) {
            return;
        }
        int i = 0;
        while (i < keys.length) {
            if (keys[i] != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Processing cache event, found Pipeline key: " + keys[i].toString());
                }
                this.remove(keys[i]);
            }
            ++i;
        }
    }

    public void initialize() throws Exception {
        if (!this.m_eventRegistry.wasRecoverySuccessful()) {
            super.clear();
        } else {
            this.veryifyEventCache();
        }
    }

    public void veryifyEventCache() {
        Serializable[] keys = this.m_eventRegistry.allKeys();
        if (keys == null) {
            return;
        }
        int i = 0;
        while (i < keys.length) {
            if (!this.containsKey(keys[i])) {
                this.m_eventRegistry.removeKey(keys[i]);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Cache key no longer valid: " + keys[i]);
                }
            }
            ++i;
        }
    }

    public void dispose() {
        this.m_manager.release((Object)this.m_eventRegistry);
        super.dispose();
        this.m_manager = null;
        this.m_eventRegistry = null;
    }

    private void examineValidity(SourceValidity val, Serializable key) {
        if (val instanceof AbstractAggregatedValidity) {
            this.handleAggregatedValidity((AbstractAggregatedValidity)val, key);
        } else if (val instanceof EventValidity) {
            this.handleEventValidity((EventValidity)val, key);
        }
    }

    private void handleAggregatedValidity(AbstractAggregatedValidity val, Serializable key) {
        Iterator it = val.getValidities().iterator();
        while (it.hasNext()) {
            SourceValidity thisVal = (SourceValidity)it.next();
            this.examineValidity(thisVal, key);
        }
    }

    private void handleEventValidity(EventValidity val, Serializable key) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Found EventValidity: " + val.toString());
        }
        this.m_eventRegistry.register(val.getEvent(), key);
    }
}

