/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements;

import java.io.IOException;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.BaseElementProcessor;
import org.apache.cocoon.components.elementprocessor.types.Attribute;
import org.apache.cocoon.components.elementprocessor.types.BooleanConverter;
import org.apache.cocoon.components.elementprocessor.types.BooleanResult;
import org.apache.cocoon.components.elementprocessor.types.NumericConverter;
import org.apache.cocoon.components.elementprocessor.types.NumericResult;
import org.apache.cocoon.components.elementprocessor.types.Validator;

public class EPRowInfo
extends BaseElementProcessor {
    private NumericResult _no = null;
    private NumericResult _unit = null;
    private NumericResult _margin_a = null;
    private NumericResult _margin_b = null;
    private BooleanResult _hard_size = null;
    private BooleanResult _hidden = null;
    private BooleanResult _collapsed = null;
    private NumericResult _outline_level = null;
    private NumericResult _count = null;
    private static final String _no_attribute = "No";
    private static final String _unit_attribute = "Unit";
    private static final String _margin_a_attribute = "MarginA";
    private static final String _margin_b_attribute = "MarginB";
    private static final String _hard_size_attribute = "HardSize";
    private static final String _hidden_attribute = "Hidden";
    private static final String _collapsed_attribute = "Collapsed";
    private static final String _outline_level_attribute = "OutlineLevel";
    private static final String _count_attribute = "Count";
    private static final Validator _margin_validator = new Validator(){

        public IOException validate(Number number) {
            int val = number.intValue();
            return val >= 0 && val <= 7 ? null : new IOException("\"" + number + "\" is not a legal value");
        }
    };
    private static final Attribute[] _implied_attributes = new Attribute[]{new Attribute("HardSize", "0"), new Attribute("Hidden", "0"), new Attribute("Collapsed", "0"), new Attribute("OutlineLevel", "0"), new Attribute("Count", "1")};

    public EPRowInfo() {
        super(_implied_attributes);
    }

    public int getRowNo() throws IOException {
        if (this._no == null) {
            this._no = NumericConverter.extractNonNegativeInteger(this.getValue(_no_attribute));
        }
        return this._no.intValue();
    }

    public double getPoints() throws IOException {
        if (this._unit == null) {
            this._unit = NumericConverter.extractDouble(this.getValue(_unit_attribute));
        }
        return this._unit.doubleValue();
    }

    public int getLeftMargin() throws IOException {
        if (this._margin_a == null) {
            this._margin_a = NumericConverter.extractInteger(this.getValue(_margin_a_attribute), _margin_validator);
        }
        return this._margin_a.intValue();
    }

    public int getRightMargin() throws IOException {
        if (this._margin_b == null) {
            this._margin_b = NumericConverter.extractInteger(this.getValue(_margin_b_attribute), _margin_validator);
        }
        return this._margin_b.intValue();
    }

    public boolean getHardSize() throws IOException {
        if (this._hard_size == null) {
            this._hard_size = BooleanConverter.extractBoolean(this.getValue(_hard_size_attribute));
        }
        return this._hard_size.booleanValue();
    }

    public boolean getHidden() throws IOException {
        if (this._hidden == null) {
            this._hidden = BooleanConverter.extractBoolean(this.getValue(_hidden_attribute));
        }
        return this._hidden.booleanValue();
    }

    public boolean getCollapsed() throws IOException {
        if (this._collapsed == null) {
            this._collapsed = BooleanConverter.extractBoolean(this.getValue(_collapsed_attribute));
        }
        return this._collapsed.booleanValue();
    }

    public int getOutlineLevel() throws IOException {
        if (this._outline_level == null) {
            this._outline_level = NumericConverter.extractInteger(this.getValue(_outline_level_attribute));
        }
        return this._outline_level.intValue();
    }

    public int getRLECount() throws IOException {
        if (this._count == null) {
            this._count = NumericConverter.extractInteger(this.getValue(_count_attribute));
        }
        return this._count.intValue();
    }

    public void endProcessing() throws IOException {
        int row = this.getRowNo();
        if (row > Short.MAX_VALUE) {
            throw new IOException("Illegal row value: " + row);
        }
        this.getSheet().getRow(row).setHeight(this.getPoints());
    }
}

