/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.model.pattern;

import net.sourceforge.chaperon.common.Decoder;
import net.sourceforge.chaperon.model.Violations;
import net.sourceforge.chaperon.model.pattern.CharacterClassElement;

public class CharacterSet
implements CharacterClassElement {
    private String set = "";
    private String location = null;

    public void setCharacters(String set) {
        this.set = set;
    }

    public void setCharacterAsCode(String code) {
        this.setCharacters(String.valueOf((char)Integer.parseInt(code)));
    }

    public String getCharacters() {
        return this.set;
    }

    public String getCharacterAsCode() {
        if (this.set != null && this.set.length() == 1) {
            return String.valueOf((int)this.set.charAt(0));
        }
        return null;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public String toString() {
        return Decoder.decode(this.set, "[^- ]");
    }

    public Object clone() {
        CharacterSet clone = new CharacterSet();
        clone.setCharacters(this.getCharacters());
        return clone;
    }

    public Violations validate() {
        Violations violations = new Violations();
        if (this.set == null || this.set.length() == 0) {
            violations.addViolation("Character set contains no characters", this.getLocation());
        }
        return violations;
    }
}

