/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.model.extended;

import net.sourceforge.chaperon.model.Violations;
import net.sourceforge.chaperon.model.extended.Pattern;
import net.sourceforge.chaperon.model.extended.PatternList;
import net.sourceforge.chaperon.model.extended.PatternSet;

public class Definition
extends PatternList {
    private String symbol = null;
    private String location = null;
    private boolean releaseable = false;
    private boolean omitable = false;

    public Definition() {
    }

    public Definition(String symbol) {
        this.setSymbol(symbol);
    }

    public void setSymbol(String symbol) {
        if (symbol == null) {
            throw new NullPointerException();
        }
        this.symbol = symbol;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setReleaseable(boolean releaseable) {
        this.releaseable = releaseable;
    }

    public boolean isReleaseable() {
        return this.releaseable;
    }

    public void setOmitable(boolean omitable) {
        this.omitable = omitable;
    }

    public boolean isOmitable() {
        return this.omitable;
    }

    public Violations validate() {
        Violations violations = new Violations();
        if (this.symbol == null) {
            violations.addViolation("No symbol is for the left side defined", this.location);
        }
        if (this.getPatternCount() == 0) {
            violations.addViolation("No pattern are for the right side defined", this.location);
        }
        int i = 0;
        while (i < this.getPatternCount()) {
            violations.addViolations(this.getPattern(i).validate());
            ++i;
        }
        return violations;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Definition) {
            Definition definition = (Definition)o;
            return this.symbol.equals(definition.symbol) && super.equals(o);
        }
        return false;
    }

    public String toString(PatternSet previous, PatternSet next) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.symbol);
        buffer.append(" := ");
        buffer.append(super.toString(previous, next));
        return buffer.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        Definition clone = new Definition();
        clone.symbol = this.symbol;
        int i = 0;
        while (i < this.getPatternCount()) {
            clone.addPattern((Pattern)this.getPattern(i).clone());
            ++i;
        }
        clone.location = this.location;
        return clone;
    }
}

