/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.build;

import java.util.ArrayList;
import net.sourceforge.chaperon.build.EndOfFile;
import net.sourceforge.chaperon.build.FirstSetCollection;
import net.sourceforge.chaperon.build.ItemSet;
import net.sourceforge.chaperon.common.IntegerList;
import net.sourceforge.chaperon.model.grammar.Grammar;
import net.sourceforge.chaperon.model.symbol.SymbolSet;
import org.apache.commons.logging.Log;

public class ItemSetCollection {
    private static final EndOfFile EOF = new EndOfFile();
    private static final int NOTCHANGED = 0;
    private static final int CHANGED = 1;
    private ArrayList itemsets = new ArrayList();
    private Grammar grammar;
    private FirstSetCollection firstsets;
    private SymbolSet tsymbols;
    private SymbolSet ntsymbols;
    private Log log;

    public ItemSetCollection(Grammar grammar, FirstSetCollection firstsets) {
        this(grammar, firstsets, null);
    }

    public ItemSetCollection(Grammar grammar, FirstSetCollection firstsets, Log log) {
        int index;
        ItemSet J;
        int j;
        this.grammar = grammar;
        this.firstsets = firstsets;
        this.log = log;
        SymbolSet symbols = grammar.getSymbols();
        this.tsymbols = symbols.getTerminals();
        this.ntsymbols = symbols.getNonterminals();
        IntegerList changedState = new IntegerList();
        this.addItemSet(this.getStartItemSet());
        changedState.add(1);
        boolean mustrepeat = false;
        int i = 0;
        while (i < this.getItemSetCount()) {
            changedState.set(i, 0);
            ItemSet I = this.getItemSet(i);
            SymbolSet nextnonterminals = I.getNextNonterminals();
            j = 0;
            while (j < nextnonterminals.getSymbolCount()) {
                J = I.jump(nextnonterminals.getSymbol(j));
                if (!J.isEmpty()) {
                    index = this.indexOfCore(J);
                    if (index < 0) {
                        index = this.addItemSet(J);
                        changedState.add(1);
                    } else if (this.getItemSet(index).addItemSet(J)) {
                        if (index < changedState.getCount()) {
                            changedState.set(index, 1);
                        } else {
                            changedState.add(1);
                        }
                        if (index <= i) {
                            mustrepeat = true;
                        }
                    }
                    I.setTransition(nextnonterminals.getSymbol(j), index);
                }
                ++j;
            }
            SymbolSet nextterminals = I.getNextTerminals();
            int j2 = 0;
            while (j2 < nextterminals.getSymbolCount()) {
                ItemSet J2 = I.jump(nextterminals.getSymbol(j2));
                if (!J2.isEmpty()) {
                    int index2 = this.indexOfCore(J2);
                    if (index2 < 0) {
                        index2 = this.addItemSet(J2);
                        changedState.add(1);
                    } else if (this.getItemSet(index2).addItemSet(J2)) {
                        if (index2 < changedState.getCount()) {
                            changedState.set(index2, 1);
                        } else {
                            changedState.add(1);
                        }
                        if (index2 <= i) {
                            mustrepeat = true;
                        }
                    }
                    I.setTransition(nextterminals.getSymbol(j2), index2);
                }
                ++j2;
            }
            ++i;
        }
        do {
            mustrepeat = false;
            int i2 = 0;
            while (i2 < this.getItemSetCount()) {
                if (changedState.get(i2) == 1) {
                    changedState.set(i2, 0);
                    ItemSet I = this.getItemSet(i2);
                    symbols = I.getShiftSymbols();
                    j = 0;
                    while (j < symbols.getSymbolCount()) {
                        J = I.jump(symbols.getSymbol(j));
                        index = I.getTransition(symbols.getSymbol(j));
                        if (this.getItemSet(index).addItemSet(J)) {
                            if (index < changedState.getCount()) {
                                changedState.set(index, 1);
                            } else {
                                changedState.add(1);
                            }
                            if (index <= i2) {
                                mustrepeat = true;
                            }
                        }
                        ++j;
                    }
                }
                ++i2;
            }
        } while (mustrepeat);
    }

    private ItemSet getStartItemSet() {
        ItemSet I = new ItemSet(this.grammar, this.firstsets);
        IntegerList startlist = this.grammar.getProductionList(this.grammar.getStartSymbol());
        int i = 0;
        while (i < startlist.getCount()) {
            I.addItem(startlist.get(i), 0, EOF);
            ++i;
        }
        return I.closure();
    }

    public int addItemSet(ItemSet itemset) {
        int index = this.indexOf(itemset);
        if (index == -1) {
            this.itemsets.add(itemset);
            index = this.itemsets.size() - 1;
        }
        return index;
    }

    public ItemSet getItemSet(int index) {
        return (ItemSet)this.itemsets.get(index);
    }

    public int getItemSetCount() {
        return this.itemsets.size();
    }

    public int indexOf(ItemSet itemset) {
        int i = 0;
        while (i < this.itemsets.size()) {
            if (((ItemSet)this.itemsets.get(i)).equals(itemset)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean contains(ItemSet itemset) {
        int i = 0;
        while (i < this.itemsets.size()) {
            if (((ItemSet)this.itemsets.get(i)).equals(itemset)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int indexOfCore(ItemSet itemset) {
        int i = 0;
        while (i < this.itemsets.size()) {
            if (((ItemSet)this.itemsets.get(i)).equalsCore(itemset)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean containsCore(ItemSet itemset) {
        int i = 0;
        while (i < this.itemsets.size()) {
            if (((ItemSet)this.itemsets.get(i)).equalsCore(itemset)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.getItemSetCount()) {
            buffer.append("State ");
            buffer.append(String.valueOf(i));
            buffer.append(":\n");
            buffer.append(this.getItemSet(i).toString());
            buffer.append("\n");
            ++i;
        }
        return buffer.toString();
    }
}

