/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.matching;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.matching.Matcher;
import org.apache.cocoon.sitemap.PatternException;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;

public class MountTableMatcher
extends AbstractLogEnabled
implements Matcher,
ThreadSafe,
Serviceable,
Parameterizable {
    private ServiceManager manager;
    private SourceResolver resolver;
    private Map mountTables = Collections.synchronizedMap(new HashMap());
    private boolean ignoreMissingTables = false;

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
        this.resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
    }

    public void parameterize(Parameters params) throws ParameterException {
        this.ignoreMissingTables = params.getParameterAsBoolean("ignore-missing-tables", false);
    }

    private Map getMountTable(String src) throws Exception {
        Source source = this.resolver.resolveURI(src);
        String uri = source.getURI();
        if (!source.exists()) {
            this.resolver.release(source);
            if (this.ignoreMissingTables) {
                return Collections.EMPTY_MAP;
            }
            throw new PatternException("Mount table does not exist: '" + uri + "'");
        }
        Object[] values = (Object[])this.mountTables.get(uri);
        if (values != null) {
            SourceValidity oldValidity = (SourceValidity)values[1];
            int valid = oldValidity.isValid();
            if (valid == 1) {
                return (Map)values[0];
            }
            if (valid == 0 && oldValidity.isValid(source.getValidity()) == 1) {
                return (Map)values[0];
            }
        } else {
            values = new Object[2];
        }
        HashMap<String, String> mounts = new HashMap<String, String>();
        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        Configuration config = builder.build(SourceUtil.getInputSource(source));
        this.resolver.release(source);
        Configuration[] children = config.getChildren();
        int i = 0;
        while (i < children.length) {
            String prefix;
            Configuration child = children[i];
            if ("mount".equals(child.getName())) {
                prefix = children[i].getAttribute("uri-prefix");
                if (!prefix.endsWith("/")) {
                    prefix = prefix + '/';
                }
            } else {
                throw new PatternException("Unexpected element '" + child.getName() + "' (awaiting 'mount'), at " + child.getLocation());
            }
            mounts.put(prefix, children[i].getAttribute("src"));
            ++i;
        }
        values[0] = mounts;
        values[1] = source.getValidity();
        this.mountTables.put(uri, values);
        return mounts;
    }

    public Map match(String pattern, Map objectModel, Parameters parameters) throws PatternException {
        Map mounts;
        try {
            mounts = this.getMountTable(pattern);
        }
        catch (PatternException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new PatternException(e);
        }
        Request request = ObjectModelHelper.getRequest(objectModel);
        String uri = request.getSitemapURI();
        Iterator iter = mounts.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String prefix = (String)entry.getKey();
            if (!uri.startsWith(prefix)) continue;
            HashMap<String, String> result = new HashMap<String, String>(2);
            result.put("uri-prefix", prefix);
            result.put("src", (String)entry.getValue());
            return result;
        }
        return null;
    }
}

