package fr.gouv.culture.sdx.thesaurus;


import fr.gouv.culture.sdx.utils.lucene.LuceneDataStore;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

import java.util.ArrayList;
import java.util.Enumeration;


public class LuceneConcept extends AbstractConcept {


    protected Document luceneDoc = null;
    protected final String idKey = LuceneDataStore.ID_FIELD;

    public LuceneConcept() {
        super();
    }

    public LuceneConcept(Document lDoc) {
        if (lDoc != null)
            this.luceneDoc = lDoc;
    }

    /**Provides the value from a lucene data object if it exists*/
    public String getValue() {
        if (luceneDoc != null)
            return luceneDoc.get(valueKey);
        return super.value;
    }

    /**Provides the xml:lang otherwise it returnts the value of the class variable from a lucene data object if it exists*/
    public String getXmlLang() {
        if (luceneDoc != null)
            return luceneDoc.get(xmlLangKey);
        return super.xmlLang;
    }

    public String[] getRelations(int type) {
        if (luceneDoc != null)
        //use this when we update lucene jarreturn luceneDoc.getValues(getRelationTypeString(type));
        {
            ArrayList fieldValues = new ArrayList();
            String relation = getRelationTypeString(type);
            Enumeration lFields = luceneDoc.fields();
            if (lFields != null) {
                while (lFields.hasMoreElements()) {
                    Field field = (Field) lFields.nextElement();
                    if (field != null)
                        if (field.name().equalsIgnoreCase(relation))
                            fieldValues.add(field.stringValue());

                }
            }
            if (fieldValues.size() > 0)
                return (String[]) fieldValues.toArray(new String[0]);
        }

        return null;
    }


    public String getId() {
        if (luceneDoc != null)
            return luceneDoc.get(idKey);
        return super.getId();
    }

}
