/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.sdx.document;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.exception.SDXExceptionCode;
import fr.gouv.culture.sdx.utils.Utilities;
import org.apache.avalon.excalibur.xml.Parser;
import org.apache.cocoon.serialization.XMLSerializer;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.xml.sax.SAXException;

import java.io.*;

/**
 * An XML document, parsable and indexable.
 */
public class XMLDocument extends AbstractIndexableDocument implements ParsableDocument {

    /** If true the source comes from a DOM. */
    private boolean fromDOM = false;

    /** Document's content comes from a DOM object. */
    private final static int FROM_DOM = 3;

    /** The document's content as a DOM. */
    private org.w3c.dom.Document cDOM = null;

    private String MIMETYPE = "text/xml";

    /**
     * Creates a document with a given id.
     *
     * @param   id  The document's id.
     * If logging is desired the logger should be set after creation.
     * @see #enableLogging
     */
    public XMLDocument(String id) throws SDXException {
        setId(id);
    }

    /**
     * Creates a document.
     *
     * The document's id must be given later.
     *
     * If logging is desired the logger should be set after creation.
     * @see #enableLogging
     */
    public XMLDocument() {
    }

    /** Opens a stream for reading the document's content. */
    public InputStream openStream() throws SDXException {
        if (fromDOM) {
            ByteArrayInputStream bIn = null;
            ByteArrayOutputStream bOut = null;
            try {
                /*maybe useful in the future
                try {
                    bOut = new ByteArrayOutputStream();
                    Transformer t = TransformerFactory.newInstance().newTransformer();
                    DOMSource ds = new DOMSource(cDOM);
                    StreamResult sr = new StreamResult(bOut);
                    t.transform(ds, sr);
                    return new ByteArrayInputStream(bOut);
                } catch (TransformerException e) {
                    e.printStackTrace(System.err);
                } catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
                    transformerFactoryConfigurationError.printStackTrace();
                }*/
                //i dont think this is the problem, but i hope so-rbp
                bOut = new ByteArrayOutputStream();
                XMLSerializer xs = new XMLSerializer();
                xs.setOutputStream(bOut);
                DOMStreamer streamer = new DOMStreamer(xs);
                streamer.stream(cDOM);
                bIn = new ByteArrayInputStream(bOut.toByteArray());
                return bIn;

            } catch (SAXException e) {
                //unable to parse
                String[] args = new String[1];
                args[0] = getId();
                throw new SDXException(logger, SDXExceptionCode.ERROR_OPEN_STREAM, args, e);
            } finally {
                try {
                    if (bOut != null) bOut.close();
                    if (bIn != null) bIn.close();
                } catch (IOException e) {
                    throw new SDXException(logger, SDXExceptionCode.ERROR_CLOSE_STREAM, null, e);
                }
            }
        } else
            return super.openStream();
    }

    /** Set the content as a DOM. */
    public void setContent(org.w3c.dom.Document d) {
        cDOM = d;
        fromDOM = true;
//        setPreferredFilename(null);
//        resetContent(FROM_DOM);   What to do here?
    }



/*
    public void parseDoc(ComponentManager manager){

        // The parser to use
        Parser parser = null;

        try {

            // Get the parser from Cocoon's configuration
            parser = (Parser)manager.lookup(Parser.ROLE);


    }
*/

    /** Returns the length of the document. */
    public int getLength() {
        if (fromDOM)
            return -1;
        else
            return super.getLength();
    }

    /** Parses the document. */
    public void parse(Parser parser) throws SDXException {
        parse(parser, this.xmlConsumer);
    }

    /** Starts the indexing process.
     *
     *@param parser     The parser to use
     *@param consumer   The consumer for the events generated by the indexing process
     */
    public void startIndexing(Parser parser, XMLConsumer consumer) throws SDXException {
        //verifying the consumer
        Utilities.checkXmlConsumer(logger, consumer);
        //resetting indexation data structures
        super.resetFields();
        parse(parser, consumer);
    }

    /** Parses a document using a specific consumer.
     *
     *@param parser     The parser to use
     *@param consumer   The consumer of the events generated by the parse
     */
    public void parse(Parser parser, XMLConsumer consumer) throws SDXException {
        if (parser == null) {
            //no parser here
            String[] args = new String[1];
            //is this a bad idea, we need some way to give the user more information about which document parsing has failed resides
            if (this.getURL() != null) args[0] = this.getURL().toExternalForm();
            throw new SDXException(logger, SDXExceptionCode.ERROR_PARSER_NULL, args, null);
        }
        //verifying the consumer
        Utilities.checkXmlConsumer(logger, consumer);
        try {
            parser.parse(getInputSource(), consumer);
//                this.parser.parse(new InputSource(super.openStream()), consumer);
        } catch (SAXException e) {
            //unable to parse
            String[] args = new String[2];
            //is this a bad idea, we need some way to give the user more information about which document parsing has failed resides
            if (this.getURL() != null) args[0] = this.getURL().toExternalForm();
            args[1] = e.getMessage();
            throw new SDXException(logger, SDXExceptionCode.ERROR_PARSE_DOC, args, e);
        } catch (IOException e) {
            //unable to parse
            String[] args = new String[2];
            //is this a bad idea, we need some way to give the user more information about which document parsing has failed resides
            if (this.getURL() != null) args[0] = this.getURL().toExternalForm();
            args[1] = e.getMessage();
            throw new SDXException(logger, SDXExceptionCode.ERROR_PARSE_DOC, args, e);
        }

    }

    /**Gets the docType for the document*/
    public String getDocType() {
        return Document.DOCTYPE_XML;
    }

    /**Set's the transformed document for the parent document.
     * The transformed document will have the same id and preferred
     * filename as the original.
     *
     * @param content   The byte array of data
     */
    public void setTransformedDocument(byte[] content) throws SDXException {
        if (content == null) {
            String[] args = new String[1];
            args[0] = this.getId();
            throw new SDXException(logger, SDXExceptionCode.ERROR_SET_TRANSFORMED_DOC, args, null);
        }
        IndexableDocument doc = new XMLDocument();
        this.transformedDoc = doc;
        this.transformedDoc.enableLogging(this.logger);
        this.transformedDoc.setContent(content);
        this.setUpTransformedDocument();
    }

    /**Set's the transformed document for the parent document.
     * The transformed document will have the same id and preferred
     * filename as the original.
     *
     * @param file      The transformed document file
     */
    public void setTransformedDocument(File file) throws SDXException {
        if (file == null) {
            String[] args = new String[1];
            args[0] = this.getId();
            throw new SDXException(logger, SDXExceptionCode.ERROR_SET_TRANSFORMED_DOC, args, null);
        }
        IndexableDocument doc = new XMLDocument();
        this.transformedDoc = doc;
        this.transformedDoc.enableLogging(this.logger);
        this.transformedDoc.setContent(file);
        this.setUpTransformedDocument();
    }

    /**Returns the mimeType field (A String) for this document*/
    public String getMimeType() {
        return this.MIMETYPE;
    }

}
