/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.TokenStream;

class Parser {
    private int lastExprEndLine;
    private IRFactory nf;
    private ErrorReporter er;
    private boolean ok;
    private char[] sourceBuffer = new char[128];
    private int sourceTop;
    private int functionNumber;

    public Parser(IRFactory iRFactory) {
        this.nf = iRFactory;
    }

    private void mustMatchToken(TokenStream tokenStream, int n, String string) throws IOException, JavaScriptException {
        int n2 = tokenStream.getToken();
        if (n2 != n) {
            this.reportError(tokenStream, string);
            tokenStream.ungetToken(n2);
        }
    }

    private void reportError(TokenStream tokenStream, String string) throws JavaScriptException {
        this.ok = false;
        tokenStream.reportSyntaxError(string, null);
        throw new JavaScriptException((Object)string);
    }

    public Object parse(TokenStream tokenStream) throws IOException {
        this.ok = true;
        this.sourceTop = 0;
        this.functionNumber = 0;
        int n = tokenStream.getLineno();
        Object object = this.nf.createLeaf(133);
        while (true) {
            tokenStream.flags |= 0x10;
            int n2 = tokenStream.getToken();
            tokenStream.flags &= ~16;
            if (n2 <= 0) break;
            if (n2 == 110) {
                try {
                    this.nf.addChildToBack(object, this.function(tokenStream, false));
                    continue;
                }
                catch (JavaScriptException javaScriptException) {
                    this.ok = false;
                    break;
                }
            }
            tokenStream.ungetToken(n2);
            this.nf.addChildToBack(object, this.statement(tokenStream));
        }
        if (!this.ok) {
            return null;
        }
        Object object2 = this.nf.createScript(object, tokenStream.getSourceName(), n, tokenStream.getLineno(), this.sourceToString(0));
        return object2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object parseFunctionBody(TokenStream tokenStream) throws IOException {
        int n = tokenStream.flags;
        tokenStream.flags &= 0xFFFFFFF3;
        tokenStream.flags |= 2;
        Object object = this.nf.createBlock(tokenStream.getLineno());
        try {
            try {
                int n2;
                while ((n2 = tokenStream.peekToken()) > 0 && n2 != 93) {
                    if (n2 == 110) {
                        tokenStream.getToken();
                        this.nf.addChildToBack(object, this.function(tokenStream, false));
                        continue;
                    }
                    this.nf.addChildToBack(object, this.statement(tokenStream));
                }
            }
            catch (JavaScriptException javaScriptException) {
                this.ok = false;
                Object var6_7 = null;
                tokenStream.flags = n;
                return object;
            }
            Object var6_6 = null;
            tokenStream.flags = n;
            return object;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            tokenStream.flags = n;
            throw throwable;
        }
    }

    private Object function(TokenStream tokenStream, boolean bl) throws IOException, JavaScriptException {
        String string;
        Object object;
        Object object2;
        String string2;
        int n = tokenStream.getLineno();
        Object object3 = null;
        if (tokenStream.matchToken(44)) {
            string2 = tokenStream.getString();
            if (!tokenStream.matchToken(94)) {
                if (Context.getContext().hasFeature(2)) {
                    this.sourceAddString(44, string2);
                    Object object4 = this.nf.createName(string2);
                    string2 = null;
                    object3 = this.memberExprTail(tokenStream, false, object4);
                }
                this.mustMatchToken(tokenStream, 94, "msg.no.paren.parms");
            }
        } else if (tokenStream.matchToken(94)) {
            string2 = null;
        } else {
            string2 = null;
            if (Context.getContext().hasFeature(2)) {
                object3 = this.memberExpr(tokenStream, false);
            }
            this.mustMatchToken(tokenStream, 94, "msg.no.paren.parms");
        }
        if (object3 != null) {
            this.sourceAdd('a');
            this.sourceAdd('\u0080');
        }
        this.sourceAdd('n');
        this.sourceAdd((char)this.functionNumber);
        ++this.functionNumber;
        int n2 = this.sourceTop;
        int n3 = this.functionNumber;
        try {
            this.functionNumber = 0;
            this.sourceAdd('n');
            if (string2 != null) {
                this.sourceAddString(44, string2);
            }
            this.sourceAdd('^');
            object2 = this.nf.createLeaf(94);
            if (!tokenStream.matchToken(95)) {
                boolean bl2 = true;
                do {
                    if (!bl2) {
                        this.sourceAdd('`');
                    }
                    bl2 = false;
                    this.mustMatchToken(tokenStream, 44, "msg.no.parm");
                    String string3 = tokenStream.getString();
                    this.nf.addChildToBack(object2, this.nf.createName(string3));
                    this.sourceAddString(44, string3);
                } while (tokenStream.matchToken(96));
                this.mustMatchToken(tokenStream, 95, "msg.no.paren.after.parms");
            }
            this.sourceAdd('_');
            this.mustMatchToken(tokenStream, 92, "msg.no.brace.body");
            this.sourceAdd('\\');
            this.sourceAdd('\u0001');
            object = this.parseFunctionBody(tokenStream);
            this.mustMatchToken(tokenStream, 93, "msg.no.brace.after.body");
            this.sourceAdd(']');
            string = this.sourceToString(n2);
            Object var14_15 = null;
            this.sourceTop = n2;
            this.functionNumber = n3;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            this.sourceTop = n2;
            this.functionNumber = n3;
            throw throwable;
        }
        Object object5 = this.nf.createFunction(string2, object2, object, tokenStream.getSourceName(), n, tokenStream.getLineno(), string, bl || object3 != null);
        if (object3 != null) {
            object5 = this.nf.createBinary(97, 128, object3, object5);
        }
        if (!bl) {
            if (object3 != null) {
                this.sourceAdd('Y');
            }
            this.sourceAdd('\u0001');
            this.wellTerminated(tokenStream, 110);
        }
        return object5;
    }

    private Object statements(TokenStream tokenStream) throws IOException {
        int n;
        Object object = this.nf.createBlock(tokenStream.getLineno());
        while ((n = tokenStream.peekToken()) > 0 && n != 93) {
            this.nf.addChildToBack(object, this.statement(tokenStream));
        }
        return object;
    }

    private Object condition(TokenStream tokenStream) throws IOException, JavaScriptException {
        this.mustMatchToken(tokenStream, 94, "msg.no.paren.cond");
        this.sourceAdd('^');
        Object object = this.expr(tokenStream, false);
        this.mustMatchToken(tokenStream, 95, "msg.no.paren.after.cond");
        this.sourceAdd('_');
        return object;
    }

    private boolean wellTerminated(TokenStream tokenStream, int n) throws IOException, JavaScriptException {
        int n2 = tokenStream.peekTokenSameLine();
        if (n2 == -1) {
            return false;
        }
        if (n2 != 0 && n2 != 1 && n2 != 89 && n2 != 93) {
            int n3 = Context.getContext().getLanguageVersion();
            if ((n2 == 110 || n == 110) && n3 < 120) {
                return true;
            }
            this.reportError(tokenStream, "msg.no.semi.stmt");
        }
        return true;
    }

    private String matchLabel(TokenStream tokenStream) throws IOException, JavaScriptException {
        int n = tokenStream.getLineno();
        String string = null;
        int n2 = tokenStream.peekTokenSameLine();
        if (n2 == 44) {
            tokenStream.getToken();
            string = tokenStream.getString();
        }
        if (n == tokenStream.getLineno()) {
            this.wellTerminated(tokenStream, -1);
        }
        return string;
    }

    private Object statement(TokenStream tokenStream) throws IOException {
        try {
            return this.statementHelper(tokenStream);
        }
        catch (JavaScriptException javaScriptException) {
            int n;
            int n2 = tokenStream.getLineno();
            while ((n = tokenStream.getToken()) != 89 && n != 1 && n != 0 && n != -1) {
            }
            return this.nf.createExprStatement(this.nf.createName("error"), n2);
        }
    }

    private Object statementHelper(TokenStream tokenStream) throws IOException, JavaScriptException {
        Object object = null;
        boolean bl = false;
        int n = 0;
        int n2 = tokenStream.getToken();
        switch (n2) {
            case 113: {
                bl = true;
                this.sourceAdd('q');
                int n3 = tokenStream.getLineno();
                Object object2 = this.condition(tokenStream);
                this.sourceAdd('\\');
                this.sourceAdd('\u0001');
                Object object3 = this.statement(tokenStream);
                Object object4 = null;
                if (tokenStream.matchToken(114)) {
                    this.sourceAdd(']');
                    this.sourceAdd('r');
                    this.sourceAdd('\\');
                    this.sourceAdd('\u0001');
                    object4 = this.statement(tokenStream);
                }
                this.sourceAdd(']');
                this.sourceAdd('\u0001');
                object = this.nf.createIf(object2, object3, object4, n3);
                break;
            }
            case 115: {
                bl = true;
                this.sourceAdd('s');
                object = this.nf.createSwitch(tokenStream.getLineno());
                Object object5 = null;
                this.mustMatchToken(tokenStream, 94, "msg.no.paren.switch");
                this.sourceAdd('^');
                this.nf.addChildToBack(object, this.expr(tokenStream, false));
                this.mustMatchToken(tokenStream, 95, "msg.no.paren.after.switch");
                this.sourceAdd('_');
                this.mustMatchToken(tokenStream, 92, "msg.no.brace.switch");
                this.sourceAdd('\\');
                this.sourceAdd('\u0001');
                while ((n2 = tokenStream.getToken()) != 93 && n2 != 0) {
                    switch (n2) {
                        case 116: {
                            this.sourceAdd('t');
                            object5 = this.nf.createUnary(116, this.expr(tokenStream, false));
                            this.sourceAdd('c');
                            this.sourceAdd('\u0001');
                            break;
                        }
                        case 117: {
                            object5 = this.nf.createLeaf(117);
                            this.sourceAdd('u');
                            this.sourceAdd('c');
                            this.sourceAdd('\u0001');
                            break;
                        }
                        default: {
                            this.reportError(tokenStream, "msg.bad.switch");
                        }
                    }
                    this.mustMatchToken(tokenStream, 99, "msg.no.colon.case");
                    Object object6 = this.nf.createLeaf(133);
                    while ((n2 = tokenStream.peekToken()) != 93 && n2 != 116 && n2 != 117 && n2 != 0) {
                        this.nf.addChildToBack(object6, this.statement(tokenStream));
                    }
                    this.nf.addChildToBack(object5, object6);
                    this.nf.addChildToBack(object, object5);
                }
                this.sourceAdd(']');
                this.sourceAdd('\u0001');
                break;
            }
            case 118: {
                bl = true;
                this.sourceAdd('v');
                int n4 = tokenStream.getLineno();
                Object object7 = this.condition(tokenStream);
                this.sourceAdd('\\');
                this.sourceAdd('\u0001');
                Object object8 = this.statement(tokenStream);
                this.sourceAdd(']');
                this.sourceAdd('\u0001');
                object = this.nf.createWhile(object7, object8, n4);
                break;
            }
            case 119: {
                this.sourceAdd('w');
                this.sourceAdd('\\');
                this.sourceAdd('\u0001');
                int n5 = tokenStream.getLineno();
                Object object9 = this.statement(tokenStream);
                this.sourceAdd(']');
                this.mustMatchToken(tokenStream, 118, "msg.no.while.do");
                this.sourceAdd('v');
                Object object10 = this.condition(tokenStream);
                object = this.nf.createDoWhile(object9, object10, n5);
                break;
            }
            case 120: {
                Object object11;
                Object object12;
                bl = true;
                this.sourceAdd('x');
                int n6 = tokenStream.getLineno();
                Object object13 = null;
                this.mustMatchToken(tokenStream, 94, "msg.no.paren.for");
                this.sourceAdd('^');
                n2 = tokenStream.peekToken();
                if (n2 == 89) {
                    object12 = this.nf.createLeaf(132);
                } else if (n2 == 123) {
                    tokenStream.getToken();
                    object12 = this.variables(tokenStream, true);
                } else {
                    object12 = this.expr(tokenStream, true);
                }
                n2 = tokenStream.peekToken();
                if (n2 == 103 && tokenStream.getOp() == 63) {
                    tokenStream.matchToken(103);
                    this.sourceAdd('?');
                    object11 = this.expr(tokenStream, false);
                } else {
                    this.mustMatchToken(tokenStream, 89, "msg.no.semi.for");
                    this.sourceAdd('Y');
                    object11 = tokenStream.peekToken() == 89 ? this.nf.createLeaf(132) : this.expr(tokenStream, false);
                    this.mustMatchToken(tokenStream, 89, "msg.no.semi.for.cond");
                    this.sourceAdd('Y');
                    object13 = tokenStream.peekToken() == 95 ? this.nf.createLeaf(132) : this.expr(tokenStream, false);
                }
                this.mustMatchToken(tokenStream, 95, "msg.no.paren.for.ctrl");
                this.sourceAdd('_');
                this.sourceAdd('\\');
                this.sourceAdd('\u0001');
                Object object14 = this.statement(tokenStream);
                this.sourceAdd(']');
                this.sourceAdd('\u0001');
                if (object13 == null) {
                    object = this.nf.createForIn(object12, object11, object14, n6);
                    break;
                }
                object = this.nf.createFor(object12, object11, object13, object14, n6);
                break;
            }
            case 75: {
                int n7 = tokenStream.getLineno();
                Object object15 = null;
                Object object16 = null;
                bl = true;
                this.sourceAdd('K');
                this.sourceAdd('\\');
                this.sourceAdd('\u0001');
                Object object17 = this.statement(tokenStream);
                this.sourceAdd(']');
                this.sourceAdd('\u0001');
                object15 = this.nf.createLeaf(133);
                boolean bl2 = false;
                int n8 = tokenStream.peekToken();
                if (n8 == 125) {
                    while (tokenStream.matchToken(125)) {
                        if (bl2) {
                            this.reportError(tokenStream, "msg.catch.unreachable");
                        }
                        this.sourceAdd('}');
                        this.mustMatchToken(tokenStream, 94, "msg.no.paren.catch");
                        this.sourceAdd('^');
                        this.mustMatchToken(tokenStream, 44, "msg.bad.catchcond");
                        String string = tokenStream.getString();
                        this.sourceAddString(44, string);
                        Object object18 = null;
                        if (tokenStream.matchToken(113)) {
                            this.sourceAdd('q');
                            object18 = this.expr(tokenStream, false);
                        } else {
                            bl2 = true;
                        }
                        this.mustMatchToken(tokenStream, 95, "msg.bad.catchcond");
                        this.sourceAdd('_');
                        this.mustMatchToken(tokenStream, 92, "msg.no.brace.catchblock");
                        this.sourceAdd('\\');
                        this.sourceAdd('\u0001');
                        this.nf.addChildToBack(object15, this.nf.createCatch(string, object18, this.statements(tokenStream), tokenStream.getLineno()));
                        this.mustMatchToken(tokenStream, 93, "msg.no.brace.after.body");
                        this.sourceAdd(']');
                        this.sourceAdd('\u0001');
                    }
                } else if (n8 != 126) {
                    this.mustMatchToken(tokenStream, 126, "msg.try.no.catchfinally");
                }
                if (tokenStream.matchToken(126)) {
                    this.sourceAdd('~');
                    this.sourceAdd('\\');
                    this.sourceAdd('\u0001');
                    object16 = this.statement(tokenStream);
                    this.sourceAdd(']');
                    this.sourceAdd('\u0001');
                }
                object = this.nf.createTryCatchFinally(object17, object15, object16, n7);
                break;
            }
            case 62: {
                int n9 = tokenStream.getLineno();
                this.sourceAdd('>');
                object = this.nf.createThrow(this.expr(tokenStream, false), n9);
                if (n9 != tokenStream.getLineno()) break;
                this.wellTerminated(tokenStream, -1);
                break;
            }
            case 121: {
                int n10 = tokenStream.getLineno();
                this.sourceAdd('y');
                String string = this.matchLabel(tokenStream);
                if (string != null) {
                    this.sourceAddString(44, string);
                }
                object = this.nf.createBreak(string, n10);
                break;
            }
            case 122: {
                int n11 = tokenStream.getLineno();
                this.sourceAdd('z');
                String string = this.matchLabel(tokenStream);
                if (string != null) {
                    this.sourceAddString(44, string);
                }
                object = this.nf.createContinue(string, n11);
                break;
            }
            case 124: {
                bl = true;
                this.sourceAdd('|');
                int n12 = tokenStream.getLineno();
                this.mustMatchToken(tokenStream, 94, "msg.no.paren.with");
                this.sourceAdd('^');
                Object object19 = this.expr(tokenStream, false);
                this.mustMatchToken(tokenStream, 95, "msg.no.paren.after.with");
                this.sourceAdd('_');
                this.sourceAdd('\\');
                this.sourceAdd('\u0001');
                Object object20 = this.statement(tokenStream);
                this.sourceAdd(']');
                this.sourceAdd('\u0001');
                object = this.nf.createWith(object19, object20, n12);
                break;
            }
            case 123: {
                int n13 = tokenStream.getLineno();
                object = this.variables(tokenStream, false);
                if (tokenStream.getLineno() != n13) break;
                this.wellTerminated(tokenStream, -1);
                break;
            }
            case 5: {
                Object object21 = null;
                int n14 = 0;
                this.sourceAdd('\u0005');
                if ((tokenStream.flags & 2) == 0) {
                    this.reportError(tokenStream, "msg.bad.return");
                }
                tokenStream.flags |= 0x10;
                n2 = tokenStream.peekTokenSameLine();
                tokenStream.flags &= ~16;
                if (n2 != 0 && n2 != 1 && n2 != 89 && n2 != 93) {
                    n14 = tokenStream.getLineno();
                    object21 = this.expr(tokenStream, false);
                    if (tokenStream.getLineno() == n14) {
                        this.wellTerminated(tokenStream, -1);
                    }
                    tokenStream.flags |= 4;
                } else {
                    tokenStream.flags |= 8;
                }
                object = this.nf.createReturn(object21, n14);
                break;
            }
            case 92: {
                bl = true;
                object = this.statements(tokenStream);
                this.mustMatchToken(tokenStream, 93, "msg.no.brace.block");
                break;
            }
            case -1: 
            case 1: 
            case 89: {
                object = this.nf.createLeaf(132);
                bl = true;
                break;
            }
            default: {
                n = n2;
                int n15 = tokenStream.getTokenno();
                tokenStream.ungetToken(n2);
                int n16 = tokenStream.getLineno();
                object = this.expr(tokenStream, false);
                if (tokenStream.peekToken() == 99) {
                    if (n != 44 || tokenStream.getTokenno() != n15) {
                        this.reportError(tokenStream, "msg.bad.label");
                    }
                    tokenStream.getToken();
                    String string = tokenStream.getString();
                    object = this.nf.createLabel(string, n16);
                    this.sourceAdd('c');
                    this.sourceAdd('\u0001');
                    return object;
                }
                if (n == 110) {
                    if (this.nf.getLeafType(object) != 110) {
                        this.reportError(tokenStream, "msg.syntax");
                    }
                    this.nf.setFunctionExpressionStatement(object);
                }
                object = this.nf.createExprStatement(object, n16);
                if (tokenStream.getLineno() != n16 && (n != 110 || tokenStream.getLineno() != this.lastExprEndLine)) break;
                this.wellTerminated(tokenStream, n);
            }
        }
        tokenStream.matchToken(89);
        if (!bl) {
            this.sourceAdd('Y');
            this.sourceAdd('\u0001');
        }
        return object;
    }

    private Object variables(TokenStream tokenStream, boolean bl) throws IOException, JavaScriptException {
        Object object = this.nf.createVariables(tokenStream.getLineno());
        boolean bl2 = true;
        this.sourceAdd('{');
        do {
            this.mustMatchToken(tokenStream, 44, "msg.bad.var");
            String string = tokenStream.getString();
            if (!bl2) {
                this.sourceAdd('`');
            }
            bl2 = false;
            this.sourceAddString(44, string);
            Object object2 = this.nf.createName(string);
            if (tokenStream.matchToken(97)) {
                if (tokenStream.getOp() != 128) {
                    this.reportError(tokenStream, "msg.bad.var.init");
                }
                this.sourceAdd('a');
                this.sourceAdd('\u0080');
                Object object3 = this.assignExpr(tokenStream, bl);
                this.nf.addChildToBack(object2, object3);
            }
            this.nf.addChildToBack(object, object2);
        } while (tokenStream.matchToken(96));
        return object;
    }

    private Object expr(TokenStream tokenStream, boolean bl) throws IOException, JavaScriptException {
        Object object = this.assignExpr(tokenStream, bl);
        while (tokenStream.matchToken(96)) {
            this.sourceAdd('`');
            object = this.nf.createBinary(96, object, this.assignExpr(tokenStream, bl));
        }
        return object;
    }

    private Object assignExpr(TokenStream tokenStream, boolean bl) throws IOException, JavaScriptException {
        Object object = this.condExpr(tokenStream, bl);
        if (tokenStream.matchToken(97)) {
            this.sourceAdd('a');
            this.sourceAdd((char)tokenStream.getOp());
            object = this.nf.createBinary(97, tokenStream.getOp(), object, this.assignExpr(tokenStream, bl));
        }
        return object;
    }

    private Object condExpr(TokenStream tokenStream, boolean bl) throws IOException, JavaScriptException {
        Object object = this.orExpr(tokenStream, bl);
        if (tokenStream.matchToken(98)) {
            this.sourceAdd('b');
            Object object2 = this.assignExpr(tokenStream, false);
            this.mustMatchToken(tokenStream, 99, "msg.no.colon.cond");
            this.sourceAdd('c');
            Object object3 = this.assignExpr(tokenStream, bl);
            return this.nf.createTernary(object, object2, object3);
        }
        return object;
    }

    private Object orExpr(TokenStream tokenStream, boolean bl) throws IOException, JavaScriptException {
        Object object = this.andExpr(tokenStream, bl);
        if (tokenStream.matchToken(100)) {
            this.sourceAdd('d');
            object = this.nf.createBinary(100, object, this.orExpr(tokenStream, bl));
        }
        return object;
    }

    private Object andExpr(TokenStream tokenStream, boolean bl) throws IOException, JavaScriptException {
        Object object = this.bitOrExpr(tokenStream, bl);
        if (tokenStream.matchToken(101)) {
            this.sourceAdd('e');
            object = this.nf.createBinary(101, object, this.andExpr(tokenStream, bl));
        }
        return object;
    }

    private Object bitOrExpr(TokenStream tokenStream, boolean bl) throws IOException, JavaScriptException {
        Object object = this.bitXorExpr(tokenStream, bl);
        while (tokenStream.matchToken(11)) {
            this.sourceAdd('\u000b');
            object = this.nf.createBinary(11, object, this.bitXorExpr(tokenStream, bl));
        }
        return object;
    }

    private Object bitXorExpr(TokenStream tokenStream, boolean bl) throws IOException, JavaScriptException {
        Object object = this.bitAndExpr(tokenStream, bl);
        while (tokenStream.matchToken(12)) {
            this.sourceAdd('\f');
            object = this.nf.createBinary(12, object, this.bitAndExpr(tokenStream, bl));
        }
        return object;
    }

    private Object bitAndExpr(TokenStream tokenStream, boolean bl) throws IOException, JavaScriptException {
        Object object = this.eqExpr(tokenStream, bl);
        while (tokenStream.matchToken(13)) {
            this.sourceAdd('\r');
            object = this.nf.createBinary(13, object, this.eqExpr(tokenStream, bl));
        }
        return object;
    }

    private Object eqExpr(TokenStream tokenStream, boolean bl) throws IOException, JavaScriptException {
        Object object = this.relExpr(tokenStream, bl);
        while (tokenStream.matchToken(102)) {
            this.sourceAdd('f');
            this.sourceAdd((char)tokenStream.getOp());
            object = this.nf.createBinary(102, tokenStream.getOp(), object, this.relExpr(tokenStream, bl));
        }
        return object;
    }

    private Object relExpr(TokenStream tokenStream, boolean bl) throws IOException, JavaScriptException {
        Object object = this.shiftExpr(tokenStream);
        while (tokenStream.matchToken(103)) {
            int n = tokenStream.getOp();
            if (bl && n == 63) {
                tokenStream.ungetToken(103);
                break;
            }
            this.sourceAdd('g');
            this.sourceAdd((char)n);
            object = this.nf.createBinary(103, n, object, this.shiftExpr(tokenStream));
        }
        return object;
    }

    private Object shiftExpr(TokenStream tokenStream) throws IOException, JavaScriptException {
        Object object = this.addExpr(tokenStream);
        while (tokenStream.matchToken(104)) {
            this.sourceAdd('h');
            this.sourceAdd((char)tokenStream.getOp());
            object = this.nf.createBinary(tokenStream.getOp(), object, this.addExpr(tokenStream));
        }
        return object;
    }

    private Object addExpr(TokenStream tokenStream) throws IOException, JavaScriptException {
        int n;
        Object object = this.mulExpr(tokenStream);
        while ((n = tokenStream.getToken()) == 23 || n == 24) {
            this.sourceAdd((char)n);
            object = this.nf.createBinary(n, object, this.mulExpr(tokenStream));
        }
        tokenStream.ungetToken(n);
        return object;
    }

    private Object mulExpr(TokenStream tokenStream) throws IOException, JavaScriptException {
        int n;
        Object object = this.unaryExpr(tokenStream);
        while ((n = tokenStream.peekToken()) == 25 || n == 26 || n == 27) {
            n = tokenStream.getToken();
            this.sourceAdd((char)n);
            object = this.nf.createBinary(n, object, this.unaryExpr(tokenStream));
        }
        return object;
    }

    private Object unaryExpr(TokenStream tokenStream) throws IOException, JavaScriptException {
        tokenStream.flags |= 0x10;
        int n = tokenStream.getToken();
        tokenStream.flags &= ~16;
        switch (n) {
            case 105: {
                this.sourceAdd('i');
                this.sourceAdd((char)tokenStream.getOp());
                return this.nf.createUnary(105, tokenStream.getOp(), this.unaryExpr(tokenStream));
            }
            case 23: 
            case 24: {
                this.sourceAdd('i');
                this.sourceAdd((char)n);
                return this.nf.createUnary(105, n, this.unaryExpr(tokenStream));
            }
            case 106: 
            case 107: {
                this.sourceAdd((char)n);
                return this.nf.createUnary(n, 130, this.memberExpr(tokenStream, true));
            }
            case 31: {
                this.sourceAdd('\u001f');
                return this.nf.createUnary(31, this.unaryExpr(tokenStream));
            }
            case -1: {
                break;
            }
            default: {
                tokenStream.ungetToken(n);
                int n2 = tokenStream.getLineno();
                Object object = this.memberExpr(tokenStream, true);
                int n3 = tokenStream.peekToken();
                if ((n3 == 106 || n3 == 107) && tokenStream.getLineno() == n2) {
                    int n4 = tokenStream.getToken();
                    this.sourceAdd((char)n4);
                    return this.nf.createUnary(n4, 131, object);
                }
                return object;
            }
        }
        return this.nf.createName("err");
    }

    private Object argumentList(TokenStream tokenStream, Object object) throws IOException, JavaScriptException {
        tokenStream.flags |= 0x10;
        boolean bl = tokenStream.matchToken(95);
        tokenStream.flags &= ~16;
        if (!bl) {
            boolean bl2 = true;
            do {
                if (!bl2) {
                    this.sourceAdd('`');
                }
                bl2 = false;
                this.nf.addChildToBack(object, this.assignExpr(tokenStream, false));
            } while (tokenStream.matchToken(96));
            this.mustMatchToken(tokenStream, 95, "msg.no.paren.arg");
        }
        this.sourceAdd('_');
        return object;
    }

    private Object memberExpr(TokenStream tokenStream, boolean bl) throws IOException, JavaScriptException {
        Object object;
        tokenStream.flags |= 0x10;
        int n = tokenStream.peekToken();
        tokenStream.flags &= ~16;
        if (n == 30) {
            tokenStream.getToken();
            this.sourceAdd('\u001e');
            object = this.nf.createLeaf(30);
            this.nf.addChildToBack(object, this.memberExpr(tokenStream, false));
            if (tokenStream.matchToken(94)) {
                this.sourceAdd('^');
                object = this.argumentList(tokenStream, object);
            }
            if ((n = tokenStream.peekToken()) == 92) {
                this.nf.addChildToBack(object, this.primaryExpr(tokenStream));
            }
        } else {
            object = this.primaryExpr(tokenStream);
        }
        return this.memberExprTail(tokenStream, bl, object);
    }

    private Object memberExprTail(TokenStream tokenStream, boolean bl, Object object) throws IOException, JavaScriptException {
        int n;
        this.lastExprEndLine = tokenStream.getLineno();
        while ((n = tokenStream.getToken()) > 0) {
            if (n == 108) {
                this.sourceAdd('l');
                this.mustMatchToken(tokenStream, 44, "msg.no.name.after.dot");
                String string = tokenStream.getString();
                this.sourceAddString(44, string);
                object = this.nf.createBinary(108, object, this.nf.createName(tokenStream.getString()));
                this.lastExprEndLine = tokenStream.getLineno();
                continue;
            }
            if (n == 90) {
                this.sourceAdd('Z');
                object = this.nf.createBinary(90, object, this.expr(tokenStream, false));
                this.mustMatchToken(tokenStream, 91, "msg.no.bracket.index");
                this.sourceAdd('[');
                this.lastExprEndLine = tokenStream.getLineno();
                continue;
            }
            if (bl && n == 94) {
                object = this.nf.createUnary(43, object);
                this.sourceAdd('^');
                object = this.argumentList(tokenStream, object);
                this.lastExprEndLine = tokenStream.getLineno();
                continue;
            }
            tokenStream.ungetToken(n);
            break;
        }
        return object;
    }

    private Object primaryExpr(TokenStream tokenStream) throws IOException, JavaScriptException {
        tokenStream.flags |= 0x10;
        int n = tokenStream.getToken();
        tokenStream.flags &= ~16;
        switch (n) {
            case 110: {
                return this.function(tokenStream, true);
            }
            case 90: {
                this.sourceAdd('Z');
                Object object = this.nf.createLeaf(134);
                tokenStream.flags |= 0x10;
                boolean bl = tokenStream.matchToken(91);
                tokenStream.flags &= ~16;
                if (!bl) {
                    boolean bl2 = true;
                    do {
                        tokenStream.flags |= 0x10;
                        n = tokenStream.peekToken();
                        tokenStream.flags &= ~16;
                        if (!bl2) {
                            this.sourceAdd('`');
                        } else {
                            bl2 = false;
                        }
                        if (n == 91) break;
                        if (n == 96) {
                            this.nf.addChildToBack(object, this.nf.createLeaf(109, 74));
                            continue;
                        }
                        this.nf.addChildToBack(object, this.assignExpr(tokenStream, false));
                    } while (tokenStream.matchToken(96));
                    this.mustMatchToken(tokenStream, 91, "msg.no.bracket.arg");
                }
                this.sourceAdd('[');
                return this.nf.createArrayLiteral(object);
            }
            case 92: {
                Object object = this.nf.createLeaf(135);
                this.sourceAdd('\\');
                if (!tokenStream.matchToken(93)) {
                    boolean bl = true;
                    block19: do {
                        Object object2;
                        if (!bl) {
                            this.sourceAdd('`');
                        } else {
                            bl = false;
                        }
                        n = tokenStream.getToken();
                        switch (n) {
                            case 44: 
                            case 46: {
                                String string = tokenStream.getString();
                                this.sourceAddString(44, string);
                                object2 = this.nf.createString(tokenStream.getString());
                                break;
                            }
                            case 45: {
                                double d = tokenStream.getNumber();
                                this.sourceAddNumber(d);
                                object2 = this.nf.createNumber(d);
                                break;
                            }
                            case 93: {
                                tokenStream.ungetToken(n);
                                break block19;
                            }
                            default: {
                                this.reportError(tokenStream, "msg.bad.prop");
                                break block19;
                            }
                        }
                        this.mustMatchToken(tokenStream, 99, "msg.no.colon.prop");
                        this.sourceAdd('\u0087');
                        this.nf.addChildToBack(object, object2);
                        this.nf.addChildToBack(object, this.assignExpr(tokenStream, false));
                    } while (tokenStream.matchToken(96));
                    this.mustMatchToken(tokenStream, 93, "msg.no.brace.prop");
                }
                this.sourceAdd(']');
                return this.nf.createObjectLiteral(object);
            }
            case 94: {
                this.sourceAdd('^');
                Object object = this.expr(tokenStream, false);
                this.sourceAdd('_');
                this.mustMatchToken(tokenStream, 95, "msg.no.paren");
                return object;
            }
            case 44: {
                String string = tokenStream.getString();
                this.sourceAddString(44, string);
                return this.nf.createName(string);
            }
            case 45: {
                double d = tokenStream.getNumber();
                this.sourceAddNumber(d);
                return this.nf.createNumber(d);
            }
            case 46: {
                String string = tokenStream.getString();
                this.sourceAddString(46, string);
                return this.nf.createString(string);
            }
            case 56: {
                String string = tokenStream.regExpFlags;
                tokenStream.regExpFlags = null;
                String string2 = tokenStream.getString();
                this.sourceAddString(56, '/' + string2 + '/' + string);
                return this.nf.createRegExp(string2, string);
            }
            case 109: {
                this.sourceAdd('m');
                this.sourceAdd((char)tokenStream.getOp());
                return this.nf.createLeaf(109, tokenStream.getOp());
            }
            case 127: {
                this.reportError(tokenStream, "msg.reserved.id");
                break;
            }
            case -1: {
                break;
            }
            default: {
                this.reportError(tokenStream, "msg.syntax");
            }
        }
        return null;
    }

    private void sourceAdd(char c) {
        if (this.sourceTop == this.sourceBuffer.length) {
            this.increaseSourceCapacity(this.sourceTop + 1);
        }
        this.sourceBuffer[this.sourceTop] = c;
        ++this.sourceTop;
    }

    private void sourceAddString(int n, String string) {
        int n2 = string.length();
        if (n2 > 65535) {
            Context.codeBug();
        }
        if (this.sourceTop + n2 + 2 > this.sourceBuffer.length) {
            this.increaseSourceCapacity(this.sourceTop + n2 + 2);
        }
        this.sourceAdd((char)n);
        this.sourceAdd((char)n2);
        string.getChars(0, n2, this.sourceBuffer, this.sourceTop);
        this.sourceTop += n2;
    }

    private void sourceAddNumber(double d) {
        this.sourceAdd('-');
        long l = (long)d;
        if ((double)l != d) {
            l = Double.doubleToLongBits(d);
            this.sourceAdd('D');
            this.sourceAdd((char)(l >> 48));
            this.sourceAdd((char)(l >> 32));
            this.sourceAdd((char)(l >> 16));
            this.sourceAdd((char)l);
        } else {
            if (l < 0L) {
                Context.codeBug();
            }
            if (l <= 65535L) {
                this.sourceAdd('S');
                this.sourceAdd((char)l);
            } else {
                this.sourceAdd('J');
                this.sourceAdd((char)(l >> 48));
                this.sourceAdd((char)(l >> 32));
                this.sourceAdd((char)(l >> 16));
                this.sourceAdd((char)l);
            }
        }
    }

    private void increaseSourceCapacity(int n) {
        int n2;
        if (n <= this.sourceBuffer.length) {
            Context.codeBug();
        }
        if ((n2 = this.sourceBuffer.length * 2) < n) {
            n2 = n;
        }
        char[] cArray = new char[n2];
        System.arraycopy(this.sourceBuffer, 0, cArray, 0, this.sourceTop);
        this.sourceBuffer = cArray;
    }

    private String sourceToString(int n) {
        if (n < 0 || this.sourceTop < n) {
            Context.codeBug();
        }
        return new String(this.sourceBuffer, n, this.sourceTop - n);
    }
}

