/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.xml.dom;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.apache.cocoon.xml.AbstractXMLProducer;
import org.apache.cocoon.xml.EmbeddedXMLPipe;
import org.apache.cocoon.xml.XMLConsumer;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class DOMStreamer
extends AbstractXMLProducer {
    protected static TransformerFactory factory = TransformerFactory.newInstance();
    protected Transformer transformer;

    public DOMStreamer() {
    }

    public DOMStreamer(XMLConsumer consumer) {
        this(consumer, consumer);
    }

    public DOMStreamer(ContentHandler content) {
        this(content, null);
    }

    public DOMStreamer(ContentHandler content, LexicalHandler lexical) {
        this();
        super.setContentHandler(content);
        super.setLexicalHandler(lexical);
    }

    public void stream(Node node) throws SAXException {
        if (this.transformer == null) {
            try {
                this.transformer = factory.newTransformer();
            }
            catch (TransformerConfigurationException e) {
                this.getLogger().error("DOMStreamer", (Throwable)e);
                throw new SAXException(e);
            }
        }
        DOMSource source = new DOMSource(node);
        ContentHandler handler = node.getNodeType() == 9 ? this.contentHandler : new EmbeddedXMLPipe(this.contentHandler);
        SAXResult result = new SAXResult(handler);
        result.setLexicalHandler(this.lexicalHandler);
        try {
            this.transformer.transform(source, result);
        }
        catch (TransformerException e) {
            this.getLogger().error("DOMStreamer", (Throwable)e);
            throw new SAXException(e);
        }
    }
}

