/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.Map;
import org.apache.cocoon.components.pipeline.StreamPipeline;
import org.apache.cocoon.components.treeprocessor.AbstractProcessingNode;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.ParameterizableProcessingNode;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.environment.Environment;

public class ReadNode
extends AbstractProcessingNode
implements ParameterizableProcessingNode {
    private String readerName;
    private VariableResolver source;
    private String mimeType;
    private int statusCode;
    private Map parameters;

    public ReadNode(String name, VariableResolver source, String mimeType, int statusCode) {
        this.readerName = name;
        this.source = source;
        this.mimeType = mimeType;
        this.statusCode = statusCode;
    }

    public void setParameters(Map parameterMap) {
        this.parameters = parameterMap;
    }

    public final boolean invoke(Environment env, InvokeContext context) throws Exception {
        Map objectModel = env.getObjectModel();
        StreamPipeline pipeline = context.getStreamPipeline();
        if (this.mimeType == null) {
            pipeline.setReader(this.readerName, this.source.resolve(context, objectModel), VariableResolver.buildParameters(this.parameters, context, objectModel));
        } else {
            pipeline.setReader(this.readerName, this.source.resolve(context, objectModel), VariableResolver.buildParameters(this.parameters, context, objectModel), this.mimeType);
        }
        if (this.statusCode >= 0) {
            env.setStatus(this.statusCode);
        }
        if (!context.isInternalRequest()) {
            return pipeline.process(env);
        }
        return true;
    }
}

