/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source;

import org.apache.avalon.framework.component.ComponentManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.components.source.AbstractSAXSource;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.apache.log.Logger;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;
import org.xmldb.api.modules.XPathQueryService;

public class XMLDBSource
extends AbstractSAXSource {
    protected String url;
    protected String query = null;
    protected String systemId;
    protected static final String URI = "http://apache.org/cocoon/xmldb/1.0";
    protected static final String PREFIX = "collection";
    protected static final String COLLECTIONS = "collections";
    protected static final String QCOLLECTIONS = "collection:collections";
    protected static final String RESOURCE_COUNT_ATTR = "resources";
    protected static final String COLLECTION_COUNT_ATTR = "collections";
    protected static final String COLLECTION = "collection";
    protected static final String QCOLLECTION = "collection:collection";
    protected static final String RESOURCE = "resource";
    protected static final String QRESOURCE = "collection:resource";
    protected static final String NAME_ATTR = "name";
    protected static final String RESULTSET = "results";
    protected static final String QRESULTSET = "collection:results";
    protected static final String QUERY_ATTR = "query";
    protected static final String RESULTS_COUNT_ATTR = "resources";
    protected static final String RESULT = "result";
    protected static final String QRESULT = "collection:result";
    protected static final String RESULT_DOCID_ATTR = "docid";
    protected static final String RESULT_ID_ATTR = "id";
    protected static final String CDATA = "CDATA";

    public XMLDBSource(Environment environment, ComponentManager manager, Logger logger, String url) {
        super(environment, manager, logger);
        int start = url.indexOf(35);
        if (start != -1) {
            this.url = url.substring(0, start);
            this.query = url.substring(start + 1);
        } else {
            this.url = url;
        }
    }

    public void toSAX(ContentHandler handler) throws SAXException, ProcessingException {
        if (this.url.endsWith("/")) {
            this.collectionToSAX(handler);
        } else {
            this.resourceToSAX(handler);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void resourceToSAX(ContentHandler handler) throws SAXException, ProcessingException {
        String col = this.url.substring(0, this.url.lastIndexOf(47));
        String res = this.url.substring(this.url.lastIndexOf(47) + 1);
        Collection collection = null;
        try {
            try {
                collection = DatabaseManager.getCollection((String)col);
                if (collection == null) {
                    throw new ResourceNotFoundException("Document " + this.url + " not found");
                }
                XMLResource xmlResource = (XMLResource)collection.getResource(res);
                if (xmlResource == null) {
                    throw new ResourceNotFoundException("Document " + this.url + " not found");
                }
                if (this.query != null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Querying resource " + res + " from collection " + this.url + "; query= " + this.query);
                    }
                    this.queryToSAX(handler, collection, res);
                } else {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Obtaining resource " + res + " from collection " + col);
                    }
                    xmlResource.getContentAsSAX(handler);
                }
            }
            catch (XMLDBException xde) {
                String error = "Unable to fetch content. Error " + xde.errorCode + ": " + xde.getMessage();
                this.log.debug(error, (Throwable)xde);
                throw new SAXException(error, (Exception)((Object)xde));
            }
            Object var8_7 = null;
            if (collection == null) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (collection == null) throw throwable;
            try {
                collection.close();
                throw throwable;
            }
            catch (XMLDBException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (XMLDBException ignored) {}
        collection.close();
        return;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void collectionToSAX(ContentHandler handler) throws SAXException, ProcessingException {
        Collection collection;
        block13: {
            AttributesImpl attributes = new AttributesImpl();
            collection = null;
            collection = DatabaseManager.getCollection((String)this.url);
            if (collection == null) {
                throw new ResourceNotFoundException("Collection " + this.url + " not found");
            }
            if (this.query != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Querying collection " + this.url + "; query= " + this.query);
                }
                this.queryToSAX(handler, collection, null);
                break block13;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Listing collection " + this.url);
            }
            String ncollections = Integer.toString(collection.getChildCollectionCount());
            String nresources = Integer.toString(collection.getResourceCount());
            attributes.addAttribute("", "resources", "resources", CDATA, nresources);
            attributes.addAttribute("", "collections", "collections", CDATA, ncollections);
            handler.startDocument();
            handler.startPrefixMapping("collection", URI);
            handler.startElement(URI, "collections", QCOLLECTIONS, attributes);
            String[] collections = collection.listChildCollections();
            int i = 0;
            while (i < collections.length) {
                attributes.clear();
                attributes.addAttribute("", NAME_ATTR, NAME_ATTR, CDATA, collections[i]);
                handler.startElement(URI, "collection", QCOLLECTION, attributes);
                handler.endElement(URI, "collection", "collection");
                ++i;
            }
            String[] resources = collection.listResources();
            int i2 = 0;
            while (i2 < resources.length) {
                attributes.clear();
                attributes.addAttribute("", NAME_ATTR, NAME_ATTR, CDATA, resources[i2]);
                handler.startElement(URI, RESOURCE, QRESOURCE, attributes);
                handler.endElement(URI, RESOURCE, RESOURCE);
                ++i2;
            }
            handler.endElement(URI, "collections", QCOLLECTIONS);
            handler.endPrefixMapping("collection");
            handler.endDocument();
        }
        Object var11_12 = null;
        if (collection == null) return;
        try {
            collection.close();
            return;
        }
        catch (XMLDBException ignored) {}
        return;
        {
            catch (XMLDBException xde) {
                String error = "Collection listing failed. Error " + xde.errorCode + ": " + xde.getMessage();
                this.log.debug(error, (Throwable)xde);
                throw new SAXException(error, (Exception)((Object)xde));
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (collection == null) throw throwable;
            try {
                collection.close();
                throw throwable;
            }
            catch (XMLDBException ignored) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private void queryToSAX(ContentHandler handler, Collection collection, String resource) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        try {
            XPathQueryService service = (XPathQueryService)collection.getService("XPathQueryService", "1.0");
            ResourceSet resultSet = resource == null ? service.query(this.query) : service.queryResource(resource, this.query);
            attributes.addAttribute("", QUERY_ATTR, QUERY_ATTR, CDATA, this.query);
            attributes.addAttribute("", "resources", "resources", CDATA, Long.toString(resultSet.getSize()));
            handler.startDocument();
            handler.startPrefixMapping("collection", URI);
            handler.startElement(URI, RESULTSET, QRESULTSET, attributes);
            IncludeXMLConsumer includeHandler = new IncludeXMLConsumer(handler);
            ResourceIterator results = resultSet.getIterator();
            while (results.hasMoreResources()) {
                XMLResource result = (XMLResource)results.nextResource();
                String id = result.getId();
                String documentId = result.getDocumentId();
                attributes.clear();
                if (id != null) {
                    attributes.addAttribute("", RESULT_ID_ATTR, RESULT_ID_ATTR, CDATA, id);
                }
                if (documentId != null) {
                    attributes.addAttribute("", RESULT_DOCID_ATTR, RESULT_DOCID_ATTR, CDATA, documentId);
                }
                handler.startElement(URI, RESULT, QRESULT, attributes);
                result.getContentAsSAX((ContentHandler)includeHandler);
                handler.endElement(URI, RESULT, RESULT);
            }
            handler.endElement(URI, RESULTSET, QRESULTSET);
            handler.endPrefixMapping("collection");
            handler.endDocument();
        }
        catch (XMLDBException xde) {
            String error = "Query failed. Error " + xde.errorCode + ": " + xde.getMessage();
            this.log.debug(error, (Throwable)xde);
            throw new SAXException(error, (Exception)((Object)xde));
        }
    }

    public void recycle() {
        this.log = null;
        this.manager = null;
        this.url = null;
        this.query = null;
    }

    public String getSystemId() {
        return this.url;
    }
}

