/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.resolver;

import java.io.IOException;
import org.apache.avalon.excalibur.xml.EntityResolver;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.resolver.Resolver;
import org.apache.cocoon.environment.Context;
import org.apache.xml.resolver.helpers.Debug;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ResolverImpl
extends AbstractLoggable
implements EntityResolver,
Resolver,
Contextualizable,
Composable,
Parameterizable,
ThreadSafe,
Disposable {
    protected CatalogResolver catalogResolver = new CatalogResolver();
    protected ComponentManager manager = null;
    protected Context context;

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this.context = (Context)context.get((Object)"environment-context");
    }

    public void parameterize(Parameters params) throws ParameterException {
        int debugLevel = Debug.getDebug();
        String verbosity = params.getParameter("verbosity", "");
        if (verbosity != "") {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Setting Catalog resolver verbosity level to " + verbosity);
            }
            int verbosityLevel = 0;
            try {
                verbosityLevel = Integer.parseInt(verbosity);
                Debug.setDebug((int)verbosityLevel);
            }
            catch (NumberFormatException ce1) {
                this.getLogger().warn("Trouble setting Catalog verbosity", (Throwable)ce1);
            }
        }
        String catalogFile = params.getParameter("catalog", "/resources/entities/catalog");
        try {
            String catalogURL = null;
            catalogURL = this.context.getRealPath(catalogFile);
            if (catalogURL == null) {
                catalogURL = this.context.getResource(catalogFile).toExternalForm();
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("System OASIS Catalog URL is " + catalogURL);
            }
            this.catalogResolver.getCatalog().parseCatalog(catalogURL);
        }
        catch (Exception e) {
            this.getLogger().warn("Could not get Catalog URL", (Throwable)e);
        }
        String localCatalogFile = params.getParameter("local-catalog", null);
        if (localCatalogFile != null) {
            try {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Additional Catalog is " + localCatalogFile);
                }
                this.catalogResolver.getCatalog().parseCatalog(localCatalogFile);
            }
            catch (Exception e) {
                this.getLogger().warn("Could not get local Catalog file", (Throwable)e);
            }
        }
    }

    public void compose(ComponentManager manager) throws ComponentException {
        if (this.manager == null && manager != null) {
            this.manager = manager;
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource altInputSource = this.catalogResolver.resolveEntity(publicId, systemId);
        if (altInputSource != null && this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Resolved catalog entity: " + publicId + " " + altInputSource.getSystemId());
        }
        return altInputSource;
    }

    public void dispose() {
    }
}

