/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.pipeline;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ConnectionResetException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheValidity;
import org.apache.cocoon.caching.Cacheable;
import org.apache.cocoon.caching.CachedStreamObject;
import org.apache.cocoon.caching.CachingOutputStream;
import org.apache.cocoon.caching.ComponentCacheKey;
import org.apache.cocoon.caching.PipelineCacheKey;
import org.apache.cocoon.components.pipeline.AbstractStreamPipeline;
import org.apache.cocoon.components.pipeline.CacheableEventPipeline;
import org.apache.cocoon.components.store.Store;
import org.apache.cocoon.environment.Environment;
import org.xml.sax.SAXException;

public class CachingStreamPipeline
extends AbstractStreamPipeline {
    private String serializerRole;
    private String readerRole;
    private Store streamCache;

    public void compose(ComponentManager manager) throws ComponentException {
        super.compose(manager);
        this.streamCache = (Store)this.manager.lookup("org.apache.cocoon.components.store.Store/TransientCache");
    }

    public void dispose() {
        this.manager.release((Component)this.streamCache);
        super.dispose();
    }

    public void setSerializer(String role, String source, Parameters param, String mimeType) throws Exception {
        super.setSerializer(role, source, param, mimeType);
        this.serializerRole = role;
    }

    public void setReader(String role, String source, Parameters param, String mimeType) throws Exception {
        super.setReader(role, source, param, mimeType);
        this.readerRole = role;
    }

    protected boolean processReader(Environment environment) throws ProcessingException {
        try {
            this.reader.setup(environment, environment.getObjectModel(), this.readerSource, this.readerParam);
            String mimeType = this.reader.getMimeType();
            if (mimeType != null) {
                environment.setContentType(mimeType);
            } else if (this.readerMimeType != null) {
                environment.setContentType(this.readerMimeType);
            } else {
                environment.setContentType(this.sitemapReaderMimeType);
            }
            long lastModified = this.reader.getLastModified();
            if (lastModified != 0L && !environment.isResponseModified(lastModified)) {
                environment.setResponseIsNotModified();
                return true;
            }
        }
        catch (SAXException e) {
            this.getLogger().debug("SAXException in ProcessReader", (Throwable)e);
            throw new ProcessingException("Failed to execute pipeline.", e);
        }
        catch (IOException e) {
            this.getLogger().debug("IOException in ProcessReader", (Throwable)e);
            throw new ProcessingException("Failed to execute pipeline.", e);
        }
        try {
            boolean usedCache = false;
            PipelineCacheKey pcKey = null;
            HashMap<ComponentCacheKey, CacheValidity> validityObjects = new HashMap<ComponentCacheKey, CacheValidity>();
            OutputStream outputStream = environment.getOutputStream();
            long readerKey = 0L;
            CacheValidity readerValidity = null;
            if (this.reader instanceof Cacheable && (readerKey = ((Cacheable)((Object)this.reader)).generateKey()) != 0L && (readerValidity = ((Cacheable)((Object)this.reader)).generateValidity()) != null) {
                pcKey = new PipelineCacheKey();
                ComponentCacheKey ccKey = new ComponentCacheKey(4, this.readerRole, readerKey);
                validityObjects.put(ccKey, readerValidity);
                pcKey.addKey(ccKey);
                CachedStreamObject cachedObject = (CachedStreamObject)this.streamCache.get(pcKey);
                if (cachedObject != null) {
                    this.getLogger().debug("Found cached response for '" + environment.getURI() + "'.");
                    Iterator validityIterator = validityObjects.keySet().iterator();
                    boolean valid = true;
                    while (validityIterator.hasNext() && valid) {
                        ComponentCacheKey validityKey = (ComponentCacheKey)validityIterator.next();
                        valid = cachedObject.isValid(validityKey, (CacheValidity)validityObjects.get(validityKey));
                        if (!this.getLogger().isDebugEnabled()) continue;
                        CacheValidity cachedValidity = cachedObject.getCacheValidity(validityKey);
                        this.getLogger().debug("Compared cached validity '" + cachedValidity + "' with new validity '" + validityObjects.get(validityKey) + "' : " + (valid ? "valid" : "changed"));
                    }
                    if (valid) {
                        this.getLogger().debug("Using valid cached content for '" + environment.getURI() + "'.");
                        byte[] response = cachedObject.getResponse();
                        if (response.length > 0) {
                            usedCache = true;
                            environment.setContentLength(response.length);
                            outputStream.write(response);
                        }
                    }
                    if (!usedCache) {
                        this.getLogger().debug("Cached content is invalid for '" + environment.getURI() + "'.");
                        this.streamCache.remove(pcKey);
                        cachedObject = null;
                    }
                }
                if (cachedObject == null) {
                    this.getLogger().debug("Caching content for further requests of '" + environment.getURI() + "'.");
                    outputStream = new CachingOutputStream(outputStream);
                }
            }
            if (!usedCache) {
                if (this.reader.shouldSetContentLength()) {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    this.reader.setOutputStream(os);
                    this.reader.generate();
                    byte[] data = os.toByteArray();
                    environment.setContentLength(data.length);
                    outputStream.write(data);
                } else {
                    this.reader.setOutputStream(outputStream);
                    this.reader.generate();
                }
                if (pcKey != null) {
                    this.streamCache.store(pcKey, new CachedStreamObject(validityObjects, ((CachingOutputStream)outputStream).getContent()));
                }
            }
        }
        catch (SocketException se) {
            if (se.getMessage().indexOf("reset") > 0 || se.getMessage().indexOf("aborted") > 0) {
                throw new ConnectionResetException("Connection reset by peer", se);
            }
            this.getLogger().debug("SocketException in ProcessReader", (Throwable)se);
            throw new ProcessingException("Failed to execute pipeline.", se);
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            this.getLogger().debug("Exception in ProcessReader", (Throwable)e);
            throw new ProcessingException("Failed to execute pipeline.", e);
        }
        return true;
    }

    public boolean process(Environment environment) throws ProcessingException {
        if (this.reader != null) {
            return super.process(environment);
        }
        if (!this.checkPipeline()) {
            throw new ProcessingException("Attempted to process incomplete pipeline.");
        }
        try {
            boolean usedCache = false;
            PipelineCacheKey pcKey = null;
            Map validityObjects = null;
            OutputStream outputStream = environment.getOutputStream();
            this.setupPipeline(environment);
            this.connectPipeline();
            long serializerKey = 0L;
            PipelineCacheKey eventPipelineKey = null;
            CacheValidity serializerValidity = null;
            Map eventPipelineValidity = null;
            if (this.eventPipeline instanceof CacheableEventPipeline) {
                if (this.serializer instanceof Cacheable && (serializerKey = ((Cacheable)((Object)this.serializer)).generateKey()) != 0L && (serializerValidity = ((Cacheable)((Object)this.serializer)).generateValidity()) != null && (eventPipelineKey = ((CacheableEventPipeline)((Object)this.eventPipeline)).generateKey(environment)) != null && (eventPipelineValidity = ((CacheableEventPipeline)((Object)this.eventPipeline)).generateValidity(environment)) != null) {
                    ((CacheableEventPipeline)((Object)this.eventPipeline)).setStreamPipelineCaches(true);
                    validityObjects = eventPipelineValidity;
                    pcKey = new PipelineCacheKey();
                    ComponentCacheKey ccKey = new ComponentCacheKey(3, this.serializerRole, serializerKey);
                    validityObjects.put(ccKey, serializerValidity);
                    pcKey.addKey(ccKey);
                    pcKey.addKey(eventPipelineKey);
                    CachedStreamObject cachedObject = (CachedStreamObject)this.streamCache.get(pcKey);
                    if (cachedObject != null) {
                        this.getLogger().debug("Found cached response for '" + environment.getURI() + "'.");
                        Iterator validityIterator = validityObjects.keySet().iterator();
                        boolean valid = true;
                        while (validityIterator.hasNext() && valid) {
                            ComponentCacheKey validityKey = (ComponentCacheKey)validityIterator.next();
                            valid = cachedObject.isValid(validityKey, (CacheValidity)validityObjects.get(validityKey));
                            if (!this.getLogger().isDebugEnabled()) continue;
                            CacheValidity cachedValidity = cachedObject.getCacheValidity(validityKey);
                            this.getLogger().debug("Compared cached validity '" + cachedValidity + "' with new validity '" + validityObjects.get(validityKey) + "' : " + (valid ? "valid" : "changed"));
                        }
                        if (valid) {
                            this.getLogger().debug("Using valid cached content for '" + environment.getURI() + "'.");
                            byte[] bytes = cachedObject.getResponse();
                            if (bytes.length > 0) {
                                usedCache = true;
                                environment.setContentLength(bytes.length);
                                outputStream.write(bytes);
                            }
                        }
                        if (!usedCache) {
                            this.getLogger().debug("Cached content is invalid for '" + environment.getURI() + "'.");
                            this.streamCache.remove(pcKey);
                            cachedObject = null;
                        }
                    }
                    if (cachedObject == null) {
                        this.getLogger().debug("Caching content for further requests of '" + environment.getURI() + "'.");
                        outputStream = new CachingOutputStream(outputStream);
                    }
                } else {
                    ((CacheableEventPipeline)((Object)this.eventPipeline)).setStreamPipelineCaches(false);
                }
            }
            if (!usedCache) {
                if (this.serializer.shouldSetContentLength()) {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    this.serializer.setOutputStream(os);
                    this.eventPipeline.process(environment);
                    byte[] data = os.toByteArray();
                    environment.setContentLength(data.length);
                    outputStream.write(data);
                } else {
                    this.serializer.setOutputStream(outputStream);
                    this.eventPipeline.process(environment);
                }
                if (pcKey != null) {
                    byte[] bytes = ((CachingOutputStream)outputStream).getContent();
                    this.streamCache.store(pcKey, new CachedStreamObject(validityObjects, bytes));
                }
            }
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            this.getLogger().debug("Exception in process", (Throwable)e);
            throw new ProcessingException("Failed to execute pipeline.", e);
        }
        return true;
    }

    public void recycle() {
        this.getLogger().debug("Recycling of CachingStreamPipeline");
        super.recycle();
        this.serializerRole = null;
        this.readerRole = null;
    }
}

